/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class IctDataMutexUtil {
    private static Log logger = LogFactory.getLog(IctDataMutexUtil.class);
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static SimpleDateFormat timesdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String MUTEX_DATAOBJID = "dataObjId";
    private static final String MUTEX_GROUPID = "groupId";
    private static final String MUTEX_ENTITYKEY = "entityKey";
    private static final String MUTEX_OPERATIONKEY = "operationKey";
    private static final String MUTEX_ISSTRICT = "isStrict";

    public static Map<Long, String> requireMutex(String entityKey, Set<Long> billids) {
        HashMap<Long, String> returnMsg = new HashMap<Long, String>(billids.size());
        boolean isStrict = true;
        String netGroupId = "default_netctrl";
        ArrayList mutexRequireList = new ArrayList(billids.size());
        for (Long billid : billids) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
            requireParam.put(MUTEX_DATAOBJID, billid.toString());
            requireParam.put(MUTEX_GROUPID, netGroupId);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, "modify");
            requireParam.put(MUTEX_ISSTRICT, isStrict);
            mutexRequireList.add(requireParam);
        }
        HashMap<Long, String> userMap = new HashMap<Long, String>(4);
        try (DataMutex dataMutex = DataMutex.create();){
            Map mutexResult = dataMutex.batchrequire(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String objId = (String)mutexItem.getKey();
                Boolean ret = (Boolean)mutexItem.getValue();
                Long ID = Long.valueOf(objId);
                if (ret.booleanValue()) continue;
                Map lockInfo = dataMutex.getLockInfo(objId, netGroupId, entityKey);
                StringBuilder sb = new StringBuilder();
                if (lockInfo != null) {
                    Long timeL;
                    DynamicObject userObj;
                    sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237", (String)"IctDataMutexUtil_0", (String)"fi-ict-common", (Object[])new Object[0]));
                    Long userid = Long.valueOf((String)lockInfo.get("userid"));
                    if (Objects.isNull(userMap.get(userid)) && (userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)userid, (String)"bos_user", (String)"name")) != null) {
                        userMap.put(userid, userObj.getString("name"));
                    }
                    sb.append((String)userMap.get(userid));
                    String timeStr = (String)lockInfo.get("lockedTime");
                    if (timeStr != null && (timeL = Long.valueOf(Long.parseLong(timeStr))) != null) {
                        sb.append(ResManager.loadKDString((String)"\u5728", (String)"IctDataMutexUtil_1", (String)"fi-ict-common", (Object[])new Object[0])).append(timesdf.format(new Date(timeL)));
                    }
                    sb.append(ResManager.loadKDString((String)"\u9501\u5b9a", (String)"IctDataMutexUtil_2", (String)"fi-ict-common", (Object[])new Object[0]));
                } else {
                    sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237\u9501\u5b9a", (String)"IctDataMutexUtil_3", (String)"fi-ict-common", (Object[])new Object[0]));
                }
                returnMsg.put(ID, sb.toString());
            }
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519\uff1a%s\u3002", (String)"IctDataMutexUtil_4", (String)"fi-ict-common", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
        return returnMsg;
    }

    public static void batchRelease(String entityNumber, Set<Long> lockIDs) {
        String netGroupId = "default_netctrl";
        if (!lockIDs.isEmpty()) {
            ArrayList mutexRequireList = new ArrayList(lockIDs.size());
            for (Long lockID : lockIDs) {
                HashMap<String, String> requireParam = new HashMap<String, String>(8);
                requireParam.put(MUTEX_DATAOBJID, lockID.toString());
                requireParam.put(MUTEX_GROUPID, netGroupId);
                requireParam.put(MUTEX_ENTITYKEY, entityNumber);
                requireParam.put(MUTEX_OPERATIONKEY, "modify");
                mutexRequireList.add(requireParam);
            }
            try (DataMutex dataMutex = DataMutex.create();){
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String objId = (String)releaseItem.getKey();
                    if (releaseRet) continue;
                    logger.info("\u91ca\u653e\u6570\u636e\u5bf9\u8c61[" + objId + "]\u4e92\u65a5\u9501\u5931\u8d25.");
                }
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519%s", (String)"IctDataMutexUtil_5", (String)"fi-ict-common", (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
        }
    }
}

