/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.util.PermissonType;

public class ListFilterUtils {
    public static void initListOrgFilter(IListView listView, FilterContainerInitArgs args) {
        String billFormID = listView.getBillFormId();
        List listFilterColumns = args.getCommonFilterColumns();
        for (CommonFilterColumn commFilter : listFilterColumns) {
            String fieldName = commFilter.getFieldName();
            if (!fieldName.startsWith("org.") && !fieldName.startsWith("useorg.")) continue;
            List<ComboItem> comboItems = AccSysUtil.getAllAcctOrgComboItem(billFormID, true, PermissonType.VIEW);
            commFilter.setComboItems(comboItems);
            if (comboItems.isEmpty()) continue;
            commFilter.setDefaultValue(ListFilterUtils.getDefaultId(comboItems));
        }
    }

    public static void initListBookFilter(IFormView view, List<FilterColumn> listFilterColumns) {
        for (CommonFilterColumn commonFilterColumn : listFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("booktype.")) continue;
            DynamicObject mainBookType = AccSysUtil.getMainBookType();
            final ComboItem comboItem = new ComboItem();
            comboItem.setId(mainBookType.getString("id"));
            comboItem.setCaption(new LocaleString(mainBookType.getString("name")));
            ArrayList<ComboItem> comboItemlst = new ArrayList<ComboItem>(){
                {
                    this.add(comboItem);
                }
            };
            commonFilterColumn.setComboItems((List)comboItemlst);
            commonFilterColumn.setDefaultValue(comboItem.getValue());
        }
    }

    public static void initListAcctTableFilter(IFormView view, List<FilterColumn> listFilterColumns) {
        for (CommonFilterColumn commonFilterColumn : listFilterColumns) {
            List comboItems;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("accounttable.") || (comboItems = commonFilterColumn.getComboItems()).size() <= 0) continue;
            String defBookType = ((ComboItem)comboItems.get(0)).getValue();
            commonFilterColumn.setDefaultValue(defBookType);
        }
    }

    public static void setPeriodTypeDefaultValue(IFormView view, String orgField) {
        QFilter fbookstype;
        IDataModel model = view.getModel();
        DynamicObject mainBookType = AccSysUtil.getMainBookType();
        MulBasedataDynamicObjectCollection mulOrg = (MulBasedataDynamicObjectCollection)model.getValue(orgField);
        Set orgIds = mulOrg.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toSet());
        DynamicObjectCollection periodType = BatchProcessUtil.batchQueryDynColl(orgIds, arg_0 -> ListFilterUtils.lambda$setPeriodTypeDefaultValue$1(fbookstype = new QFilter("bookstype", "=", (Object)mainBookType.getLong("id")), arg_0));
        if (!periodType.isEmpty()) {
            model.setValue("periodtype", (Object)((DynamicObject)periodType.get(0)).getLong("periodtype"));
        } else {
            model.setValue("periodtype", null);
        }
    }

    public static String getDefaultId(List<ComboItem> items) {
        long currOrgId = RequestContext.get().getOrgId();
        for (ComboItem item : items) {
            if (!Objects.nonNull(item) || item.getValue().length() <= 0 || !Long.valueOf(item.getValue()).equals(currOrgId)) continue;
            return currOrgId + "";
        }
        return items.get(0).getValue();
    }

    private static /* synthetic */ DynamicObjectCollection lambda$setPeriodTypeDefaultValue$1(QFilter fbookstype, Collection batchData) {
        QFilter fOrgIds = new QFilter("org", "in", (Object)batchData);
        return QueryServiceHelper.query((String)"gl_accountbook", (String)"periodtype", (QFilter[])new QFilter[]{fbookstype, fOrgIds});
    }
}

