/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PeriodUtil {
    public static final Long MAX_PERIOD = 99999999999L;
    public static final Long TYPE_PERIOD_L = 100000000L;
    public static final Long YEAR_PERIOD_L = 10000L;
    public static final Long NUM_PERIOD_L = 10L;

    public static DynamicObject getPeriodByDate(Date date, long periodType) {
        String selectField = "id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name";
        return PeriodUtil.getPeriodByDate(date, selectField, periodType);
    }

    public static DynamicObject getPeriodByDate(Date date, String selectField, long periodType) {
        QFilter f = new QFilter("beginDate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t});
        return period;
    }

    public static DynamicObject getCurrentPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        return BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(curPeriodId.toString()), (String)entityName, (String)"periodtype,periodyear,periodnumber,begindate,enddate");
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId) {
        return PeriodUtil.getPreviousPeriod(curPeriodId, true);
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId, boolean isAdjustPeriod) {
        QFilter filterNum;
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(curPeriodId.toString()), (String)entityName, (String)"periodtype,periodyear,periodnumber,isadjustperiod");
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter pYear = new QFilter("periodyear", "<", (Object)currPeriod.getInt("periodyear"));
        if (isAdjustPeriod && currPeriod.getBoolean("isadjustperiod")) {
            filterNum = new QFilter("periodnumber", "<=", (Object)currPeriod.getInt("periodnumber"));
            filterNum.and("id", "!=", (Object)currPeriod.getLong("id"));
        } else {
            filterNum = new QFilter("periodnumber", "<", (Object)currPeriod.getInt("periodnumber"));
        }
        QFilter pfilter = filterYear.and(filterNum);
        pfilter.or(pYear);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter}, (String)"periodyear desc, periodnumber desc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static DynamicObject getNextPeriod(Object curPeriodId) {
        return PeriodUtil.getNextPeriod(curPeriodId, true);
    }

    public static DynamicObject getNextPeriod(Object curPeriodId, boolean isAdjustPeriod) {
        DynamicObject nextPeriod = null;
        if (!ObjectUtils.isEmpty((Object)curPeriodId)) {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)entityName);
            Object periodtypeid = currPeriod.get("periodtype_id");
            QFilter filterDate = new QFilter("id", ">", curPeriodId);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            DynamicObjectCollection coll = null;
            if (isAdjustPeriod) {
                coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id", (int)1);
            } else {
                QFilter filterAdjustPeriod = new QFilter("isadjustperiod", "=", (Object)isAdjustPeriod);
                coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType, filterAdjustPeriod}, (String)"id", (int)1);
            }
            if (coll != null && !coll.isEmpty()) {
                nextPeriod = (DynamicObject)coll.get(0);
            }
        }
        return nextPeriod;
    }

    public static Set<Long> getPeriodIdSet(Date beginDate, Date endDate) {
        QFilter beginDateFilter = new QFilter("begindate", "<=", (Object)endDate);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)beginDate);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{beginDateFilter, endDateFilter});
        HashSet<Long> pdIdSet = new HashSet<Long>();
        for (DynamicObject pd : coll) {
            pdIdSet.add(pd.getLong("id"));
        }
        return pdIdSet;
    }

    public static Set<Long> getPeriodIdSet(Long periodTypeId, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("begindate", "<=", (Object)endDate);
        filter.and(new QFilter("enddate", ">=", (Object)beginDate));
        filter.and(new QFilter("periodtype", "=", (Object)periodTypeId));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])filter.toArray());
        HashSet<Long> pdIdSet = new HashSet<Long>();
        for (DynamicObject pd : coll) {
            pdIdSet.add(pd.getLong("id"));
        }
        return pdIdSet;
    }

    public static List<Long> getAvailableEndPeriodIds(String tableName, String compare, Long period, Long[] orgIds) {
        List<Long> availablePeriodids = PeriodUtil.getAvailableEndPeriodIds(tableName, orgIds, PeriodUtil.getPeriodIds(compare, period));
        if (availablePeriodids.size() == 0) {
            availablePeriodids.add(MAX_PERIOD);
        }
        return availablePeriodids;
    }

    public static List<Long> getPeriodIds(String compare, Long period) {
        if (period == 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(0L);
            return ids;
        }
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(period / TYPE_PERIOD_L));
        QFilter periodFilter = new QFilter("id", compare, (Object)period);
        ArrayList<Long> result = new ArrayList<Long>();
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, periodFilter}, null);){
            for (Row r : rs) {
                result.add(r.getLong(0));
            }
        }
        if (compare.equalsIgnoreCase("<") || compare.equalsIgnoreCase("<=")) {
            result.add(0L);
        } else if (compare.equalsIgnoreCase(">") || compare.equalsIgnoreCase(">=")) {
            result.add(MAX_PERIOD);
        }
        return result;
    }

    public static List<Long> getAvailableEndPeriodIds(String tableName, Long[] orgIds, List<Long> periodid) {
        if (orgIds == null || orgIds.length == 0) {
            return periodid;
        }
        ArrayList<Long> availablePeriodids = new ArrayList<Long>(periodid.size());
        SqlBuilder sql = new SqlBuilder();
        sql.appendIn(String.format("select distinct fendperiodid from %s where forgid ", tableName), (Object[])orgIds);
        sql.appendIn("and fendperiodid", periodid.toArray());
        try (DataSet ds = DB.queryDataSet((String)"PeriodUtil.getAvailablePeriod", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : ds) {
                availablePeriodids.add(row.getLong("fendperiodid"));
            }
        }
        return availablePeriodids;
    }
}

