/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.fi.ict.constant.BalanceQueryParam;
import kd.fi.ict.constant.CashflowQueryParam;

public class RelTransInitUtils {
    private static final String CFITEM = "cfitem";
    private static final String YEARAMOUNT = "yearamount";
    private static final String AMOUNT = "amount";
    private static final String DC = "dc";
    private static final String BEGINLOCAL = "beginlocal";
    private static final String BEGINFOR = "beginfor";
    private static final String INIT_ACCT_SELECTFIELDS = "org,booktype,currency,currencyloc,account.masterid account,account.id accountid,assgrp, assgrp.value, debitamount,debitamountlocal,creditamount,creditamountlocal";
    private static final String INIT_CF_SELECTFIELDS = "org,booktype, currency,cashflowitem.masterid cashflowitem,cashflowitem.id cashflowitemid,cashflowitem.direction cfdc, cfassgrp, cfassgrp.value,cfamt";
    private static final String[] ACCT_ORDERBY = new String[]{"account", "currency", "assgrp"};
    private static final String[] CF_ORDERBY = new String[]{"cfitem", "currency", "assgrp"};
    private static final int INIT_CAPACITY = 32;
    private static final Log log = LogFactory.getLog(RelTransInitUtils.class);
    private static final String[] BALANCE_FIELDS = new String[]{"account", "dc", "currency", "beginfor", "beginlocal"};
    private static final String[] CASHFLOW_FIELDS = new String[]{"yearamount", "amount"};

    private RelTransInitUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Map<String, Object>> queryAcctBalance(Long orgId, Long bookTypeId, long curAccountTableId, Long periodId, Set<Long> accountIds, Long currencyId, DynamicObject itemAssgrp) {
        List<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>(32);
        BalanceQueryParam param = RelTransInitUtils.getActQueryParam(orgId, bookTypeId, curAccountTableId, periodId, accountIds, currencyId, itemAssgrp);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BalanceService", (String)"getBalance", (Object[])new Object[]{param.toString()});
        if (result != null) {
            try {
                rowList = (List)JSONUtils.cast((String)result, List.class);
            }
            catch (IOException e) {
                log.error(String.format("\u7ec4\u7ec7%s\u83b7\u53d6\u4f59\u989d\u8868\u4fe1\u606f\u5931\u8d25\uff1a%s", orgId, e.getMessage()));
                throw new KDBizException(e.getMessage());
            }
        }
        return rowList;
    }

    private static BalanceQueryParam getActQueryParam(Long orgId, Long bookTypeId, long curAccountTableId, Long periodId, Set<Long> accountIds, Long currencyId, DynamicObject itemAssgrp) {
        BalanceQueryParam param = new BalanceQueryParam();
        param.setOrgId(orgId);
        param.setBookTypeId(bookTypeId);
        param.setPeriodId(periodId);
        param.setSubstractPL(true);
        ArrayList<Map<String, Long>> map = new ArrayList<Map<String, Long>>(32);
        if (itemAssgrp != null) {
            String assgrpKey = itemAssgrp.getString("flexfield");
            HashMap assistMap = new HashMap(10);
            if (!StringUtils.isEmpty((String)assgrpKey)) {
                assistMap.put(assgrpKey, null);
                map.add(assistMap);
                assistMap.keySet().forEach(value -> param.addGroupBy((String)value));
            }
        }
        for (Long accountId : accountIds) {
            param.setAccountAssgrp(accountId, map);
        }
        param.addGroupBy("account");
        param.addGroupBy(DC);
        param.addGroupBy("currency");
        param.setAccountTableId(curAccountTableId);
        for (String prop : BALANCE_FIELDS) {
            param.addSelector(prop);
        }
        param.setSpecialAccount(true);
        return param;
    }

    public static List<Map<String, Object>> queryCFBalance(Long orgId, Long bookTypeId, Long periodId, Set<Long> cfItemIds, DynamicObject itemAssgrp) {
        List<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>(32);
        CashflowQueryParam param = RelTransInitUtils.getCFQueryParam(orgId, bookTypeId, periodId, cfItemIds, itemAssgrp);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"CashflowService", (String)"getCashFlowAmount", (Object[])new Object[]{param.toString()});
        if (result != null) {
            try {
                rowList = (List)JSONUtils.cast((String)result, List.class);
            }
            catch (IOException e) {
                log.error(String.format("\u7ec4\u7ec7%s\u83b7\u53d6\u73b0\u91d1\u6d41\u91cf\u8868\u4fe1\u606f\u5931\u8d25\uff1a%s", orgId, e.getMessage()));
                throw new KDBizException(e.getMessage());
            }
        }
        return rowList;
    }

    private static CashflowQueryParam getCFQueryParam(Long orgId, Long bookTypeId, Long periodId, Set<Long> cfItemIds, DynamicObject itemAssgrp) {
        String assgrpKey;
        CashflowQueryParam param = new CashflowQueryParam();
        param.setOrgId(orgId);
        param.setBookTypeId(bookTypeId);
        param.setPeriodId(periodId);
        if (itemAssgrp != null && !StringUtils.isEmpty((String)(assgrpKey = itemAssgrp.getString("flexfield")))) {
            param.setAssgrp(assgrpKey, null);
            param.addGroupBy(assgrpKey);
        }
        param.setCfitemIds(cfItemIds.toArray(new Long[0]));
        param.addGroupBy(CFITEM);
        param.addGroupBy("currency");
        for (String field : CASHFLOW_FIELDS) {
            param.addSelector(field);
        }
        return param;
    }
}

