/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.enums.VerifyType;

public class VerifySchemaUtils {
    protected static final Log log = LogFactory.getLog(VerifySchemaUtils.class);

    public static DynamicObject[] getVerifySchemaByOrg(Long orgId, VerifyType verifyType) {
        return VerifySchemaUtils.getVerifySchema(orgId, 0L, verifyType);
    }

    public static DynamicObject[] getVerifySchemaByOrgAndAcctTable(Long orgId, Long acctTable, VerifyType verifyType) {
        return VerifySchemaUtils.getVerifySchema(orgId, acctTable, verifyType);
    }

    public static DynamicObject[] getVerifySchema(Long orgId, Long acctTable, VerifyType verifyType) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"ict_verifyscheme", (Long)orgId);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        if (Objects.nonNull((Object)verifyType)) {
            if (verifyType == VerifyType.ACCT) {
                List<String> types = Arrays.asList("1", "2", "3");
                filter.and(new QFilter("transactiontype", "in", types));
                if (acctTable > 0L) {
                    filter.and(new QFilter("entryentity.e_accounttable", "=", (Object)acctTable));
                }
            } else if (verifyType == VerifyType.CF) {
                filter.and(new QFilter("transactiontype", "=", (Object)"4"));
            }
        } else {
            filter.and(new QFilter("transactiontype", "in", Arrays.asList("1", "2", "3", "4")));
        }
        log.info("\u7ec4\u7ec7%s\u5bf9\u8d26\u65b9\u6848\u8fc7\u6ee4\u6761\u4ef6:" + filter);
        String selectField = "transactiontype,accounttable,entryentity.account,entryentity.account.dc,entryentity.cashflowitem,entryentity.interiorassgrp,entryentity.commonassgrp,entryentity.e_accounttable";
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ict_verifyscheme", (String)selectField, (QFilter[])filter.toArray());
        log.info("\u7ec4\u7ec7%s\u5bf9\u8d26\u65b9\u6848:" + result.length);
        return result;
    }
}

