/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.openapi.common.custom.annotation.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.mservice.AcctAmtQueryParam;
import kd.fi.ict.util.AsstUtil;

@ApiModel
public class AcctAmtQueryParamApi {
    @ApiParam(value="\u67e5\u8be2\u5b57\u6bb5", required=true, example="[\"org\",\"pendfor\"]")
    private @ApiParam(value="\u67e5\u8be2\u5b57\u6bb5", required=true, example="[\"org\",\"pendfor\"]") List<String> selectors = new ArrayList<String>();
    @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true, example="\"org1\"")
    private @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true, example="\"org1\"") String orgNumber;
    @ApiParam(value="\u5bf9\u65b9\u7ec4\u7ec7\u7f16\u7801", example="[\"oporg1\",\"oporg2\"]")
    private @ApiParam(value="\u5bf9\u65b9\u7ec4\u7ec7\u7f16\u7801", example="[\"oporg1\",\"oporg2\"]") String[] opOrgNumbers;
    @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", required=true, example="\"100001\"")
    private @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", required=true, example="\"100001\"") String bookTypeNumber;
    @ApiParam(value="\u671f\u95f4\u7f16\u7801", required=true, example="\"202304\"")
    private @ApiParam(value="\u671f\u95f4\u7f16\u7801", required=true, example="\"202304\"") String periodNumber;
    @ApiParam(value="\u5e01\u522b\u7f16\u7801", example="\"CNY\"")
    private @ApiParam(value="\u5e01\u522b\u7f16\u7801", example="\"CNY\"") String currencyNumber;
    @ApiParam(value="\u79d1\u76ee\u8868\u7f16\u7801", example="\"100000\"")
    private @ApiParam(value="\u79d1\u76ee\u8868\u7f16\u7801", example="\"100000\"") String accountTableNumber;
    @ApiParam(value="\u79d1\u76ee\u7f16\u7801\uff1a\u591a\u7ec4\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801", example="{\"1001.01\":[{\"0001\":\"value1\"}]}")
    private @ApiParam(value="\u79d1\u76ee\u7f16\u7801\uff1a\u591a\u7ec4\u6838\u7b97\u7ef4\u5ea6\u7f16\u7801", example="{\"1001.01\":[{\"0001\":\"value1\"}]}") Map<String, List<Map<String, String>>> accountAssgrp = new HashMap<String, List<Map<String, String>>>();
    @ApiParam(value="\u5206\u7ec4\u5b57\u6bb5", example="[\"org\",\"pendfor\"]")
    private @ApiParam(value="\u5206\u7ec4\u5b57\u6bb5", example="[\"org\",\"pendfor\"]") List<String> groupBys = new ArrayList<String>();
    @ApiParam(value="\u6307\u5b9a\u79d1\u76ee\u67e5\u8be2", example="true")
    private @ApiParam(value="\u6307\u5b9a\u79d1\u76ee\u67e5\u8be2", example="true") boolean isSpecialAccount = true;
    @ApiParam(value="\u53d1\u751f\u989d\u4e3a\u96f6\u8fd4\u56de", example="false")
    private @ApiParam(value="\u53d1\u751f\u989d\u4e3a\u96f6\u8fd4\u56de", example="false") boolean returnZeroResult = false;
    @ApiParam(value="\u6838\u7b97\u7ef4\u5ea6\u540d\u79f0\u5c5e\u6027\u8fd4\u56de", example="false")
    private @ApiParam(value="\u6838\u7b97\u7ef4\u5ea6\u540d\u79f0\u5c5e\u6027\u8fd4\u56de", example="false") boolean returnAssgrpName = false;
    private Map<String, String> flexToNumberMap = new HashMap<String, String>();

    public List<String> getSelector() {
        return this.selectors;
    }

    public void addSelector(String selector) {
        this.selectors.add(selector);
    }

    public List<String> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<String> selectors) {
        this.selectors = selectors;
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public String[] getOpOrgNumbers() {
        return this.opOrgNumbers;
    }

    public void setOpOrgNumbers(String[] opOrgNumbers) {
        this.opOrgNumbers = opOrgNumbers;
    }

    public String getBookTypeNumber() {
        return this.bookTypeNumber;
    }

    public void setBookTypeNumber(String bookTypeNumber) {
        this.bookTypeNumber = bookTypeNumber;
    }

    public String getPeriodNumber() {
        return this.periodNumber;
    }

    public void setPeriodNumber(String periodNumber) {
        this.periodNumber = periodNumber;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public String getAccountTableNumber() {
        return this.accountTableNumber;
    }

    public void setAccountTableNumber(String accountTableNumber) {
        this.accountTableNumber = accountTableNumber;
    }

    public Map<String, List<Map<String, String>>> getAccountAssgrp() {
        return this.accountAssgrp;
    }

    public void setAccountAssgrp(Map<String, List<Map<String, String>>> accountAssgrp) {
        this.accountAssgrp = accountAssgrp;
    }

    public List<String> getGroupBy() {
        return this.groupBys;
    }

    public void addGroupBy(String groupBy) {
        this.groupBys.add(groupBy);
    }

    public List<String> getGroupBys() {
        return this.groupBys;
    }

    public void setGroupBys(List<String> groupBys) {
        this.groupBys = groupBys;
    }

    public Map<String, String> getFlexToNumberMap() {
        return this.flexToNumberMap;
    }

    public void setFlexToNumberMap(Map<String, String> flexToNumberMap) {
        this.flexToNumberMap = flexToNumberMap;
    }

    public String toString() {
        try {
            return JSONUtils.toString((Object)this);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
    }

    protected AcctAmtQueryParam toAcctAmtQueryParam() {
        long orgId;
        String orgTable = "bos_org";
        String bookTypeTable = "bd_accountbookstype";
        String currencyTable = "bd_currency";
        String accountTableTable = "bd_accounttable";
        if (StringUtils.isBlank((CharSequence)this.getOrgNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u65b9\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"AcctAmtQueryParamApi_0", (String)"fi-ict-webapi", (Object[])new Object[0]));
        }
        AcctAmtQueryParam param = new AcctAmtQueryParam();
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)orgTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getOrgNumber())});
        long l = orgId = orgDyn == null ? 0L : orgDyn.getLong("id");
        if (orgId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672c\u65b9\u7ec4\u7ec7\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AcctAmtQueryParamApi_1", (String)"fi-ict-webapi", (Object[])new Object[0]));
        }
        param.setOrgId(orgId);
        param.setOrgIds(new Long[]{orgId});
        if (this.getOpOrgNumbers() != null && this.getOpOrgNumbers().length > 0) {
            DynamicObjectCollection orgDyns = QueryServiceHelper.query((String)orgTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)this.getOpOrgNumbers())});
            ArrayList<Long> opOrgIds = new ArrayList<Long>(orgDyns.size());
            for (DynamicObject dyn : orgDyns) {
                opOrgIds.add(dyn.getLong("id"));
            }
            if (opOrgIds.size() != this.getOpOrgNumbers().length) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u65b9\u7ec4\u7ec7\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AcctAmtQueryParamApi_2", (String)"fi-ict-webapi", (Object[])new Object[0]));
            }
            param.setOpOrgIds(opOrgIds.toArray(new Long[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.getBookTypeNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"AcctAmtQueryParamApi_3", (String)"fi-ict-webapi", (Object[])new Object[0]));
        }
        DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)bookTypeTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getBookTypeNumber())});
        long bookTypeId = bookTypeDyn == null ? 0L : bookTypeDyn.getLong("id");
        param.setBookTypeId(bookTypeId);
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        if (bookInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AcctAmtQueryParamApi_4", (String)"fi-ict-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.getPeriodNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"AcctAmtQueryParamApi_5", (String)"fi-ict-webapi", (Object[])new Object[0]));
        }
        DynamicObject periodDyn = AsstUtil.queryPeriodIdByNumber(bookInfo.getPeriodTypeId(), this.getPeriodNumber());
        if (periodDyn == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"AcctAmtQueryParamApi_6", (String)"fi-ict-webapi", (Object[])new Object[0]));
        }
        long periodId = periodDyn.getLong("id");
        param.setPeriodId(periodId);
        DynamicObject accountTableDyn = QueryServiceHelper.queryOne((String)accountTableTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getAccountTableNumber())});
        long accountTableId = 0L;
        accountTableId = accountTableDyn != null ? accountTableDyn.getLong("id") : AccountRefUtils.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
        param.setAccountTableId(accountTableId);
        Map<String, Object> flexMap = AsstUtil.acctAssgrpNumberToID(this.getAccountAssgrp(), accountTableId, orgId, periodDyn);
        Map acctAssgrpMap = (Map)flexMap.get("flexToIdMap");
        if (!this.getAccountAssgrp().isEmpty() && acctAssgrpMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u79d1\u76ee\u89e3\u6790\u540e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"AcctAmtQueryParamApi_7", (String)"fi-ict-webapi", (Object[])new Object[0]));
        }
        for (Map.Entry acctAssgEntry : acctAssgrpMap.entrySet()) {
            param.setAccountAssgrp((Long)acctAssgEntry.getKey(), (List)acctAssgEntry.getValue());
        }
        DynamicObject currencyDyn = QueryServiceHelper.queryOne((String)currencyTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getCurrencyNumber())});
        param.setCurrencyId(currencyDyn == null ? 0L : currencyDyn.getLong("id"));
        Map numberToFlexMap = (Map)flexMap.get("numberToFlex");
        Set<Object> numberFlexSet = numberToFlexMap == null ? new HashSet() : numberToFlexMap.keySet();
        List<String> selectFields = this.getSelector();
        for (String field : selectFields) {
            if (numberToFlexMap != null && numberFlexSet.contains(field.trim())) {
                String flex = (String)numberToFlexMap.get(field);
                param.addSelector(flex);
                this.flexToNumberMap.put(flex, field);
                continue;
            }
            param.addSelector(field);
        }
        List<String> groupFeilds = this.getGroupBy();
        for (String field : groupFeilds) {
            field = field.trim();
            String[] fieldNames = field.split(" ");
            if (numberToFlexMap != null && numberFlexSet.contains(fieldNames[0])) {
                String flex = (String)numberToFlexMap.get(fieldNames[0]);
                if (fieldNames.length == 2) {
                    this.flexToNumberMap.put(flex, fieldNames[1]);
                } else {
                    this.flexToNumberMap.put(flex, fieldNames[0]);
                }
                param.addGroupBy(flex);
                continue;
            }
            param.addGroupBy(field);
        }
        param.setSpecialAccount(this.isSpecialAccount());
        param.setReturnZeroResult(this.isReturnZeroResult());
        return param;
    }

    public List<Map<String, Object>> flexToNumberData(List<Map<String, Object>> flexDataList) {
        if (!this.flexToNumberMap.isEmpty()) {
            HashMap flexToIdsMap = new HashMap();
            Set<String> flexs = this.flexToNumberMap.keySet();
            for (Map<String, Object> map : flexDataList) {
                for (String flex : flexs) {
                    long id = map.get(flex) == null ? 0L : (Long)map.get(flex);
                    Set<Long> set = flexToIdsMap.get(flex) == null ? new HashSet() : (Set)flexToIdsMap.get(flex);
                    set.add(id);
                    flexToIdsMap.put(flex, set);
                }
            }
            HashMap<String, String> flexToEntityIdMap = new HashMap<String, String>();
            HashMap<String, String> flexToNumberMap = new HashMap<String, String>();
            QFilter fflexs = new QFilter("flexfield", "in", flexToIdsMap.keySet());
            DataSet assistSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_asstacttype", (String)"flexfield,number,valuesource,valuetype", (QFilter[])fflexs.toArray(), null);
            for (Row row : assistSet) {
                String string = row.getString("valuetype");
                String entityId = null;
                switch (string) {
                    case "1": {
                        entityId = row.getString("valuesource");
                        break;
                    }
                    case "2": {
                        entityId = "bos_assistantdata_detail";
                    }
                }
                String flex = row.getString("flexfield");
                String number = row.getString("number");
                flexToEntityIdMap.put(flex, entityId);
                flexToNumberMap.put(flex, number);
            }
            HashMap flexMap = new HashMap(flexToIdsMap.size());
            for (Map.Entry entry : flexToIdsMap.entrySet()) {
                String flex = (String)entry.getKey();
                Set ids = (Set)entry.getValue();
                DataSet dataSet = this.queryEntityId((String)flexToEntityIdMap.get(flex), ids);
                HashMap idToEntityMap = new HashMap();
                for (Row row : dataSet) {
                    String number = row.getString("number");
                    long id = row.getLong("id");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("number", number);
                    if (this.returnAssgrpName) {
                        String name = row.getString("name");
                        map.put("name", name);
                    }
                    idToEntityMap.put(id, map);
                }
                flexMap.put(flex, idToEntityMap);
            }
            for (Map map : flexDataList) {
                HashMap assgrpMap = new HashMap(flexs.size());
                for (String flex : flexs) {
                    Object val = map.remove(flex);
                    if (val == null) continue;
                    long id = Long.parseLong(val.toString());
                    Map idToEntityMap = (Map)flexMap.get(flex);
                    Map numberMap = (Map)idToEntityMap.get(id);
                    assgrpMap.put(flexToNumberMap.get(flex), numberMap);
                }
                map.put("assgrp", assgrpMap);
            }
            return flexDataList;
        }
        return flexDataList;
    }

    private DataSet queryEntityId(String entityId, Set<Long> ids) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityId, (String)"number,name,id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
        return dataSet;
    }

    public boolean isSpecialAccount() {
        return this.isSpecialAccount;
    }

    public void setSpecialAccount(boolean isSpecialAccount) {
        this.isSpecialAccount = isSpecialAccount;
    }

    public boolean isReturnZeroResult() {
        return this.returnZeroResult;
    }

    public void setReturnZeroResult(boolean returnZeroResult) {
        this.returnZeroResult = returnZeroResult;
    }

    public boolean isReturnAssgrpName() {
        return this.returnAssgrpName;
    }

    public void setReturnAssgrpName(boolean returnAssgrpName) {
        this.returnAssgrpName = returnAssgrpName;
    }
}

