/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.autoreconcil;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ict.business.autoreconcil.IAutoReconciliation;
import kd.fi.ict.business.autoreconcil.impl.AccountReconciliationImp;
import kd.fi.ict.business.autoreconcil.impl.CashItemReconciliationImp;
import kd.fi.ict.business.autoreconcil.regulation.Rule;
import kd.fi.ict.business.autoreconcil.regulation.impl.OffSetRule;
import kd.fi.ict.business.autoreconcil.regulation.impl.OppSiteRule;
import kd.fi.ict.business.autoreconcil.regulation.impl.RelationRule;
import kd.fi.ict.business.bean.AutoCondition;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.PuchLogFactory;
import kd.fi.ict.util.ICTResManagerUtils;

public abstract class AbstractReconciliation
implements IAutoReconciliation {
    protected AutoCondition autoCondition;
    private List<RelRecord> reconDetailList;
    private final Map<Long, RelRecord> thisSite = new LinkedHashMap<Long, RelRecord>();
    private final Map<Long, RelRecord> oppoSite = new LinkedHashMap<Long, RelRecord>();
    private final Map<String, List<RelRecord>> checkedList = new LinkedHashMap<String, List<RelRecord>>();
    protected List<Rule> ruleList = new ArrayList<Rule>();
    private final HashMap<Long, List<Long>> thisVchIdByVchEntryIds = new LinkedHashMap<Long, List<Long>>();
    private final HashMap<Long, List<Long>> oppVchIdByVchEntryIds = new LinkedHashMap<Long, List<Long>>();
    private final HashMap<BigDecimal, List<Long>> thisAmtByVchEntryIdsMap = new LinkedHashMap<BigDecimal, List<Long>>();
    private final HashMap<BigDecimal, List<Long>> oppAmtByVchEntryIdsMap = new LinkedHashMap<BigDecimal, List<Long>>();
    private DynamicObject scheme;
    private boolean isBizDate = false;
    private int days = 0;
    private static final int BATCH_SIZE = 10000;
    protected final List<Long> checkVchIds = new ArrayList<Long>(16);
    private static final Log logger = LogFactory.getLog(AbstractReconciliation.class);
    protected ProgressContext pgsCtx;

    @Override
    public void setDataSynContext(ProgressContext progressContext) {
        this.pgsCtx = progressContext;
    }

    @Override
    public void autoProcess(AutoCondition autoCondition) {
        this.autoCondition = autoCondition;
        this.queryScheme();
        this.queryTransDetail();
    }

    private void queryScheme() {
        this.scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)this.autoCondition.getSchemeId(), (String)"ict_verifyscheme");
        this.isBizDate = this.scheme.getBoolean("bizdateceron");
        this.days = this.scheme.getInt("days");
    }

    private void queryTransDetail() {
        if (this.autoCondition.getOrgIds().size() < 1 || this.autoCondition.getOpOrgIds().size() < 1) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(this.autoCondition.getOrgIds());
        orgIds.addAll(this.autoCondition.getOpOrgIds());
        Map<Long, String> orgNameMap = this.getOrgName(orgIds);
        String ownOrgName = orgNameMap.get(this.autoCondition.getOrgIds().get(0));
        String opOrgName = orgNameMap.get(this.autoCondition.getOpOrgIds().get(0));
        SqlBuilder orgRelRecordVchIdsSql = this.getOrgRelRecordVchIdsSql();
        List<Long> relOwnVchIds = this.getRelRecordVchIds(orgRelRecordVchIdsSql);
        SqlBuilder opOrgRelRecordVchIdsSql = this.getOpOrgRelRecordVchIdsSql();
        List<Long> relOpRecordVchIds = this.getRelRecordVchIds(opOrgRelRecordVchIdsSql);
        int ownBatch = (int)Math.ceil((double)relOwnVchIds.size() * 1.0 / 10000.0);
        int opBatch = Math.max(1, (int)Math.ceil((double)relOpRecordVchIds.size() * 1.0 / 10000.0));
        logger.info("==AbstractReconciliation==\u672c\u65b9\u5206\u6279\u6570:{},\u5bf9\u65b9\u5206\u6279\u6570:{}", (Object)ownBatch, (Object)opBatch);
        String tipMsg = String.format(ICTResManagerUtils.getPgsAutoReconFinished(), this.scheme.getString("name"), ownOrgName, opOrgName);
        this.pgsCtx.setAllProgressTip(this.pgsCtx.getTaskId(), tipMsg);
        int finishBatch = 0;
        for (int i = 0; i < ownBatch; ++i) {
            int ownFormIndex = i * 10000;
            int ownToIndex = Math.min(relOwnVchIds.size(), (i + 1) * 10000);
            List<Long> ownRecordIds = relOwnVchIds.subList(ownFormIndex, ownToIndex);
            for (int K = 0; K < opBatch; ++K) {
                if (this.pgsCtx.isCancel(this.pgsCtx.getTaskId())) {
                    return;
                }
                int opFormIndex = K * 10000;
                int opToIndex = Math.min(relOpRecordVchIds.size(), (K + 1) * 10000);
                List<Long> opRecordIds = relOpRecordVchIds.subList(opFormIndex, opToIndex);
                HashSet<Long> relRecordVchIds = new HashSet<Long>(16);
                relRecordVchIds.addAll(ownRecordIds);
                relRecordVchIds.addAll(opRecordIds);
                relRecordVchIds.removeAll(new HashSet<Long>(this.checkVchIds));
                logger.info("==AbstractReconciliation==\u672c\u65b9\u7b2c{}\u8f6e\uff0c\u5bf9\u65b9\u7b2c{}\u8f6e\u5f00\u59cb\u5bf9\u8d26", (Object)(i + 1), (Object)(K + 1));
                long now = System.currentTimeMillis();
                if (relRecordVchIds.size() > 0) {
                    this.batchReconciliation(new ArrayList<Object>(relRecordVchIds));
                }
                logger.info("==AbstractReconciliation==\u672c\u8f6e\u5bf9\u8d26\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - now));
                int precent = this.pgsCtx.getWrapProgress(this.pgsCtx.getTaskId()) + this.pgsCtx.getWrapSingleProgress(this.pgsCtx.getTaskId()) * finishBatch++ / (ownBatch * opBatch);
                this.pgsCtx.setAllProgress(this.pgsCtx.getTaskId(), precent);
                String progressTip = tipMsg + String.format(ICTResManagerUtils.getPgsAutoReconProgress(), i, ownBatch, K + 1, opBatch);
                this.pgsCtx.setAllProgressTip(this.pgsCtx.getTaskId(), progressTip);
            }
        }
    }

    private void batchReconciliation(List<Object> relRecordVchIds) {
        this.queryGroup(relRecordVchIds);
        this.matchRule();
        this.generateRecord();
    }

    private void queryGroup(List<Object> relRecordIds) {
        this.checkedList.clear();
        this.thisSite.clear();
        this.thisVchIdByVchEntryIds.clear();
        this.thisAmtByVchEntryIdsMap.clear();
        this.oppoSite.clear();
        this.oppVchIdByVchEntryIds.clear();
        this.oppAmtByVchEntryIdsMap.clear();
        this.reconDetailList = this.queryRelRecord(relRecordIds);
        for (RelRecord relRecord : this.reconDetailList) {
            if (this.autoCondition.getOrgIds().contains(relRecord.getOrg())) {
                this.thisSite.put(relRecord.getVoucherEntryId(), relRecord);
                this.queryVchGroup(relRecord, this.thisVchIdByVchEntryIds);
                this.queryAmtGroup(relRecord, this.thisAmtByVchEntryIdsMap);
                continue;
            }
            if (!this.autoCondition.getOpOrgIds().contains(relRecord.getOrg())) continue;
            this.oppoSite.put(relRecord.getVoucherEntryId(), relRecord);
            this.queryVchGroup(relRecord, this.oppVchIdByVchEntryIds);
            this.queryAmtGroup(relRecord, this.oppAmtByVchEntryIdsMap);
        }
    }

    private void queryVchGroup(RelRecord relRecord, HashMap<Long, List<Long>> vchGroup) {
        List<Long> vchEntryIds = vchGroup.get(relRecord.getVoucherId());
        if (Objects.nonNull(vchEntryIds)) {
            vchEntryIds.add(relRecord.getVoucherEntryId());
        } else {
            vchEntryIds = new ArrayList<Long>(1);
            vchEntryIds.add(relRecord.getVoucherEntryId());
            vchGroup.put(relRecord.getVoucherId(), vchEntryIds);
        }
    }

    protected abstract void queryAmtGroup(RelRecord var1, HashMap<BigDecimal, List<Long>> var2);

    protected abstract List<RelRecord> queryRelRecord(List<Object> var1);

    private void matchRule() {
        if (this.reconDetailList == null || this.reconDetailList.size() == 0) {
            return;
        }
        this.ruleList.add(new RelationRule(this));
        this.ruleList.add(new OffSetRule(this));
        this.ruleList.add(new OppSiteRule(this));
        for (Rule rule : this.ruleList) {
            rule.deal();
        }
        this.ruleList.clear();
    }

    private void generateRecord() {
        if (this.checkedList.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(this.checkedList.size());
        ArrayList<Long> recordParam = new ArrayList<Long>();
        Iterator<Map.Entry<String, List<RelRecord>>> it = this.checkedList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<RelRecord>> entry = it.next();
            DynamicObject dt = this.buildRecEntity(entry.getValue(), entry.getKey(), this.autoCondition, recordParam);
            recordList.add(dt);
            if (recordList.size() != 1000 && it.hasNext()) continue;
            this.saveCrossRecord(recordList, recordParam);
            recordList.clear();
            recordParam.clear();
        }
    }

    private void saveCrossRecord(List<DynamicObject> recordList, List<Long> recordParam) {
        try (TXHandle tx = TX.requiresNew((String)"autoReconciliation");){
            try {
                SaveServiceHelper.save((DynamicObject[])recordList.toArray(new DynamicObject[0]));
                String formKey = this instanceof AccountReconciliationImp ? "ict_relacctrecord" : "ict_relcfrecord";
                IPuchAmtLog checkBalLog = PuchLogFactory.getPuchLog(formKey);
                checkBalLog.setAddCheckLog(recordList.toArray(new DynamicObject[0]), OperationType.AUTOCHECK);
                StringBuilder sb = new StringBuilder(0);
                sb.append(0);
                recordParam.forEach(v -> sb.append(',').append(v));
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)this.updateRecordSql(sb.toString()), (Object[])new Object[]{new Date()});
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
            }
        }
    }

    protected SqlBuilder getOrgRelRecordVchIdsSql() {
        return this.getRelRecordVchIds(OrgType.Own);
    }

    protected SqlBuilder getOpOrgRelRecordVchIdsSql() {
        return this.getRelRecordVchIds(OrgType.Opposite);
    }

    protected SqlBuilder getRelRecordVchIds(OrgType orgType) {
        ArrayList<Long> OrgIds = new ArrayList<Long>(this.autoCondition.getOrgIds());
        ArrayList<Long> opOrgIds = new ArrayList<Long>(this.autoCondition.getOpOrgIds());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(this.getIdSqlSelect(), new Object[0]).append(" where ", new Object[0]);
        sqlBuilder.append(" forgid != foporgid", new Object[0]);
        sqlBuilder.append(" and fperiodid = ?", new Object[]{this.autoCondition.getPeriodId()});
        sqlBuilder.appendIn(" and fbillstatus ", (Object[])new String[]{"A", "B"});
        if (OrgType.Own == orgType) {
            sqlBuilder.appendIn(" and forgid", OrgIds);
            sqlBuilder.appendIn(" and foporgid", opOrgIds);
        }
        if (OrgType.Opposite == orgType) {
            sqlBuilder.appendIn(" and forgid", opOrgIds);
            sqlBuilder.appendIn(" and foporgid", OrgIds);
        }
        sqlBuilder.appendSqlBuilder(this.getSqlFilter());
        return sqlBuilder;
    }

    private SqlBuilder getSqlFilter() {
        ArrayList<Long> orgIdsAll = new ArrayList<Long>(this.autoCondition.getOrgIds());
        orgIdsAll.addAll(this.autoCondition.getOpOrgIds());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.appendIn(" and forgid", orgIdsAll);
        sqlBuilder.appendIn(" and foporgid", orgIdsAll);
        sqlBuilder.append(" and fschemeid  = ?", new Object[]{this.autoCondition.getSchemeId()}).append(" and fbillstatus != 'B'", new Object[0]).append(" and fstatus != '2'", new Object[0]);
        if (this instanceof CashItemReconciliationImp) {
            sqlBuilder.append(" and fconcurrencyid  = ?", new Object[]{this.autoCondition.getCurrencyId()});
        } else {
            sqlBuilder.append(" and fcurrencyid  = ?", new Object[]{this.autoCondition.getCurrencyId()});
        }
        return sqlBuilder;
    }

    private List<Long> getRelRecordVchIds(SqlBuilder sql) {
        return (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql, rh -> {
            HashSet<Long> relRecordIds = new HashSet<Long>(16);
            while (rh.next()) {
                Long fvoucherid = rh.getLong("fvoucherid");
                relRecordIds.add(fvoucherid);
            }
            return new ArrayList(relRecordIds);
        });
    }

    protected SqlBuilder getBatchExecSql(List<Object> vchIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(this.getSqlSelect(), new Object[0]).append(" where ", new Object[0]).appendIn(" fvoucherid", vchIds).appendSqlBuilder(this.getSqlFilter());
        return sqlBuilder;
    }

    private Map<Long, String> getOrgName(Set<Long> orgIds) {
        QFilter[] filters = new QFilter("id", "in", orgIds).toArray();
        HashMap<Long, String> orgIdToName = new HashMap<Long, String>(orgIds.size());
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"name", (QFilter[])filters, null);
        orgMap.forEach((k, v) -> orgIdToName.put(Long.valueOf(String.valueOf(k)), v.getString("name")));
        return orgIdToName;
    }

    public boolean calculateBizDate(RelRecord thisDyObj, RelRecord oppoDyObj) {
        Date thisBizDate = thisDyObj.getBizdate();
        Date oppBizDate = oppoDyObj.getBizdate();
        if (thisBizDate == null || oppBizDate == null) {
            return false;
        }
        int diffDays = 0;
        try {
            diffDays = (int)(Math.abs(thisDyObj.getBizDateInt() - oppoDyObj.getBizDateInt()) / 24L / 3600L / 1000L);
        }
        catch (Exception ex) {
            return false;
        }
        if (this.isBizDate) {
            return diffDays <= this.days;
        }
        return diffDays == 0;
    }

    public abstract boolean checkSingle(RelRecord var1, RelRecord var2);

    public abstract boolean compareAmt(RelRecord var1, RelRecord var2);

    protected abstract String getIdSqlSelect();

    protected abstract String getSqlSelect();

    protected abstract String updateRecordSql(String var1);

    public abstract String getNotifyRelationTable();

    public abstract String getOppNotifyRelationTable();

    protected abstract DynamicObject buildRecEntity(List<RelRecord> var1, String var2, AutoCondition var3, List<Long> var4);

    public List<RelRecord> getReconDetailList() {
        return this.reconDetailList;
    }

    public Map<Long, RelRecord> getThisSite() {
        return this.thisSite;
    }

    public Map<Long, RelRecord> getOppoSite() {
        return this.oppoSite;
    }

    public Map<String, List<RelRecord>> getCheckedList() {
        return this.checkedList;
    }

    public HashMap<Long, List<Long>> getThisVchIdByVchEntryIds() {
        return this.thisVchIdByVchEntryIds;
    }

    public HashMap<Long, List<Long>> getOppVchIdByVchEntryIds() {
        return this.oppVchIdByVchEntryIds;
    }

    public DynamicObject getScheme() {
        return this.scheme;
    }

    public HashMap<BigDecimal, List<Long>> getThisAmtByVchEntryIdsMap() {
        return this.thisAmtByVchEntryIdsMap;
    }

    public HashMap<BigDecimal, List<Long>> getOppAmtByVchEntryIdsMap() {
        return this.oppAmtByVchEntryIdsMap;
    }

    public AutoCondition getAutoCondition() {
        return this.autoCondition;
    }

    static enum OrgType {
        Own,
        Opposite;

    }
}

