/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.autoreconcil;

import kd.fi.ict.business.autoreconcil.IAutoReconciliation;
import kd.fi.ict.enums.TransactionType;

public class AutoReconciliationFactory {
    private AutoReconciliationFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static IAutoReconciliation getReconciliation(String type) {
        if (TransactionType.CASH_FLOW.getTransactionType().equals(type)) {
            return AutoReconciliationFactory.getCashItemReconciliation();
        }
        return AutoReconciliationFactory.getAccountReconciliation();
    }

    private static IAutoReconciliation getAccountReconciliation() {
        IAutoReconciliation accountReconciliation = null;
        try {
            accountReconciliation = (IAutoReconciliation)Class.forName("kd.fi.ict.business.autoreconcil.impl.AccountReconciliationImp").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return accountReconciliation;
    }

    private static IAutoReconciliation getCashItemReconciliation() {
        IAutoReconciliation cashItemReconciliation = null;
        try {
            cashItemReconciliation = (IAutoReconciliation)Class.forName("kd.fi.ict.business.autoreconcil.impl.CashItemReconciliationImp").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cashItemReconciliation;
    }
}

