/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.autoreconcil.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.business.autoreconcil.AbstractReconciliation;
import kd.fi.ict.business.autoreconcil.util.BuildCrossRecordUtils;
import kd.fi.ict.business.bean.AutoCondition;
import kd.fi.ict.business.bean.RelAcctRecord;
import kd.fi.ict.business.bean.RelRecord;

public class AccountReconciliationImp
extends AbstractReconciliation {
    private static final Log logger = LogFactory.getLog(AccountReconciliationImp.class);

    @Override
    protected void queryAmtGroup(RelRecord relRecord, HashMap<BigDecimal, List<Long>> amtGroup) {
        RelAcctRecord relAcctRecord = (RelAcctRecord)relRecord;
        List<Long> vchEntryIds = amtGroup.get(relAcctRecord.getAmtbal());
        if (Objects.nonNull(vchEntryIds)) {
            vchEntryIds.add(relRecord.getVoucherEntryId());
        } else {
            vchEntryIds = new ArrayList<Long>(1);
            vchEntryIds.add(relRecord.getVoucherEntryId());
            amtGroup.put(relAcctRecord.getAmtbal(), vchEntryIds);
        }
    }

    @Override
    protected List<RelRecord> queryRelRecord(List<Object> relRecordIds) {
        List recordlst = (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)this.getBatchExecSql(relRecordIds), rs -> {
            ArrayList<RelAcctRecord> records = new ArrayList<RelAcctRecord>();
            try {
                while (rs.next()) {
                    RelAcctRecord record = new RelAcctRecord();
                    record.setId(this.toLongByString(rs.getString("fid")));
                    record.setVoucherEntryId(rs.getLong("fvoucherentry"));
                    record.setVoucherId(rs.getLong("fvoucherid"));
                    record.setBillno(rs.getString("fnumber"));
                    record.setAccount(rs.getLong("faccountid"));
                    record.setAccounttable(rs.getLong("faccounttableid"));
                    record.setAssgrp(rs.getLong("fassgrpid"));
                    record.setCommonAssgrp(rs.getString("fcommonassgrp"));
                    record.setAmt(rs.getBigDecimal("famt"));
                    record.setAmtloc(rs.getBigDecimal("famtloc"));
                    record.setAmtbal(rs.getBigDecimal("famtbal"));
                    record.setAmtballoc(rs.getBigDecimal("famtballoc"));
                    record.setCurrency(rs.getLong("fcurrencyid"));
                    record.setCurrencyloc(rs.getLong("fcurrencylocid"));
                    record.setPeriod(rs.getLong("fperiodid"));
                    record.setOrg(rs.getLong("forgid"));
                    record.setOporg(rs.getLong("foporgid"));
                    record.setDc(rs.getString("fdc"));
                    record.setBaldc(rs.getString("fbaldc"));
                    record.setBookedate(rs.getDate("fbookeddate"));
                    record.setEdescription(rs.getString("fedescription"));
                    record.setReconscheme(rs.getLong("fschemeid"));
                    Date date = rs.getDate("fbizdate");
                    record.setBizdate(date);
                    record.setBizDateInt(BuildCrossRecordUtils.toLongByDate(date));
                    records.add(record);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return records;
        });
        return recordlst;
    }

    private Long toLongByString(String str) {
        return Long.valueOf(str);
    }

    @Override
    public boolean checkSingle(RelRecord thisDyObj, RelRecord oppoDyObj) {
        if (thisDyObj.getOrg().equals(oppoDyObj.getOrg())) {
            return ((RelAcctRecord)thisDyObj).getAccount().equals(((RelAcctRecord)oppoDyObj).getAccount());
        }
        return true;
    }

    @Override
    public boolean compareAmt(RelRecord thisDyObj, RelRecord oppoDyObj) {
        long thisCurrencyId = thisDyObj.getCurrency();
        BigDecimal thisAmt = thisDyObj.getAmtbal();
        long oppoCurrencyId = oppoDyObj.getCurrency();
        BigDecimal oppoAmt = oppoDyObj.getAmtbal();
        BigDecimal thisBal = thisAmt.multiply(BuildCrossRecordUtils.toBigDecimalByDc(thisDyObj.getDc()));
        BigDecimal oppoBal = oppoAmt.multiply(BuildCrossRecordUtils.toBigDecimalByDc(oppoDyObj.getDc()));
        return thisCurrencyId == oppoCurrencyId && thisBal.compareTo(BigDecimal.ZERO) != 0 && thisBal.add(oppoBal).compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    protected String getIdSqlSelect() {
        return "select distinct fvoucherid from t_ict_relacctrecord";
    }

    @Override
    protected String getSqlSelect() {
        return "select fid,fvoucherentry,fvoucherid,fnumber,faccountid,faccounttableid,fassgrpid,fcommonassgrp,famt,famtloc,famtbal,famtballoc,fcurrencyid,fcurrencylocid,fperiodid,forgid,foporgid,fdc,fbaldc,fbookeddate,fbizdate,fedescription,fschemeid from t_ict_relacctrecord ";
    }

    @Override
    protected String updateRecordSql(String ids) {
        return String.format("update t_ict_relacctrecord set fstatus = '2', flastupdatetime= ?, famtbal=0, famtballoc=0 where fid in (%s)", ids);
    }

    @Override
    public String getNotifyRelationTable() {
        return "t_gl_acnotice_logentry";
    }

    @Override
    public String getOppNotifyRelationTable() {
        return "t_gl_acnotice_oplogentry";
    }

    @Override
    protected DynamicObject buildRecEntity(List<RelRecord> record, String billNo, AutoCondition autoCondition, List<Long> recordParam) {
        DynamicObject dt = BuildCrossRecordUtils.buildHead("ict_check_record", autoCondition, billNo);
        DynamicObjectCollection entries = dt.getDynamicObjectCollection("entryentity");
        DynamicObjectType entryType = entries.getDynamicObjectType();
        for (int i = 0; i < record.size(); ++i) {
            RelAcctRecord re = (RelAcctRecord)record.get(i);
            DynamicObject entry = new DynamicObject(entryType);
            entry.set("relrecordid", (Object)re.getId());
            entry.set("desc", (Object)re.getEdescription());
            entry.set("org", (Object)re.getOrg());
            entry.set("voucherentry", (Object)re.getVoucherEntryId());
            entry.set("voucherid", (Object)re.getVoucherId());
            this.checkVchIds.add(re.getVoucherId());
            entry.set("voucherno", (Object)re.getBillno());
            entry.set("currency", (Object)re.getCurrency());
            entry.set("account", (Object)re.getAccount());
            entry.set("amt", (Object)re.getAmt());
            entry.set("amtloc", (Object)re.getAmtloc());
            entry.set("assgrp", (Object)re.getAssgrp());
            entry.set("dc", (Object)re.getDc());
            entry.set("bookeddate", (Object)re.getBookedate());
            entry.set("opporg", (Object)re.getOporg());
            entry.set("loccur", (Object)re.getCurrencyloc());
            entry.set("amtbal", (Object)BigDecimal.ZERO);
            entry.set("amtballoc", (Object)BigDecimal.ZERO);
            entry.set("amtverify", (Object)re.getAmtbal());
            entry.set("amtverifyloc", (Object)re.getAmtballoc());
            entries.add((Object)entry);
            recordParam.add(re.getId());
        }
        return dt;
    }
}

