/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.autoreconcil.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.business.autoreconcil.AbstractReconciliation;
import kd.fi.ict.business.autoreconcil.util.BuildCrossRecordUtils;
import kd.fi.ict.business.bean.AutoCondition;
import kd.fi.ict.business.bean.RelCFRecord;
import kd.fi.ict.business.bean.RelRecord;

public class CashItemReconciliationImp
extends AbstractReconciliation {
    private static final Log logger = LogFactory.getLog(CashItemReconciliationImp.class);

    @Override
    protected void queryAmtGroup(RelRecord relRecord, HashMap<BigDecimal, List<Long>> amtGroup) {
        RelCFRecord relCfRecord = (RelCFRecord)relRecord;
        List<Long> vchEntryIds = amtGroup.get(relCfRecord.getConvertamtbal());
        if (Objects.nonNull(vchEntryIds)) {
            vchEntryIds.add(relRecord.getVoucherEntryId());
        } else {
            vchEntryIds = new ArrayList<Long>(1);
            vchEntryIds.add(relRecord.getVoucherEntryId());
            amtGroup.put(relCfRecord.getConvertamtbal(), vchEntryIds);
        }
    }

    @Override
    protected List<RelRecord> queryRelRecord(List<Object> relRecordIds) {
        List recordlst = (List)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)this.getBatchExecSql(relRecordIds), rs -> {
            ArrayList<RelCFRecord> records = new ArrayList<RelCFRecord>();
            try {
                while (rs.next()) {
                    RelCFRecord record = new RelCFRecord();
                    record.setId(rs.getLong("fid"));
                    record.setVoucherEntryId(rs.getLong("fvoucherentry"));
                    record.setVoucherId(rs.getLong("fvoucherid"));
                    record.setBillno(rs.getString("fnumber"));
                    record.setCashFlowItem(rs.getLong("fcashflowitemid"));
                    record.setAccounttable(rs.getLong("faccounttableid"));
                    record.setAssgrp(rs.getLong("fassgrpid"));
                    record.setCommonAssgrp(rs.getString("fcommonassgrp"));
                    record.setConvertamt(rs.getBigDecimal("fconvertamt"));
                    record.setConvertamtbal(rs.getBigDecimal("fconvertamtbal"));
                    record.setConcurrency(rs.getLong("fconcurrencyid"));
                    record.setCurrency(rs.getLong("fcurrencyid"));
                    record.setAmt(rs.getBigDecimal("famt"));
                    record.setAmtbal(rs.getBigDecimal("famtbal"));
                    record.setPeriod(rs.getLong("fperiodid"));
                    record.setOrg(rs.getLong("forgid"));
                    record.setOporg(rs.getLong("foporgid"));
                    record.setDc(rs.getString("fdc"));
                    record.setBaldc(rs.getString("fbaldc"));
                    record.setBookedate(rs.getDate("fbookeddate"));
                    record.setEdescription(rs.getString("fedescription"));
                    record.setReconscheme(rs.getLong("fschemeid"));
                    Date date = rs.getDate("fbizdate");
                    record.setBizdate(date);
                    record.setBizDateInt(BuildCrossRecordUtils.toLongByDate(date));
                    records.add(record);
                }
            }
            catch (SQLException e) {
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
            }
            return records;
        });
        return recordlst;
    }

    @Override
    public boolean checkSingle(RelRecord thisDyObj, RelRecord oppoDyObj) {
        if (thisDyObj.getOrg().equals(oppoDyObj.getOrg())) {
            return ((RelCFRecord)thisDyObj).getCashFlowItem().equals(((RelCFRecord)oppoDyObj).getCashFlowItem());
        }
        return true;
    }

    @Override
    public boolean compareAmt(RelRecord thisDyObj, RelRecord oppoDyObj) {
        long thisConCurrencyId = thisDyObj.getConcurrency();
        BigDecimal thisConAmt = thisDyObj.getConvertamt();
        String thisBalDc = thisDyObj.getDc();
        if ("i".equals(thisBalDc)) {
            thisBalDc = "1";
        } else if ("o".equals(thisBalDc)) {
            thisBalDc = "-1";
        }
        long oppoConCurrencyId = oppoDyObj.getConcurrency();
        BigDecimal oppoConAmt = oppoDyObj.getConvertamt();
        String oppoBalDc = oppoDyObj.getDc();
        if ("i".equals(oppoBalDc)) {
            oppoBalDc = "1";
        }
        if ("o".equals(oppoBalDc)) {
            oppoBalDc = "-1";
        }
        if ("b".equals(thisBalDc) && "b".equals(oppoBalDc)) {
            thisBalDc = "1";
            oppoBalDc = "-1";
        } else if ("b".equals(thisBalDc) || "b".equals(oppoBalDc)) {
            return false;
        }
        BigDecimal thisConBal = thisConAmt.multiply(BuildCrossRecordUtils.toBigDecimalByDc(thisBalDc));
        BigDecimal oppoConBal = oppoConAmt.multiply(BuildCrossRecordUtils.toBigDecimalByDc(oppoBalDc));
        return thisConCurrencyId == oppoConCurrencyId && thisConBal.compareTo(BigDecimal.ZERO) != 0 && thisConBal.add(oppoConBal).compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    protected String getIdSqlSelect() {
        return "select distinct fvoucherid from t_ict_relcfrecord";
    }

    @Override
    protected String getSqlSelect() {
        return "select fid,fvoucherentry,fvoucherid,fnumber,fcashflowitemid ,faccounttableid,fassgrpid,fcommonassgrp,fconvertamt,fconvertamtbal,fconcurrencyid,famt,famtbal,fcurrencyid,fperiodid,forgid,foporgid,fdc,fbaldc,fbookeddate,fbizdate,fedescription,fschemeid from t_ict_relcfrecord ";
    }

    @Override
    protected String updateRecordSql(String ids) {
        return String.format("update t_ict_relcfrecord set fstatus = '2', flastupdatetime=?, famtbal=0, fconvertamtbal=0 where fid in (%s)", ids);
    }

    @Override
    public String getNotifyRelationTable() {
        return "t_gl_cfnotice_logentry";
    }

    @Override
    public String getOppNotifyRelationTable() {
        return "t_gl_cfnotice_oplogentry";
    }

    @Override
    protected DynamicObject buildRecEntity(List<RelRecord> record, String billNo, AutoCondition autoCondition, List<Long> recordParam) {
        DynamicObject dt = BuildCrossRecordUtils.buildHead("ict_check_cash_record", autoCondition, billNo);
        DynamicObjectCollection entries = dt.getDynamicObjectCollection("entryentity");
        DynamicObjectType entryType = entries.getDynamicObjectType();
        for (int i = 0; i < record.size(); ++i) {
            RelCFRecord re = (RelCFRecord)record.get(i);
            DynamicObject entry = new DynamicObject(entryType);
            entry.set("relrecordid", (Object)re.getId());
            entry.set("desc", (Object)re.getEdescription());
            entry.set("org", (Object)re.getOrg());
            entry.set("voucherentry", (Object)re.getVoucherEntryId());
            entry.set("voucherid", (Object)re.getVoucherId());
            this.checkVchIds.add(re.getVoucherId());
            entry.set("voucherno", (Object)re.getBillno());
            entry.set("concurrency", (Object)re.getConcurrency());
            entry.set("cashflowitem", (Object)re.getCashFlowItem());
            entry.set("convertamt", (Object)re.getConvertamt());
            entry.set("assgrp", (Object)re.getAssgrp());
            entry.set("dc", (Object)re.getDc());
            entry.set("bookeddate", (Object)re.getBookedate());
            entry.set("opporg", (Object)re.getOporg());
            entry.set("convertamtverify", (Object)re.getConvertamtbal());
            entry.set("convertamtbal", (Object)BigDecimal.ZERO);
            entry.set("amtverify", (Object)re.getAmtbal());
            entry.set("amt", (Object)re.getAmt());
            entry.set("amtbal", (Object)BigDecimal.ZERO);
            entry.set("currency", (Object)re.getCurrency());
            entries.add((Object)entry);
            recordParam.add(re.getId());
        }
        return dt;
    }
}

