/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.autoreconcil.regulation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.ict.business.autoreconcil.AbstractReconciliation;
import kd.fi.ict.business.autoreconcil.regulation.AbstractRule;
import kd.fi.ict.business.autoreconcil.util.BuildCrossRecordUtils;
import kd.fi.ict.business.bean.RelRecord;

public class OffSetRule
extends AbstractRule {
    private Map<Long, List<Long>> thisVoucherIdList = new HashMap<Long, List<Long>>();
    private Map<Long, List<Long>> oppVoucherIdList = new HashMap<Long, List<Long>>();

    public OffSetRule(AbstractReconciliation abstractReconciliation) {
        super(abstractReconciliation);
    }

    @Override
    public void deal() {
        this.orgProcess(this.abstractReconciliation.getThisVchIdByVchEntryIds(), this.abstractReconciliation.getThisSite(), this.thisVoucherIdList);
        this.orgProcess(this.abstractReconciliation.getOppVchIdByVchEntryIds(), this.abstractReconciliation.getOppoSite(), this.oppVoucherIdList);
    }

    private void orgProcess(HashMap<Long, List<Long>> voucherIdSet, Map<Long, RelRecord> siteList, Map<Long, List<Long>> voucherIdList) {
        if (voucherIdSet.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, List<Long>> thisVoucherId : voucherIdSet.entrySet()) {
            sb.append(thisVoucherId.getKey());
            sb.append(",");
        }
        String voucherIds = sb.substring(0, sb.length() - 1);
        DataSet idRows = BuildCrossRecordUtils.toDataSetByIds(voucherIds);
        String queryThisSql = "select fsrcentityid,ftargentityid from t_gl_reverserelation";
        try (DataSet targetSet = DB.queryDataSet((String)OffSetRule.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (String)queryThisSql);){
            try (DataSet dss = targetSet.join(idRows, JoinType.INNER).on("fsrcentityid", "fid").select(new String[]{"fsrcentityid", "ftargentityid"}, new String[0]).finish();
                 DataSet dst = targetSet.join(idRows, JoinType.INNER).on("ftargentityid", "fid").select(new String[]{"fsrcentityid", "ftargentityid"}, new String[0]).finish();){
                DataSet ds = dss.union(dst);
                for (Row row : ds) {
                    Long fsrcentityId = row.getLong("fsrcentityid");
                    voucherIdList.compute(fsrcentityId, (k, v) -> {
                        if (v == null) {
                            v = new ArrayList<Long>();
                        }
                        v.add(row.getLong("ftargentityid"));
                        return v;
                    });
                }
            }
            idRows.close();
        }
        for (Map.Entry<Long, List<Long>> entry : voucherIdList.entrySet()) {
            this.descarProcess(entry.getKey(), entry.getValue(), siteList, voucherIdSet);
        }
    }

    private void descarProcess(Long thisVoucherId, List<Long> oppVoucherIds, Map<Long, RelRecord> siteList, HashMap<Long, List<Long>> voucherEntryIdList) {
        ArrayList<RelRecord> thisVoucherEntryList = new ArrayList<RelRecord>();
        if (voucherEntryIdList.get(thisVoucherId) != null) {
            List<Long> vchEntryIds = voucherEntryIdList.get(thisVoucherId);
            for (long vchEntryId : vchEntryIds) {
                if (!Objects.nonNull(siteList.get(vchEntryId))) continue;
                thisVoucherEntryList.add(siteList.get(vchEntryId));
            }
        }
        ArrayList<RelRecord> oppVoucherEntryList = new ArrayList<RelRecord>();
        for (Long voucherId : oppVoucherIds) {
            if (voucherEntryIdList.get(voucherId) == null) continue;
            List<Long> vchEntryIds = voucherEntryIdList.get(voucherId);
            Iterator<Object> iterator = vchEntryIds.iterator();
            while (iterator.hasNext()) {
                long vchEntryId = (Long)iterator.next();
                if (!Objects.nonNull(siteList.get(vchEntryId))) continue;
                oppVoucherEntryList.add(siteList.get(vchEntryId));
            }
        }
        String dateStr = this.toFormatDate();
        String[] number = this.genNumbers(thisVoucherEntryList.size());
        int seq = 0;
        block3: for (RelRecord thisObj : thisVoucherEntryList) {
            RelRecord oppObj;
            Iterator iterator = oppVoucherEntryList.iterator();
            while (iterator.hasNext() && this.abstractReconciliation.checkSingle(thisObj, oppObj = (RelRecord)iterator.next())) {
                if (!this.abstractReconciliation.compareAmt(thisObj, oppObj)) continue;
                ArrayList<RelRecord> checkMap = new ArrayList<RelRecord>();
                RelRecord thisDyObj = siteList.remove(thisObj.getVoucherEntryId());
                RelRecord oppoDyObj = siteList.remove(oppObj.getVoucherEntryId());
                if (thisDyObj != null) {
                    checkMap.add(thisDyObj);
                }
                if (oppoDyObj != null) {
                    checkMap.add(oppoDyObj);
                }
                if (thisDyObj == null) continue block3;
                String crossNumber = this.genCrossNumber(thisDyObj.getOrg(), dateStr, "2", number[seq]);
                ++seq;
                this.abstractReconciliation.getCheckedList().put(crossNumber, checkMap);
                continue block3;
            }
        }
    }
}

