/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.autoreconcil.regulation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.ict.business.autoreconcil.AbstractReconciliation;
import kd.fi.ict.business.autoreconcil.regulation.AbstractRule;
import kd.fi.ict.business.autoreconcil.util.BuildCrossRecordUtils;
import kd.fi.ict.business.bean.RelRecord;

public class RelationRule
extends AbstractRule {
    private Map<String, List<Long>> groupIds = new HashMap<String, List<Long>>();
    private List<Long> reconDetailIds = new ArrayList<Long>();

    public RelationRule(AbstractReconciliation abstractReconciliation) {
        super(abstractReconciliation);
    }

    @Override
    public void deal() {
        this.groupByFid();
        this.autoReconProcess();
    }

    private void groupByFid() {
        Object row3;
        Object object;
        Object ds;
        StringBuilder sb = new StringBuilder();
        for (RelRecord record : this.abstractReconciliation.getReconDetailList()) {
            sb.append(record.getVoucherEntryId());
            sb.append(",");
            this.reconDetailIds.add(record.getVoucherEntryId());
        }
        if (sb.length() == 0) {
            return;
        }
        String vcherntryIds = sb.substring(0, sb.length() - 1);
        DataSet idRows = BuildCrossRecordUtils.toDataSetByIds(vcherntryIds);
        StringBuilder fidSb = new StringBuilder();
        String queryThisLogSql = "select fid,fvchentryid from " + this.abstractReconciliation.getNotifyRelationTable();
        try (DataSet fidsSet = DB.queryDataSet((String)RelationRule.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (String)queryThisLogSql);){
            ds = idRows.copy().join(fidsSet, JoinType.INNER).on("fid", "fvchentryid").select(new String[0], new String[]{"fid"}).finish();
            Throwable throwable = null;
            try {
                object = ds.iterator();
                while (object.hasNext()) {
                    row3 = (Row)object.next();
                    fidSb.append(row3.getLong("fid"));
                    fidSb.append(",");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds != null) {
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        String queryOppLogSql = "select fid,fopvchentryid from " + this.abstractReconciliation.getOppNotifyRelationTable();
        DataSet fidsSet = DB.queryDataSet((String)RelationRule.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (String)queryOppLogSql);
        ds = null;
        try {
            DataSet ds2 = idRows.join(fidsSet, JoinType.INNER).on("fid", "fopvchentryid").select(new String[0], new String[]{"fid"}).finish();
            object = null;
            try {
                for (Row row2 : ds2) {
                    fidSb.append(row2.getLong("fid"));
                    fidSb.append(",");
                }
            }
            catch (Throwable row3) {
                object = row3;
                throw row3;
            }
            finally {
                if (ds2 != null) {
                    if (object != null) {
                        try {
                            ds2.close();
                        }
                        catch (Throwable row3) {
                            ((Throwable)object).addSuppressed(row3);
                        }
                    } else {
                        ds2.close();
                    }
                }
            }
            idRows.close();
        }
        catch (Throwable ds2) {
            ds = ds2;
            throw ds2;
        }
        finally {
            if (fidsSet != null) {
                if (ds != null) {
                    try {
                        fidsSet.close();
                    }
                    catch (Throwable ds2) {
                        ((Throwable)ds).addSuppressed(ds2);
                    }
                } else {
                    fidsSet.close();
                }
            }
        }
        if (fidSb.length() == 0) {
            return;
        }
        String fids = fidSb.substring(0, fidSb.length() - 1);
        DataSet notityIdRows = BuildCrossRecordUtils.toDataSetByIds(fids);
        String queryVchentryThisSql = "select fid,fvchentryid fvchentryid from " + this.abstractReconciliation.getNotifyRelationTable();
        DataSet vchentryFidSet = DB.queryDataSet((String)RelationRule.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (String)queryVchentryThisSql);
        row3 = null;
        try (DataSet ds3 = notityIdRows.copy().join(vchentryFidSet, JoinType.INNER).on("fid", "fid").select(new String[0], new String[]{"fid", "fvchentryid"}).finish();){
            for (Row row4 : ds3) {
                String fid = row4.getString("fid");
                this.groupIds.compute(fid, (k, v) -> {
                    if (null == v) {
                        v = new ArrayList<Long>();
                    }
                    v.add(row4.getLong("fvchentryid"));
                    return v;
                });
            }
        }
        catch (Throwable throwable) {
            row3 = throwable;
            throw throwable;
        }
        finally {
            if (vchentryFidSet != null) {
                if (row3 != null) {
                    try {
                        vchentryFidSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row3).addSuppressed(throwable);
                    }
                } else {
                    vchentryFidSet.close();
                }
            }
        }
        String queryVchentryOppSql = "select fid,fopvchentryid fvchentryid from " + this.abstractReconciliation.getOppNotifyRelationTable();
        try (DataSet vchentryFidSet2 = DB.queryDataSet((String)RelationRule.class.getName(), (DBRoute)DBRoute.of((String)"fi"), (String)queryVchentryOppSql);){
            DataSet ds4 = notityIdRows.join(vchentryFidSet2, JoinType.INNER).on("fid", "fid").select(new String[0], new String[]{"fid", "fvchentryid"}).finish();
            Object object2 = null;
            try {
                for (Row row5 : ds4) {
                    String fid = row5.getString("fid");
                    this.groupIds.compute(fid, (k, v) -> {
                        if (null == v) {
                            v = new ArrayList<Long>();
                        }
                        v.add(row5.getLong("fvchentryid"));
                        return v;
                    });
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (ds4 != null) {
                    if (object2 != null) {
                        try {
                            ds4.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ds4.close();
                    }
                }
            }
            notityIdRows.close();
        }
    }

    private void autoReconProcess() {
        String dateStr = this.toFormatDate();
        String[] number = this.genNumbers(this.abstractReconciliation.getThisSite().size());
        this.LOGGER.info("- autoReconProcess : {}, number:{}", this.groupIds, (Object)number);
        int seq = 0;
        for (Map.Entry<String, List<Long>> entry : this.groupIds.entrySet()) {
            List<Long> fidList = entry.getValue();
            if (!this.reconDetailIds.containsAll(fidList)) continue;
            ArrayList<RelRecord> checkMap = new ArrayList<RelRecord>();
            Long orgId = 0L;
            for (Long entryId : fidList) {
                RelRecord thisDyObj = this.abstractReconciliation.getThisSite().remove(entryId);
                RelRecord oppoDyObj = this.abstractReconciliation.getOppoSite().remove(entryId);
                if (thisDyObj != null) {
                    checkMap.add(thisDyObj);
                    orgId = thisDyObj.getOrg();
                }
                if (oppoDyObj == null) continue;
                checkMap.add(oppoDyObj);
                orgId = oppoDyObj.getOrg();
            }
            if (checkMap.size() <= 0 || seq >= number.length) continue;
            String crossNumber = this.genCrossNumber(orgId, dateStr, "1", number[seq++]);
            this.abstractReconciliation.getCheckedList().put(crossNumber, checkMap);
        }
    }
}

