/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.autoreconcil.util;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ict.business.bean.AutoCondition;

public class BuildCrossRecordUtils {
    private static final BigDecimal[] toDc = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("-1")};

    public static DynamicObject buildHead(String entity, AutoCondition autoCondition, String billNo) {
        DynamicObject dt = BusinessDataServiceHelper.newDynamicObject((String)entity);
        dt.set("billno", (Object)billNo);
        dt.set("period", (Object)autoCondition.getPeriodId());
        dt.set("checktype", (Object)"1");
        dt.set("checkstatus", (Object)"2");
        dt.set("verifyscheme", (Object)autoCondition.getSchemeId());
        dt.set("curorg", (Object)autoCondition.getOrgIds().get(0));
        dt.set("oporg", (Object)autoCondition.getOpOrgIds().get(0));
        dt.set("remark", (Object)"");
        dt.set("createtime", (Object)new Date());
        return dt;
    }

    public static Object[] buildAcctParam(long id) {
        return new Object[]{"2", new Date(), 0, 0, id};
    }

    public static Object[] buildCfParam(long id) {
        return new Object[]{"2", new Date(), 0, id};
    }

    public static Object[] buildAcctParam(BigDecimal amt, BigDecimal amtloc, long id) {
        return new Object[]{"1", new Date(), amt, amtloc, id};
    }

    public static Object[] buildCfParam(BigDecimal amtloc, long id) {
        return new Object[]{"1", new Date(), amtloc, id};
    }

    public static DataSet toDataSetByIds(String ids) {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"fid"}, (DataType[])new DataType[]{DataType.LongType});
        DataSetBuilder builder = Algo.create((String)BuildCrossRecordUtils.class.getName()).createDataSetBuilder(rowMeta);
        String[] split = ids.split(",");
        for (int i = 0; i < split.length; ++i) {
            builder.append(new Object[]{split[i]});
        }
        return builder.build();
    }

    public static BigDecimal toBigDecimalByDc(String dc) {
        if (dc.equals("1")) {
            return toDc[0];
        }
        if (dc.equals("-1")) {
            return toDc[1];
        }
        return toDc[0];
    }

    public static Long toLongByDate(Date date) {
        return date.getTime();
    }
}

