/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.cancelcheck.bean;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ict.business.cancelcheck.bean.AuditRecord;

public class AuditRecordRow
extends AuditRecord
implements Comparable<AuditRecordRow> {
    private Long entryId;
    private Long orgId;
    private BigDecimal diffAmt;
    private BigDecimal absAmt;
    private String absDc;
    private Long periodId;
    private Long currencyId;
    private Long loccurId;
    private Long concurrencyId;
    private boolean fullDeduct = false;
    private BigDecimal[] amtArr;
    public static String DC_DEBIT = "1";
    public static String DC_CREDIT = "-1";

    public Long getEntryId() {
        return this.entryId;
    }

    public void setEntryId(Long entryId) {
        this.entryId = entryId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public BigDecimal getDiffAmt() {
        return this.diffAmt;
    }

    public void setDiffAmt(BigDecimal diffAmt) {
        this.diffAmt = diffAmt;
    }

    public BigDecimal getAbsAmt() {
        return this.absAmt;
    }

    public void setAbsAmt(BigDecimal absAmt) {
        this.absAmt = absAmt;
    }

    public String getAbsDc() {
        return this.absDc;
    }

    public void setAbsDc(String absDc) {
        this.absDc = absDc;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public Long getLoccurId() {
        return this.loccurId;
    }

    public void setLoccurId(Long loccurId) {
        this.loccurId = loccurId;
    }

    public Long getConcurrencyId() {
        return this.concurrencyId;
    }

    public void setConcurrencyId(Long concurrencyId) {
        this.concurrencyId = concurrencyId;
    }

    public boolean isFullDeduct() {
        return this.fullDeduct;
    }

    public void setFullDeduct(boolean fullDeduct) {
        this.fullDeduct = fullDeduct;
    }

    public void setAmtArr() {
        this.amtArr = new BigDecimal[]{this.getAmt(), this.getAmtloc(), this.getConvertamt()};
    }

    public void reAmt() {
        if (this.amtArr != null && this.amtArr.length == 3) {
            this.setAmt(this.amtArr[0]);
            this.setAmtloc(this.amtArr[1]);
            this.setConvertamt(this.amtArr[2]);
        }
    }

    public void calculateAmt(BigDecimal deductAmt, Map<Long, Integer> curAmtPrecisions) {
        if (this.absAmt.compareTo(deductAmt) == 0) {
            this.fullDeduct = true;
            return;
        }
        this.loadCurPrecisions(curAmtPrecisions);
        Integer curPrecisions = curAmtPrecisions.get(this.currencyId);
        Integer locCurPrecisions = curAmtPrecisions.get(this.loccurId);
        Integer conCurPrecisions = curAmtPrecisions.get(this.concurrencyId);
        BigDecimal divide = deductAmt.divide(this.absAmt, 10, 2);
        BigDecimal amt = this.getAmt().multiply(divide).setScale(curPrecisions != null ? curPrecisions : 10, 4);
        this.setAmt(amt);
        BigDecimal amtloc = this.getAmtloc().multiply(divide).setScale(locCurPrecisions != null ? locCurPrecisions : 10, 4);
        this.setAmtloc(amtloc);
        BigDecimal convertamt = this.getConvertamt().multiply(divide).setScale(conCurPrecisions != null ? conCurPrecisions : 10, 4);
        this.setConvertamt(convertamt);
        this.absAmt = deductAmt;
    }

    private void loadCurPrecisions(Map<Long, Integer> curAmtPrecisions) {
        Long[] curIds = new Long[]{this.currencyId, this.loccurId, this.concurrencyId};
        ArrayList<Long> notExisCurPId = new ArrayList<Long>(5);
        for (Long curId : curIds) {
            if (curAmtPrecisions.containsKey(curId)) continue;
            notExisCurPId.add(curId);
        }
        if (!notExisCurPId.isEmpty()) {
            QFilter idFilter = new QFilter("id", "in", notExisCurPId);
            Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{idFilter});
            for (Long curId : notExisCurPId) {
                DynamicObject cur = (DynamicObject)currencyMap.get(curId);
                Integer amtprecision = cur != null ? cur.getInt("amtprecision") : 10;
                curAmtPrecisions.put(curId, amtprecision);
            }
        }
    }

    @Override
    public int compareTo(AuditRecordRow o) {
        return o.getAbsAmt().compareTo(this.absAmt);
    }
}

