/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.cancelcheck.bean;

import java.util.Arrays;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ict.constant.GLField;
import kd.fi.ict.constant.RelRecordField;
import kd.fi.ict.lock.LockKey;

public class OperatorLockKey {
    private final LockKey prefixLocKey;
    private final long orgId;
    private final long opOrgId;
    private final long currencyId;
    private final long schemeId;

    public OperatorLockKey(DynamicObject dynObj) {
        this.prefixLocKey = LockKey.getLockKeyByDynamicObjectType((DynamicObject)dynObj);
        if (Arrays.asList("ict_relacctrecord", "ict_relcfrecord").contains(dynObj.getDataEntityType().getName())) {
            this.orgId = dynObj.getLong(RelRecordField.id((String)"org"));
            this.opOrgId = dynObj.getLong(RelRecordField.id((String)"oporg"));
            this.currencyId = dynObj.getLong(RelRecordField.id((String)"currency"));
            this.schemeId = dynObj.getLong(RelRecordField.id((String)"reconscheme"));
        } else {
            DynamicObjectCollection entries = dynObj.getDynamicObjectCollection("entryentity");
            DynamicObject entry = (DynamicObject)entries.get(0);
            this.orgId = entry.getLong(GLField.id_((String)"org"));
            this.opOrgId = entry.getLong(GLField.id_((String)"opporg"));
            this.currencyId = entry.getLong(GLField.id_((String)"currency"));
            this.schemeId = dynObj.getLong(GLField.id_((String)"verifyscheme"));
        }
    }

    public OperatorLockKey(LockKey prefixLocKey, Long orgId, Long opOrgId, Long currencyId, Long schemeId) {
        this.prefixLocKey = prefixLocKey;
        this.orgId = orgId;
        this.opOrgId = opOrgId;
        this.currencyId = currencyId;
        this.schemeId = schemeId;
    }

    public long getOrgId() {
        return this.orgId;
    }

    public long getOpOrgId() {
        return this.opOrgId;
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public long getSchemeId() {
        return this.schemeId;
    }

    public String getLockKey() {
        String preLogKey = this.orgId >= this.opOrgId ? StringUtils.join((Object[])new Long[]{this.opOrgId, this.orgId}, (String)"-") : StringUtils.join((Object[])new Long[]{this.orgId, this.opOrgId}, (String)"-");
        return StringUtils.join((Object[])new Object[]{this.prefixLocKey.name(), preLogKey, this.currencyId, this.schemeId}, (String)"-");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorLockKey that = (OperatorLockKey)o;
        return Objects.equals(this.getLockKey(), that.getLockKey());
    }

    public int hashCode() {
        return Objects.hash(this.getLockKey());
    }
}

