/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.cancelcheck.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ict.business.cancelcheck.bean.AuditRecord;
import kd.fi.ict.business.cancelcheck.bean.AuditRecordRow;
import kd.fi.ict.business.cancelcheck.bean.CancelCheckRecord;
import kd.fi.ict.enums.CheckStatus;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.PuchLogFactory;
import kd.fi.ict.util.IctDataMutexUtil;
import kd.fi.ict.util.QFBuilder;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractCancelCheckService {
    private Map<Long, Integer> curAmtPrecisions = new HashMap<Long, Integer>();
    protected Log LOGGER = LogFactory.getLog(AbstractCancelCheckService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, String> cancelCheck(String logEntityId, DynamicObject[] checkLogs, List<Long> voucherids) {
        HashMap<Object, String> pkErrorMsgMap = new HashMap<Object, String>(checkLogs.length);
        CancelCheckRecord recordEntity = this.getRecord();
        IPuchAmtLog checkBalLog = PuchLogFactory.getPuchLog(recordEntity.getEntityId());
        for (DynamicObject checkLog : checkLogs) {
            DynamicObjectCollection entries = checkLog.getDynamicObjectCollection("entryentity");
            Set recordIds = entries.stream().map(x -> x.getLong("relrecordid")).collect(Collectors.toSet());
            Map failedRequireMutex = IctDataMutexUtil.requireMutex((String)this.relRecordEntityName(), recordIds);
            if (failedRequireMutex.size() > 0) {
                IctDataMutexUtil.batchRelease((String)this.relRecordEntityName(), recordIds);
                throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u7f51\u7edc\u4e92\u65a5\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AbstractCancelCheckService_0", (String)"fi-ict-business", (Object[])new Object[0]));
            }
            try (TXHandle tx = TX.requiresNew((String)"cancelCheckService");){
                try {
                    Pair<Boolean, List<AuditRecordRow>> dealResult = this.dealAudit(checkLog, voucherids);
                    Boolean isAllCancel = (Boolean)dealResult.getLeft();
                    if (!isAllCancel.booleanValue()) {
                        Map<Long, AuditRecordRow> drMap = ((List)dealResult.getRight()).stream().collect(Collectors.toMap(x -> x.getEntryId(), x -> x));
                        for (int i = entries.size() - 1; i >= 0; --i) {
                            DynamicObject entry = (DynamicObject)entries.get(i);
                            AuditRecordRow dr = drMap.get(entry.getLong("id"));
                            if (dr == null) continue;
                            if (dr.isFullDeduct()) {
                                entries.remove(i);
                                continue;
                            }
                            this.deductEntry(entry, dr);
                        }
                    }
                    this.dealRecord((List)dealResult.getRight(), recordEntity);
                    checkBalLog.setDeductCheckLog((List)dealResult.getRight(), OperationType.CANCELCHECK);
                    if (isAllCancel.booleanValue()) {
                        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)logEntityId), (Object[])new Object[]{checkLog.getPkValue()});
                        continue;
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkLog});
                }
                catch (Exception e) {
                    tx.markRollback();
                    this.LOGGER.error((Throwable)e);
                    pkErrorMsgMap.put(checkLog.getPkValue(), e.getMessage());
                }
                finally {
                    IctDataMutexUtil.batchRelease((String)this.relRecordEntityName(), recordIds);
                }
            }
        }
        checkBalLog.updateAmt(OperationType.CANCELCHECK);
        return pkErrorMsgMap;
    }

    private Pair<Boolean, List<AuditRecordRow>> dealAudit(DynamicObject checkLog, List<Long> voucherids) {
        String checktype = checkLog.getString("checktype");
        if ("3".equals(checktype) && voucherids != null && !voucherids.isEmpty()) {
            return this.dealNoDiffAudit(checkLog, voucherids);
        }
        DynamicObjectCollection entries = checkLog.getDynamicObjectCollection("entryentity");
        ArrayList<AuditRecordRow> deductRecords = new ArrayList<AuditRecordRow>(entries.size());
        for (DynamicObject entry : entries) {
            AuditRecordRow deductRecord = this.getDeductInfo(checkLog, entry);
            deductRecord.setFullDeduct(true);
            deductRecords.add(deductRecord);
        }
        return Pair.of((Object)true, deductRecords);
    }

    private Pair<Boolean, List<AuditRecordRow>> dealNoDiffAudit(DynamicObject checkLog, List<Long> voucherids) {
        Set orgIdSet;
        DynamicObjectCollection entries = checkLog.getDynamicObjectCollection("entryentity");
        ArrayList<AuditRecordRow> deductRecords = new ArrayList<AuditRecordRow>(entries.size());
        HashSet unMatchRecords = Sets.newHashSetWithExpectedSize((int)entries.size());
        ArrayList<AuditRecordRow> allRecords = new ArrayList<AuditRecordRow>(entries.size());
        BigDecimal diffAmt = BigDecimal.ZERO;
        for (DynamicObject entry : entries) {
            long voucherid = entry.getLong("voucherid");
            AuditRecordRow deductRecord = this.getDeductInfo(checkLog, entry);
            if (voucherids.contains(voucherid)) {
                diffAmt = diffAmt.add(deductRecord.getDiffAmt());
                deductRecord.setFullDeduct(true);
                deductRecords.add(deductRecord);
            } else {
                unMatchRecords.add(deductRecord);
            }
            allRecords.add(deductRecord);
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0) {
            this.deductNoMatchRow(deductRecords, unMatchRecords, diffAmt);
        }
        if ((orgIdSet = unMatchRecords.stream().map(x -> x.getOrgId()).collect(Collectors.toSet())).size() < 2) {
            allRecords.forEach(v -> {
                v.setFullDeduct(true);
                v.reAmt();
            });
            deductRecords = allRecords;
            return Pair.of((Object)true, deductRecords);
        }
        return Pair.of((Object)false, deductRecords);
    }

    private void deductNoMatchRow(List<AuditRecordRow> deductRecords, Set<AuditRecordRow> unMatchRecords, BigDecimal diffAmt) {
        Map<String, List<AuditRecordRow>> dcRecordsMap = unMatchRecords.stream().collect(Collectors.groupingBy(o -> o.getAbsDc()));
        String deductDc = "";
        if (diffAmt.compareTo(BigDecimal.ZERO) > 0) {
            deductDc = AuditRecordRow.DC_CREDIT;
        } else {
            diffAmt = diffAmt.abs();
            deductDc = AuditRecordRow.DC_DEBIT;
        }
        List<AuditRecordRow> dcRecords = dcRecordsMap.get(deductDc);
        Collections.sort(dcRecords);
        for (AuditRecordRow dr : dcRecords) {
            BigDecimal deductAmt = BigDecimal.ZERO;
            BigDecimal absAmt = dr.getAbsAmt();
            if (absAmt.compareTo(diffAmt) <= 0) {
                deductAmt = absAmt;
                unMatchRecords.remove(dr);
            } else {
                deductAmt = diffAmt;
            }
            dr.calculateAmt(deductAmt, this.curAmtPrecisions);
            deductRecords.add(dr);
            if ((diffAmt = diffAmt.subtract(deductAmt)).compareTo(BigDecimal.ZERO) > 0) continue;
            break;
        }
    }

    private void dealRecord(List<AuditRecordRow> dRecords, CancelCheckRecord recordEntity) {
        HashMap recordMap = Maps.newHashMapWithExpectedSize((int)dRecords.size());
        this.addToRecordMap(recordMap, dRecords);
        List partList = Lists.partition(new ArrayList(recordMap.keySet()), (int)999);
        for (List part : partList) {
            DynamicObject[] records;
            QFBuilder idFilterBuilder = new QFBuilder("id", "in", (Object)part);
            for (DynamicObject record : records = BusinessDataServiceHelper.load((String)recordEntity.getEntityId(), (String)recordEntity.getSelectFields(), (QFilter[])idFilterBuilder.toArray())) {
                BigDecimal locAmt;
                AuditRecord deductRecord = (AuditRecord)recordMap.get(record.getLong("id"));
                BigDecimal newOriBal = record.getBigDecimal(recordEntity.getOriBalFiled()).add(deductRecord.getAmt());
                BigDecimal newLocBal = record.getBigDecimal(recordEntity.getLocBalFiled()).add(deductRecord.getAmtloc());
                record.set(recordEntity.getOriBalFiled(), (Object)newOriBal);
                record.set(recordEntity.getLocBalFiled(), (Object)newLocBal);
                if (recordEntity.getEntityId().equals("ict_relcfrecord")) {
                    BigDecimal convertamtbal = record.getBigDecimal(recordEntity.getConvertamtbal());
                    record.set(recordEntity.getConvertamtbal(), (Object)convertamtbal.add(deductRecord.getConvertamt()));
                }
                BigDecimal amtloc = record.getBigDecimal(recordEntity.getAmtloc());
                if (newLocBal.abs().compareTo(amtloc.abs()) > 0) {
                    this.LOGGER.info("{}\u5185\u7801\uff1a{},\u672a\u52fe\u7a3d\u91d1\u989d\uff1a{},\u539f\u5e01\u91d1\u989d\uff1a{}", new Object[]{recordEntity.getEntityId(), record.get("id"), newLocBal, amtloc});
                    throw new KDBizException(ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672a\u52fe\u7a3d\u91d1\u989d\u3002", (String)"CancelCheckOpService_3", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                }
                BigDecimal locBal = record.getBigDecimal(recordEntity.getLocBalFiled());
                if (locBal.compareTo(locAmt = record.getBigDecimal(recordEntity.getLocAmountField())) == 0) {
                    record.set(recordEntity.getStatusFiled(), (Object)CheckStatus.NONE.getValue());
                    record.set(recordEntity.getLastupdateTime(), (Object)new Date());
                    continue;
                }
                record.set(recordEntity.getStatusFiled(), (Object)CheckStatus.PART_CHECK.getValue());
                record.set(recordEntity.getLastupdateTime(), (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])records);
        }
    }

    private void addToRecordMap(Map<Long, AuditRecord> recordMap, List<AuditRecordRow> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        for (AuditRecordRow dr : records) {
            AuditRecord deductRecord = recordMap.get(dr.getRecordId());
            if (deductRecord == null) {
                deductRecord = new AuditRecord();
                recordMap.put(dr.getRecordId(), deductRecord);
            }
            deductRecord.addAmt(dr);
        }
    }

    public abstract CancelCheckRecord getRecord();

    public abstract AuditRecordRow getDeductInfo(DynamicObject var1, DynamicObject var2);

    public abstract void deductEntry(DynamicObject var1, AuditRecordRow var2);

    protected abstract String relRecordEntityName();
}

