/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.cancelcheck.service;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.ict.business.autoreconcil.util.BuildCrossRecordUtils;
import kd.fi.ict.business.cancelcheck.bean.AuditRecordRow;
import kd.fi.ict.business.cancelcheck.bean.CancelCheckRecord;
import kd.fi.ict.business.cancelcheck.service.AbstractCancelCheckService;

public class AccountCancelCheckService
extends AbstractCancelCheckService {
    private static final CancelCheckRecord RECORD = new CancelCheckRecord("ict_relacctrecord", "status", "amtballoc", "amtbal", "amtloc", "lastupdatetime", "amt", "amtloc", null, null);

    @Override
    public CancelCheckRecord getRecord() {
        return RECORD;
    }

    @Override
    public AuditRecordRow getDeductInfo(DynamicObject checkLog, DynamicObject entry) {
        long entryId = entry.getLong("id");
        long relrecordid = entry.getLong("relrecordid");
        BigDecimal amtverify = entry.getBigDecimal("amtverify");
        BigDecimal amtverifyloc = entry.getBigDecimal("amtverifyloc");
        String dc = entry.getString("dc");
        BigDecimal diffAmt = amtverify.multiply(BuildCrossRecordUtils.toBigDecimalByDc(dc));
        AuditRecordRow dr = new AuditRecordRow();
        dr.setEntryId(entryId);
        dr.setRecordId(relrecordid);
        dr.setDiffAmt(diffAmt);
        dr.setAbsAmt(diffAmt.abs());
        dr.setAbsDc(this.getDC(amtverify, dc));
        dr.setAmt(amtverify);
        dr.setAmtloc(amtverifyloc);
        dr.setConvertamt(BigDecimal.ZERO);
        dr.setDc(dc);
        DynamicObject currency = entry.getDynamicObject("currency");
        dr.setCurrencyId(currency == null ? 0L : currency.getLong("id"));
        DynamicObject loccur = entry.getDynamicObject("loccur");
        dr.setLoccurId(loccur == null ? 0L : loccur.getLong("id"));
        dr.setConcurrencyId(0L);
        dr.setAmtArr();
        dr.setOrgId(entry.getDynamicObject("org").getLong("id"));
        dr.setPeriodId(checkLog.getDynamicObject("period").getLong("id"));
        return dr;
    }

    private String getDC(BigDecimal amtverify, String dc) {
        if (amtverify.compareTo(BigDecimal.ZERO) > 0) {
            return dc;
        }
        if (dc.equals(AuditRecordRow.DC_DEBIT)) {
            return AuditRecordRow.DC_CREDIT;
        }
        return AuditRecordRow.DC_DEBIT;
    }

    @Override
    public void deductEntry(DynamicObject entry, AuditRecordRow dRecord) {
        entry.set("amtverify", (Object)entry.getBigDecimal("amtverify").subtract(dRecord.getAmt()));
        entry.set("amtbal", (Object)entry.getBigDecimal("amtbal").add(dRecord.getAmt()));
        entry.set("amtverifyloc", (Object)entry.getBigDecimal("amtverifyloc").subtract(dRecord.getAmtloc()));
        entry.set("amtballoc", (Object)entry.getBigDecimal("amtballoc").add(dRecord.getAmtloc()));
    }

    @Override
    protected String relRecordEntityName() {
        return "ict_relacctrecord";
    }
}

