/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.cancelcheck.service;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.ict.business.cancelcheck.bean.AuditRecordRow;
import kd.fi.ict.business.cancelcheck.bean.CancelCheckRecord;
import kd.fi.ict.business.cancelcheck.service.AbstractCancelCheckService;

public class CashFlowCancelCheckService
extends AbstractCancelCheckService {
    private static final CancelCheckRecord RECORD = new CancelCheckRecord("ict_relcfrecord", "status", "amtbal", "amtbal", "amt", "lastupdatetime", "amt", "amt", "convertamt", "convertamtbal");

    @Override
    public CancelCheckRecord getRecord() {
        return RECORD;
    }

    @Override
    public AuditRecordRow getDeductInfo(DynamicObject checkLog, DynamicObject entry) {
        long entryId = entry.getLong("id");
        long relrecordid = entry.getLong("relrecordid");
        BigDecimal amtverify = entry.getBigDecimal("amtverify");
        BigDecimal convertamtverify = entry.getBigDecimal("convertamtverify");
        String dc = entry.getString("dc");
        BigDecimal diffAmt = this.getRelAmt(amtverify, dc);
        AuditRecordRow dr = new AuditRecordRow();
        dr.setEntryId(entryId);
        dr.setRecordId(relrecordid);
        dr.setDiffAmt(diffAmt);
        dr.setAbsAmt(diffAmt.abs());
        dr.setAbsDc(this.getDC(amtverify, dc));
        dr.setAmt(amtverify);
        dr.setAmtloc(amtverify);
        dr.setConvertamt(convertamtverify);
        DynamicObject currency = entry.getDynamicObject("currency");
        dr.setCurrencyId(currency == null ? 0L : currency.getLong("id"));
        dr.setLoccurId(currency == null ? 0L : currency.getLong("id"));
        DynamicObject concurrency = entry.getDynamicObject("concurrency");
        dr.setConcurrencyId(concurrency == null ? 0L : concurrency.getLong("id"));
        dr.setAmtArr();
        dr.setOrgId(entry.getDynamicObject("org").getLong("id"));
        dr.setPeriodId(checkLog.getDynamicObject("period").getLong("id"));
        return dr;
    }

    public BigDecimal getRelAmt(BigDecimal checkAmount, String dc) {
        if ("i".equals(dc)) {
            return checkAmount;
        }
        if ("o".equals(dc)) {
            return checkAmount.negate();
        }
        return BigDecimal.ZERO;
    }

    private String getDC(BigDecimal amtverify, String dc) {
        if (amtverify.compareTo(BigDecimal.ZERO) > 0) {
            if ("i".equals(dc)) {
                return AuditRecordRow.DC_DEBIT;
            }
            return AuditRecordRow.DC_CREDIT;
        }
        if ("i".equals(dc)) {
            return AuditRecordRow.DC_CREDIT;
        }
        return AuditRecordRow.DC_DEBIT;
    }

    @Override
    public void deductEntry(DynamicObject entry, AuditRecordRow dRecord) {
        entry.set("amtverify", (Object)entry.getBigDecimal("amtverify").subtract(dRecord.getAmt()));
        entry.set("amtbal", (Object)entry.getBigDecimal("amtbal").add(dRecord.getAmt()));
        entry.set("convertamtverify", (Object)entry.getBigDecimal("convertamtverify").subtract(dRecord.getConvertamt()));
        entry.set("convertamtbal", (Object)entry.getBigDecimal("convertamtbal").add(dRecord.getConvertamt()));
    }

    @Override
    protected String relRecordEntityName() {
        return "ict_relcfrecord";
    }
}

