/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.handle;

import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.ict.business.handle.IProgressExecuter;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.handle.ProgressResult;

public class BizHandleProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(BizHandleProgressPlugin.class);
    private static final String TASKID = "taskid";
    private static final String PROGRESS_BAR = "progressbar";
    private static final String PROGRESS_TIP = "progresstip";
    private IProgressExecuter pgsExecute;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String regionplugin = (String)this.getView().getFormShowParameter().getCustomParams().get("regionplugin");
        this.pgsExecute = this.getInstance(regionplugin);
        if (Objects.nonNull(this.pgsExecute)) {
            ProgressBar orgPgsBar = (ProgressBar)this.getView().getControl(PROGRESS_BAR);
            orgPgsBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.start();
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        if (StringUtils.isBlank((CharSequence)taskId)) {
            taskId = DBServiceHelper.genStringId();
            this.pgsExecute.init(taskId, this.getView());
            Runnable runnable = this.pgsExecute.getRunnable();
            ThreadService.execute((Runnable)runnable, (TaskType)TaskType.ICT_SYNDATA_PUCLLDATA, (RequestContext)RequestContext.get());
            this.setTaskId(taskId);
        } else {
            this.setPgsBarProperty(e, taskId);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        ProgressContext pgsCtx;
        super.beforeClosed(e);
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId) && Objects.nonNull(pgsCtx = this.getProgressContext(taskId))) {
            pgsCtx.setCancel(taskId, true);
            this.pgsExecute.removePgsCtx(taskId);
        }
    }

    protected ProgressContext getProgressContext(String taskId) {
        if (Objects.isNull(this.pgsExecute)) {
            String regionplugin = (String)this.getView().getFormShowParameter().getCustomParams().get("regionplugin");
            this.pgsExecute = this.getInstance(regionplugin);
        }
        return this.pgsExecute.getProgressContext(taskId);
    }

    protected void setPgsBarProperty(ProgressEvent e, String taskId) {
        ProgressBar pgsBar = (ProgressBar)e.getSource();
        ProgressContext ctx = this.getProgressContext(taskId);
        if (Objects.nonNull(ctx)) {
            boolean completed = ctx.isCompleted(taskId);
            boolean finished = ctx.isFinished(taskId);
            boolean isError = ctx.isError(taskId);
            if (completed) {
                e.setProgress(100);
                List<ProgressResult> results = ctx.getResults();
                if (results != null && !results.isEmpty()) {
                    this.getView().returnDataToParent(results);
                }
                this.complete();
                pgsBar.stop();
            } else if (isError) {
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().close();
                pgsBar.stop();
            } else if (finished) {
                this.getView().close();
                pgsBar.stop();
            } else {
                int progress = ctx.getAllProgress(taskId);
                String tip = ctx.getAllProgressTip(taskId);
                if (progress >= 100) {
                    progress = 99;
                }
                e.setProgress(progress);
                if (StringUtils.isNotBlank((CharSequence)tip)) {
                    this.setProgressTip(tip);
                }
            }
        }
    }

    private void start() {
        ProgressBar orgPgsBar = (ProgressBar)this.getView().getControl(PROGRESS_BAR);
        orgPgsBar.start();
    }

    private void setProgressTip(String tip) {
        Label lblTip = (Label)this.getControl(PROGRESS_TIP);
        lblTip.setText(tip);
    }

    protected void setTaskId(String taskId) {
        this.getView().getPageCache().put(TASKID, taskId);
    }

    protected String getTaskId() {
        return this.getView().getPageCache().get(TASKID);
    }

    private void complete() {
        this.getView().sendFormAction(this.getView().getParentView());
        this.getView().close();
    }

    public IProgressExecuter getInstance(String regionplugin) {
        Class register = TypesContainer.getOrRegister((String)regionplugin);
        try {
            return (IProgressExecuter)register.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error((Throwable)e);
            return null;
        }
    }
}

