/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.handle.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.business.autoreconcil.AutoReconciliationFactory;
import kd.fi.ict.business.autoreconcil.IAutoReconciliation;
import kd.fi.ict.business.bean.AutoCondition;
import kd.fi.ict.business.cancelcheck.bean.OperatorLockKey;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.handle.ProgressResult;
import kd.fi.ict.cache.CacheHelper;
import kd.fi.ict.cache.CacheModule;
import kd.fi.ict.cache.DistributeCache;
import kd.fi.ict.lock.LockKey;
import kd.fi.ict.lock.ShareLockHelper;
import kd.fi.ict.util.AppLogHelper;
import kd.fi.ict.util.ICTResManagerUtils;

public class AutoReconExecuter
implements Runnable {
    private static final Log logger = LogFactory.getLog(AutoReconExecuter.class);
    private String taskId;
    private List<String> paramList;
    private static final Map<String, ProgressContext> pgsCtxMap = new HashMap<String, ProgressContext>();

    public AutoReconExecuter(String taskId, List<String> paramList) {
        this.taskId = taskId;
        this.paramList = paramList;
        ProgressContext pgsCtx = new ProgressContext();
        pgsCtx.setAllProgressTip(taskId, ICTResManagerUtils.getPgsAutoReconStart());
        pgsCtxMap.put(taskId, new ProgressContext());
    }

    @Override
    public void run() {
        ProgressContext psgCtx = pgsCtxMap.get(this.taskId);
        try {
            psgCtx.setWrapSingleProgress(psgCtx.getTaskId(), 100 / this.paramList.size());
            int finishCount = 0;
            for (String reconScheme : this.paramList) {
                try {
                    ProgressResult result = this.autoReconProcess(reconScheme, psgCtx);
                    psgCtx.addResult(result);
                    int precent = ++finishCount * 100 / this.paramList.size();
                    psgCtx.setWrapProgress(psgCtx.getTaskId(), precent);
                    psgCtx.setAllProgress(psgCtx.getTaskId(), precent);
                    psgCtx.setAllProgressTip(psgCtx.getTaskId(), String.format(ICTResManagerUtils.getPgsAutoReconStarted(), finishCount, this.paramList.size()));
                }
                catch (KDException ex) {
                    logger.error((Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            psgCtx.setAllProgress(psgCtx.getTaskId(), 100).setFinished(psgCtx.getTaskId(), true).setCompleted(psgCtx.getTaskId(), true);
        }
    }

    private ProgressResult autoReconProcess(String reconScheme, ProgressContext progressContext) {
        logger.info("\u5f00\u59cb\u6267\u884c\u5bf9\u8d26\u4efb\u52a1:\u65b9\u6848:{}", (Object)reconScheme);
        ArrayList<Long> orgList = new ArrayList<Long>();
        ArrayList<Long> oppOrgList = new ArrayList<Long>();
        String[] reconStr = reconScheme.split(",");
        String orgId = reconStr[0];
        String oppOrgId = reconStr[1];
        String schemeId = reconStr[2];
        String currencyId = reconStr[3];
        String transactionType = reconStr[4];
        orgList.add(Long.valueOf(orgId));
        oppOrgList.add(Long.valueOf(oppOrgId));
        long period_id = Long.parseLong(reconStr[5]);
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.getCacheModule((String)transactionType));
        OperatorLockKey operatorLockKey = new OperatorLockKey(LockKey.getLockKeyByTransactionType((String)transactionType), Long.valueOf(orgId), Long.valueOf(oppOrgId), Long.valueOf(currencyId), Long.valueOf(schemeId));
        String lockKey = operatorLockKey.getLockKey();
        AtomicReference result = new AtomicReference();
        boolean hasLock = ShareLockHelper.requireLock((String)lockKey, (boolean)false, () -> {
            cache.put(lockKey, ResManager.loadKDString((String)"%1$s\u6b63\u5728\u6267\u884c\u81ea\u52a8\u52fe\u7a3d\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AutoReconExecuter_0", (String)"fi-ict-business", (Object[])new Object[]{RequestContext.get().getUserName()}));
            long now = System.currentTimeMillis();
            AutoCondition autoCondition = new AutoCondition(orgList, oppOrgList, period_id, Long.valueOf(schemeId), Long.valueOf(currencyId));
            IAutoReconciliation reconciliation = AutoReconciliationFactory.getReconciliation(transactionType);
            reconciliation.setDataSynContext(progressContext);
            reconciliation.autoProcess(autoCondition);
            cache.remove(lockKey);
            logger.info("==AutoReconciliationOp==\u5bf9\u8d26\u603b\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - now));
        });
        String opName = ResManager.loadKDString((String)"\u81ea\u52a8\u5bf9\u8d26", (String)"AutoReconExecuter_3", (String)"fi-ict-business", (Object[])new Object[0]);
        String entityId = "ict_auto_reconc_report";
        if (!hasLock) {
            AppLogHelper.addBatchLog((String)ResManager.loadKDString((String)"\u81ea\u52a8\u5bf9\u8d26\u5931\u8d25\u3002", (String)"AutoReconExecuter_4", (String)"fi-ict-business", (Object[])new Object[0]), (String)opName, (long)Long.parseLong(orgId), (String)entityId);
            if (Objects.nonNull(cache.get(lockKey))) {
                return new ProgressResult(false, cache.get(lockKey));
            }
            return new ProgressResult(false, ResManager.loadKDString((String)"\u6709\u5176\u4ed6\u65b9\u6848\u6b63\u5728\u5bf9\u8d26\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AutoReconExecuter_1", (String)"fi-ict-business", (Object[])new Object[0]));
        }
        AppLogHelper.addBatchLog((String)ResManager.loadKDString((String)"\u81ea\u52a8\u5bf9\u8d26\u6210\u529f\u3002", (String)"AutoReconExecuter_2", (String)"fi-ict-business", (Object[])new Object[0]), (String)opName, (long)Long.parseLong(orgId), (String)entityId);
        return (ProgressResult)result.get();
    }

    public static ProgressContext getPgsCtx(String taskId) {
        return pgsCtxMap.get(taskId);
    }

    public static void removePgsCtx(String taskId) {
        pgsCtxMap.remove(taskId);
    }
}

