/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.handle.impl;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.fi.ict.business.handle.IProgressExecuter;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.handle.impl.AutoReconExecuter;

public class AutoReconHandleIProgress
implements IProgressExecuter {
    private String taskId;
    private IFormView formView;

    @Override
    public void init(String taskId, IFormView formView) {
        this.taskId = taskId;
        this.formView = formView;
    }

    @Override
    public Runnable getRunnable() {
        String autoScheme = (String)this.formView.getFormShowParameter().getCustomParam("autoScheme");
        List paramList = (List)SerializationUtils.fromJsonString((String)autoScheme, List.class);
        return new AutoReconExecuter(this.taskId, paramList);
    }

    @Override
    public ProgressContext getProgressContext(String taskId) {
        ProgressContext pgsCtx = AutoReconExecuter.getPgsCtx(taskId);
        return pgsCtx;
    }

    @Override
    public void removePgsCtx(String taskId) {
        AutoReconExecuter.removePgsCtx(taskId);
    }

    public static void showOpBatchForm(IFormView view, FormOperate formOperate, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ict_bizhandleprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("autoScheme", formOperate.getOption().getVariableValue("autoScheme"));
        showParameter.getCustomParams().put("regionplugin", "kd.fi.ict.business.handle.impl.AutoReconHandleIProgress");
        showParameter.setCloseCallBack(closeCallBack);
        String appId = view.getFormShowParameter().getServiceAppId();
        if (StringUtils.isNotBlank((CharSequence)appId) && !StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appId)) {
            showParameter.setAppId(appId);
        }
        view.showForm(showParameter);
    }
}

