/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.handle.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.intertrans.syndata.FilterParam;
import kd.fi.ict.business.intertrans.syndata.RelRecordFactory;
import kd.fi.ict.util.ICTResManagerUtils;

public class DataHandleExecuter
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(DataHandleExecuter.class);
    protected List<String> OP_KEY = Arrays.asList("initacct", "pullacct", "initcf", "pullcf");
    private String taskId;
    private FilterParam filterParam;
    private String operatekey;
    private static final Map<String, ProgressContext> pgsCtxMap = new HashMap<String, ProgressContext>();

    public DataHandleExecuter(String taskId, FilterParam filterparam, String operatekey) {
        this.taskId = taskId;
        this.filterParam = filterparam;
        this.operatekey = operatekey;
        ProgressContext pgsCtx = new ProgressContext();
        pgsCtx.setAllProgressTip(taskId, ICTResManagerUtils.getPgsDataPullStart());
        pgsCtxMap.put(taskId, pgsCtx);
    }

    @Override
    public void run() {
        ProgressContext dataSynCtx = pgsCtxMap.get(this.taskId);
        try {
            if (this.operatekey.equals(this.OP_KEY.get(0)) || this.operatekey.equals(this.OP_KEY.get(2))) {
                RelRecordFactory.getRelRecordFactory(this.filterParam, this.operatekey, dataSynCtx).initRelRecord();
            }
            if (this.operatekey.equals(this.OP_KEY.get(1)) || this.operatekey.equals(this.OP_KEY.get(3))) {
                RelRecordFactory.getRelRecordFactory(this.filterParam, this.operatekey, dataSynCtx).pullDataRelRecord();
            }
        }
        catch (Exception e) {
            dataSynCtx.setError(this.taskId, true);
            dataSynCtx.setAllProgressTip(this.taskId, e.getMessage());
            LOGGER.error((Throwable)e);
        }
        finally {
            dataSynCtx.setAllProgress(this.taskId, 100);
        }
    }

    public static ProgressContext getPgsCtx(String taskId) {
        return pgsCtxMap.get(taskId);
    }

    public static void removePgsCtx(String taskId) {
        pgsCtxMap.remove(taskId);
    }
}

