/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.handle.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.business.bean.NoDiffAuditParam;
import kd.fi.ict.business.cancelcheck.bean.OperatorLockKey;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.handle.ProgressResult;
import kd.fi.ict.business.nodiffaudit.INoDiffAuditService;
import kd.fi.ict.business.nodiffaudit.NoDiffAuditFactory;
import kd.fi.ict.cache.CacheHelper;
import kd.fi.ict.cache.CacheModule;
import kd.fi.ict.cache.DistributeCache;
import kd.fi.ict.lock.LockKey;
import kd.fi.ict.lock.ShareLockHelper;
import kd.fi.ict.util.AppLogHelper;
import kd.fi.ict.util.ICTResManagerUtils;

public class NoDiffAuditExecuter
implements Runnable {
    private static final Log logger = LogFactory.getLog(NoDiffAuditExecuter.class);
    private String taskId;
    private List<String> paramList;
    private static final Map<String, ProgressContext> pgsCtxMap = new HashMap<String, ProgressContext>();

    public NoDiffAuditExecuter(String taskId, List<String> paramList) {
        this.taskId = taskId;
        this.paramList = paramList;
        ProgressContext pgsCtx = new ProgressContext();
        pgsCtx.setAllProgressTip(taskId, ICTResManagerUtils.getPgsNoDiffAuditStart());
        pgsCtxMap.put(taskId, new ProgressContext());
    }

    @Override
    public void run() {
        ProgressContext psgCtx = pgsCtxMap.get(this.taskId);
        try {
            psgCtx.setWrapSingleProgress(psgCtx.getTaskId(), 100 / this.paramList.size());
            int finishCount = 0;
            for (String param : this.paramList) {
                try {
                    ProgressResult result = this.noDiffAuditProcess(param, psgCtx);
                    psgCtx.addResult(result);
                    int precent = ++finishCount * 100 / this.paramList.size();
                    psgCtx.setWrapProgress(psgCtx.getTaskId(), precent);
                    psgCtx.setAllProgress(psgCtx.getTaskId(), precent);
                    psgCtx.setAllProgressTip(psgCtx.getTaskId(), String.format(ICTResManagerUtils.getPgsNoDiffAuditStarted(), finishCount, this.paramList.size()));
                }
                catch (KDException ex) {
                    logger.error((Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            psgCtx.setAllProgress(psgCtx.getTaskId(), 100).setFinished(psgCtx.getTaskId(), true).setCompleted(psgCtx.getTaskId(), true);
        }
    }

    private ProgressResult noDiffAuditProcess(String param, ProgressContext progressContext) {
        logger.info("\u5f00\u59cb\u6267\u884c\u65e0\u5dee\u5f02\u52fe\u7a3d\u4efb\u52a1:\u65b9\u6848:{}", (Object)param);
        String[] reconStr = param.split(",");
        String orgId = reconStr[0];
        String oppOrgId = reconStr[1];
        String schemeId = reconStr[2];
        String currencyId = reconStr[3];
        String transactionType = reconStr[4];
        long period_id = Long.parseLong(reconStr[5]);
        DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.getCacheModule((String)transactionType));
        OperatorLockKey operatorLockKey = new OperatorLockKey(LockKey.getLockKeyByTransactionType((String)transactionType), Long.parseLong(orgId), Long.parseLong(oppOrgId), Long.parseLong(currencyId), Long.parseLong(schemeId));
        String lockKey = operatorLockKey.getLockKey();
        AtomicReference result = new AtomicReference();
        boolean hasLock = ShareLockHelper.requireLock((String)lockKey, (boolean)false, () -> {
            cache.put(lockKey, ResManager.loadKDString((String)"%1$s\u6b63\u5728\u6267\u884c\u65e0\u5dee\u5f02\u52fe\u7a3d\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"NoDiffAuditExecuter_1", (String)"fi-ict-business", (Object[])new Object[]{RequestContext.get().getUserName()}));
            long now = System.currentTimeMillis();
            NoDiffAuditParam auditParam = new NoDiffAuditParam(Long.valueOf(orgId), Long.valueOf(oppOrgId), period_id, Long.valueOf(schemeId), Long.valueOf(currencyId));
            INoDiffAuditService auditService = NoDiffAuditFactory.getNoDiffAuditService(transactionType);
            auditService.setDataSynContext(progressContext);
            result.set(auditService.auditProcess(auditParam));
            cache.remove(lockKey);
            logger.info("==NoDiffAuditExecuter==\u65e0\u5dee\u5f02\u52fe\u7a3d\u603b\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - now));
        });
        String opName = ResManager.loadKDString((String)"\u65e0\u5dee\u5f02\u52fe\u7a3d", (String)"NoDiffAuditExecuter_3", (String)"fi-ict-business", (Object[])new Object[0]);
        String entityId = "ict_auto_reconc_report";
        if (!hasLock) {
            AppLogHelper.addBatchLog((String)ResManager.loadKDString((String)"\u65e0\u5dee\u5f02\u52fe\u7a3d\u5931\u8d25\u3002", (String)"NoDiffAuditExecuter_4", (String)"fi-ict-business", (Object[])new Object[0]), (String)opName, (long)Long.parseLong(orgId), (String)entityId);
            if (Objects.nonNull(cache.get(lockKey))) {
                return new ProgressResult(false, cache.get(lockKey));
            }
            return new ProgressResult(false, ResManager.loadKDString((String)"\u6709\u5176\u4ed6\u65b9\u6848\u6b63\u5728\u65e0\u5dee\u5f02\u52fe\u7a3d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"NoDiffAuditExecuter_0", (String)"fi-ict-business", (Object[])new Object[0]));
        }
        ProgressResult progressResult = (ProgressResult)result.get();
        if (Objects.nonNull(progressResult) && progressResult.getResult().booleanValue()) {
            AppLogHelper.addBatchLog((String)ResManager.loadKDString((String)"\u65e0\u5dee\u5f02\u52fe\u7a3d\u6210\u529f\u3002", (String)"NoDiffAuditExecuter_2", (String)"fi-ict-business", (Object[])new Object[0]), (String)opName, (long)Long.parseLong(orgId), (String)entityId);
        } else if (Objects.nonNull(progressResult)) {
            AppLogHelper.addBatchLog((String)progressResult.getMsg(), (String)opName, (long)Long.parseLong(orgId), (String)entityId);
        }
        return progressResult;
    }

    public static ProgressContext getPgsCtx(String taskId) {
        return pgsCtxMap.get(taskId);
    }

    public static void removePgsCtx(String taskId) {
        pgsCtxMap.remove(taskId);
    }
}

