/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.handle.impl;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.fi.ict.business.handle.IProgressExecuter;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.handle.impl.NoDiffAuditExecuter;

public class NoDiffAuditHandleIProgress
implements IProgressExecuter {
    private String taskId;
    private IFormView formView;

    @Override
    public void init(String taskId, IFormView formView) {
        this.taskId = taskId;
        this.formView = formView;
    }

    @Override
    public Runnable getRunnable() {
        String nodiffparam = (String)this.formView.getFormShowParameter().getCustomParam("nodiffparam");
        List paramList = (List)SerializationUtils.fromJsonString((String)nodiffparam, List.class);
        return new NoDiffAuditExecuter(this.taskId, paramList);
    }

    @Override
    public ProgressContext getProgressContext(String taskId) {
        ProgressContext pgsCtx = NoDiffAuditExecuter.getPgsCtx(taskId);
        return pgsCtx;
    }

    @Override
    public void removePgsCtx(String taskId) {
        NoDiffAuditExecuter.removePgsCtx(taskId);
    }

    public static void showOpBatchForm(IFormView view, FormOperate formOperate, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ict_bizhandleprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("nodiffparam", formOperate.getOption().getVariableValue("nodiffparam"));
        showParameter.getCustomParams().put("regionplugin", "kd.fi.ict.business.handle.impl.NoDiffAuditHandleIProgress");
        showParameter.setCloseCallBack(closeCallBack);
        String appId = view.getFormShowParameter().getServiceAppId();
        if (StringUtils.isNotBlank((CharSequence)appId) && !StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appId)) {
            showParameter.setAppId(appId);
        }
        view.showForm(showParameter);
    }
}

