/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.intertrans.syndata;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.accsys.AccSysUtil;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.bean.VerifyScheme;
import kd.fi.ict.business.bean.VerifySchemeEntry;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.intertrans.syndata.FilterParam;
import kd.fi.ict.business.intertrans.syndata.IRelRecord;
import kd.fi.ict.business.intertrans.utils.AssgrpHandler;
import kd.fi.ict.business.intertrans.utils.PullDataLogUtils;
import kd.fi.ict.cache.CacheHelper;
import kd.fi.ict.cache.CacheKey;
import kd.fi.ict.cache.CacheModule;
import kd.fi.ict.cache.DistributeCache;
import kd.fi.ict.constant.PullDataLogField;
import kd.fi.ict.enums.VerifyType;
import kd.fi.ict.lock.LockKey;
import kd.fi.ict.util.AccountServiceHelper;
import kd.fi.ict.util.ICTResManagerUtils;
import kd.fi.ict.util.ICTUtils;
import kd.fi.ict.util.PeriodUtil;
import kd.fi.ict.util.PermissonType;
import kd.fi.ict.util.RelRecordUtils;
import kd.fi.ict.util.VerifySchemaUtils;

public abstract class AbstractRelRecord
implements IRelRecord {
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.PUCHDATA);
    protected static final int INIT_CAPACITY = 32;
    protected static final Log log = LogFactory.getLog(AbstractRelRecord.class);
    protected static final int MAX_COUNT = 1000;
    protected static final String orgAndBookTypeKey = "%s_%s";
    protected static final String selectFields = "id,masterid,transactiontype, entryentity.account account,entryentity.account.masterid acctmasterid,entryentity.cashflowitem cashflowitem,entryentity.cashflowitem.masterid cfmasterid,entryentity.commonassgrp.fbasedataid commonbasedata, entryentity.interiorassgrp.flexfield interiorassgrp";
    private static final String[] pulllogField = new String[]{"org", "booktype", "ori_period", "isinitrecord"};
    private Map<AccountBookInfo, Map<Long, VerifySchemeEntry>> bookInfoToSchemaEntry = new HashMap<AccountBookInfo, Map<Long, VerifySchemeEntry>>(32);
    private Map<Object, DynamicObject> asstActTypeMap;
    private Map<String, String> valueSource;
    protected FilterParam filterParam;
    protected ProgressContext pgsCtx;
    protected AtomicBoolean isException = new AtomicBoolean(false);

    public AbstractRelRecord(FilterParam param, ProgressContext pgsCtx) {
        this.filterParam = param;
        this.pgsCtx = pgsCtx;
    }

    @Override
    public void initRelRecord() {
        this.doOrgBatchExecute(true);
    }

    private boolean isInitRelRecord(AccountBookInfo acctBook) {
        String value = String.format(orgAndBookTypeKey, acctBook.getOrgId(), acctBook.getBookTypeId());
        if (acctBook.getStartPeriodId() == 0L) {
            return false;
        }
        Map<String, Tuple<Long, String>> initDoneRecord = this.getEarliestRecord(acctBook.getOrgId(), acctBook.getBookTypeId());
        return initDoneRecord.containsKey(value) && "1".equals(initDoneRecord.get((Object)value).item2);
    }

    private void importInitBal(AccountBookInfo acctBookInfo) {
        DynamicObject[] verifySchemaLst;
        Long curAccountTableId = AccountRefUtils.getCurDateAccountTableId((long)acctBookInfo.getOrgId(), (long)acctBookInfo.getBookTypeId(), (Date)this.filterParam.getBeginBookDate());
        for (DynamicObject verifySchema : verifySchemaLst = VerifySchemaUtils.getVerifySchema((Long)acctBookInfo.getOrgId(), (Long)curAccountTableId, (VerifyType)this.getVerifyType())) {
            DynamicObjectCollection verifyEntitys = verifySchema.getDynamicObjectCollection("entryentity");
            for (DynamicObject verifyEntiry : verifyEntitys) {
                this.importBalance(acctBookInfo, verifyEntiry);
            }
        }
    }

    protected String importBalance(AccountBookInfo accountBook, DynamicObject verifyEntiry) {
        return null;
    }

    @Override
    public void pullDataRelRecord() {
        this.doOrgBatchExecute(false);
    }

    private void pullDataRelRecord(AccountBookInfo bookInfo) {
        HashMap<String, DynamicObject> pullLogMap = new HashMap<String, DynamicObject>(32);
        DynamicObject[] verifySchemaByOrgLst = VerifySchemaUtils.getVerifySchemaByOrg((Long)bookInfo.getOrgId(), (VerifyType)this.getVerifyType());
        QFilter[] qfVoucher = this.buildQfilter(bookInfo, verifySchemaByOrgLst);
        log.info("- pulldata - \u51ed\u8bc1\u8fc7\u6ee4\u6761\u4ef6:{}", (Object)qfVoucher[0].toString());
        ArrayList<Long> voucherIds = new ArrayList<Long>(32);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_voucher", (String)"id", (QFilter[])qfVoucher, null);){
            while (ds.hasNext()) {
                voucherIds.add(ds.next().getLong("id"));
            }
        }
        int totalCount = voucherIds.size();
        int batchCount = (int)Math.ceil((double)totalCount * 1.0 / 1000.0);
        for (int batchIndex = 0; batchIndex < batchCount; ++batchIndex) {
            boolean cancel = this.pgsCtx.isCancel(this.pgsCtx.getTaskId());
            if (cancel) {
                log.info("- pulldata - isCancle: true {} {}", (Object)bookInfo.getOrgId(), (Object)bookInfo.getOrgName());
                return;
            }
            int formIndex = 1000 * batchIndex;
            int toIndex = Math.min(1000 * (batchIndex + 1), totalCount);
            List<Long> batchVchIds = voucherIds.subList(formIndex, toIndex);
            this.batchSaveRelRecords(bookInfo, batchVchIds, pullLogMap);
            int percent = this.pgsCtx.getWrapProgress(this.pgsCtx.getTaskId()) + this.pgsCtx.getWrapSingleProgress(this.pgsCtx.getTaskId()) * toIndex / totalCount;
            String tipMsg = this.pgsCtx.getWrapProgressTip(this.pgsCtx.getTaskId()) + String.format(ICTResManagerUtils.getPgsDataPulldataing(), toIndex, totalCount);
            this.pgsCtx.setAllProgress(this.pgsCtx.getTaskId(), percent).setAllProgressTip(this.pgsCtx.getTaskId(), tipMsg);
        }
        if (!this.isException.get() || !this.filterParam.isIntellSchema()) {
            // empty if block
        }
    }

    private void doOrgBatchExecute(boolean isInit) {
        HasPermOrgResult permOrgResult;
        Set allSupOrg = ICTUtils.getChildOrgId(new HashSet<Long>(this.filterParam.getOrgIdLst()), (boolean)true);
        String entityId = this.getFormKey();
        PermissonType perType = this.getPermissonType();
        if (this.filterParam.isIntellSchema()) {
            entityId = "ict_autopulldata";
            perType = PermissonType.JTNBJYPULL;
        }
        if (!(permOrgResult = AccSysUtil.getAllPermOrgs((String)entityId, (String)perType.getPermId())).hasAllOrgPerm()) {
            allSupOrg.retainAll(permOrgResult.getHasPermOrgs());
        }
        List<Long> booktypeIdLst = this.filterParam.getBooktypeIdLst();
        if (allSupOrg.isEmpty() || booktypeIdLst.isEmpty()) {
            this.pgsCtx.setAllProgress(this.pgsCtx.getTaskId(), 100).setAllProgressTip(this.pgsCtx.getTaskId(), this.pgsCtx.getWrapProgressTip(this.pgsCtx.getTaskId())).setFinished(this.pgsCtx.getTaskId(), true).setCompleted(this.pgsCtx.getTaskId(), true);
            return;
        }
        Map orgInitDate = new HashMap(0);
        if (!isInit) {
            orgInitDate = RelRecordUtils.getOrgInitDate((String)this.getFormKey(), (Set)allSupOrg, new HashSet<Long>(booktypeIdLst));
        }
        int totalCount = allSupOrg.size() * booktypeIdLst.size();
        int finishCount = 0;
        this.pgsCtx.setWrapSingleProgress(this.pgsCtx.getTaskId(), 100 / totalCount);
        for (Long bookTypeId : booktypeIdLst) {
            List bookInfos = AccountBookInfo.of((Set)allSupOrg, (long)bookTypeId);
            for (AccountBookInfo bookInfo : bookInfos) {
                boolean cancel = this.pgsCtx.isCancel(this.pgsCtx.getTaskId());
                if (cancel) {
                    log.info("- pulldata - isCancle: true {} {}", (Object)bookInfo.getOrgId(), (Object)bookInfo.getOrgName());
                    return;
                }
                String cacheKey = CacheKey.getUserKey((long)bookInfo.getOrgId(), (long)bookInfo.getBookTypeId());
                String initOrgKey = CacheKey.getKey((long)bookInfo.getOrgId(), (long)bookInfo.getBookTypeId());
                if (!isInit && Objects.nonNull(orgInitDate.get(initOrgKey)) && ((Date)orgInitDate.get(initOrgKey)).after(this.filterParam.getBeginBookDate())) {
                    this.cache.put(cacheKey, bookInfo.getOrgName());
                    this.cache.put(cacheKey + "_error", String.format(ResManager.loadKDString((String)"[%1$s]\u5df2\u62bd\u53d6\u8fc7\u603b\u8d26\u4e1a\u52a1\u6570\u636e\uff0c\u521d\u59cb\u5316\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u603b\u8d26\u4e1a\u52a1\u65e5\u671f\u3002", (String)"AbstractRelRecord_0", (String)"fi-ict-business", (Object[])new Object[0]), bookInfo.getOrgName()));
                    continue;
                }
                this.pgsCtx.setWrapProgressTip(this.pgsCtx.getTaskId(), String.format(ICTResManagerUtils.getPgsDataPullStarted(), bookInfo.getOrgName(), finishCount, totalCount));
                String key = String.format(orgAndBookTypeKey, bookInfo.getOrgId(), LockKey.getLockKeyByVerifyType((VerifyType)this.getVerifyType()));
                try (DLock dLock = DLock.create((String)key).fastMode();){
                    if (dLock.tryLock()) {
                        if (isInit) {
                            if (!this.isInitRelRecord(bookInfo)) {
                                this.importInitBal(bookInfo);
                            }
                        } else if (bookInfo.getStartPeriodId() > 0L) {
                            this.pullDataRelRecord(bookInfo);
                        }
                    } else {
                        log.info("- pulldata - \u3010\u6570\u636e\u62bd\u53d6\u3011:\u7ec4\u7ec7{}-{}\u6b63\u5728\u62bd\u53d6\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object)bookInfo.getOrgId(), (Object)bookInfo.getOrgName());
                    }
                }
                catch (Exception e) {
                    this.cache.put(cacheKey, bookInfo.getOrgName());
                    this.cache.put(cacheKey + "_error", e.getMessage());
                    log.error((Throwable)e);
                    throw new KDBizException((Throwable)e, new ErrorCode("000", e.getMessage()), new Object[0]);
                }
                this.pgsCtx.setWrapProgress(this.pgsCtx.getTaskId(), ++finishCount * 100 / totalCount);
                this.pgsCtx.setWrapProgressTip(this.pgsCtx.getTaskId(), String.format(ICTResManagerUtils.getPgsDataPullFinished(), bookInfo.getOrgName(), finishCount, totalCount));
                this.pgsCtx.setAllProgress(this.pgsCtx.getTaskId(), this.pgsCtx.getWrapProgress(this.pgsCtx.getTaskId())).setAllProgressTip(this.pgsCtx.getTaskId(), this.pgsCtx.getWrapProgressTip(this.pgsCtx.getTaskId()));
            }
        }
        this.pgsCtx.setWrapProgressTip(this.pgsCtx.getTaskId(), String.format(ICTResManagerUtils.getPgsDataPullCompleted(), totalCount, totalCount));
        this.pgsCtx.setAllProgress(this.pgsCtx.getTaskId(), 100).setAllProgressTip(this.pgsCtx.getTaskId(), this.pgsCtx.getWrapProgressTip(this.pgsCtx.getTaskId())).setFinished(this.pgsCtx.getTaskId(), true).setCompleted(this.pgsCtx.getTaskId(), true);
    }

    private void batchSaveRelRecords(AccountBookInfo acctBook, List<Long> voucherIds, Map<String, DynamicObject> pullLogMap) {
        List<RelRecord> records = this.buildRelRecords(acctBook, voucherIds, pullLogMap);
        if (records.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u51ed\u8bc1\u6570\u636e", (String)"AbstractRelRecord_1", (String)"fi-ict-business", (Object[])new Object[0]);
            PullDataLogUtils.insertPullAcctLog(this.getLogFormKey(), Long.valueOf(RequestContext.get().getUserId()), acctBook.getOrgId(), "", msg, "2");
            return;
        }
        HashSet<Long> entryIds = new HashSet<Long>(32);
        for (RelRecord record : records) {
            entryIds.add(record.getVoucherEntryId());
        }
        QFilter fQntryIds = new QFilter("voucherentry", "in", entryIds);
        ArrayList<DynamicObject> values = new ArrayList<DynamicObject>(32);
        ArrayList voucherentry = new ArrayList(32);
        QueryServiceHelper.query((String)this.getFormKey(), (String)"voucherentry,bookeddate,org,voucherid,billno", (QFilter[])new QFilter[]{fQntryIds}).forEach(vaule -> {
            values.add((DynamicObject)vaule);
            voucherentry.add(vaule.getLong("voucherentry"));
            if (values.size() == 1000) {
                PullDataLogUtils.warnLog(this.getLogFormKey(), values);
                entryIds.removeAll(voucherentry);
                values.clear();
                voucherentry.clear();
            }
        });
        if (values.size() > 0) {
            PullDataLogUtils.warnLog(this.getLogFormKey(), values);
            entryIds.removeAll(voucherentry);
            values.clear();
            voucherentry.clear();
        }
        records.removeIf(next -> !entryIds.contains(next.getVoucherEntryId()));
        this.saveRelRecords(records);
    }

    private List<RelRecord> buildRelRecords(AccountBookInfo acctBook, List<Long> voucherIds, Map<String, DynamicObject> pullLogMap) {
        Map<String, List<DynamicObject>> vchGroupMap = this.vouchersGroupMap(acctBook, voucherIds);
        this.buildPullLog(vchGroupMap, pullLogMap);
        return this.buildRelRecords(acctBook, vchGroupMap);
    }

    private Map<String, List<DynamicObject>> vouchersGroupMap(AccountBookInfo acctBook, List<Long> voucherIds) {
        DynamicObject[] voucherList;
        Map<String, Long> lastPullRecordMap = this.lastPullRecord(acctBook);
        HashMap<String, List<DynamicObject>> vchGroupMap = new HashMap<String, List<DynamicObject>>(32);
        for (DynamicObject voucher : voucherList = BusinessDataServiceHelper.load((Object[])voucherIds.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_voucher"))) {
            Long periodId;
            Long bookTypeId;
            Long orgId = voucher.getLong("org.id");
            String key = String.format("%s-%s-%s", orgId, bookTypeId = Long.valueOf(voucher.getLong("booktype.id")), periodId = Long.valueOf(voucher.getLong("period.id")));
            Long timestamp = lastPullRecordMap.get(key);
            if (!Objects.isNull(timestamp) && voucher.getDate("modifytime").getTime() <= timestamp) continue;
            List vouchers = vchGroupMap.computeIfAbsent(key, p -> new ArrayList(32));
            vouchers.add(voucher);
        }
        log.info(" - pulldata - voucherList:{}", voucherIds);
        log.info(" - pulldata - lastPullRecordMap:{} ", lastPullRecordMap);
        log.info(" - pulldata - vchGroupMap:{} ", vchGroupMap.keySet());
        return vchGroupMap;
    }

    private void buildPullLog(Map<String, List<DynamicObject>> vchGroupMap, Map<String, DynamicObject> pullLogMap) {
        DynamicObject pulldatalog = BusinessDataServiceHelper.newDynamicObject((String)"ict_pulldatalog");
        CloneUtils cloneUtils = new CloneUtils(false, true);
        for (String key : vchGroupMap.keySet()) {
            String[] strs = key.split("-");
            DynamicObject pulllog = (DynamicObject)cloneUtils.clone((IDataEntityType)pulldatalog.getDynamicObjectType(), (Object)pulldatalog);
            pulllog.set("type", (Object)this.getVerifyType().getVerifyTypeValue());
            pulllog.set(PullDataLogField.id_((String)"org"), (Object)Long.valueOf(strs[0]));
            pulllog.set(PullDataLogField.id_((String)"booktype"), (Object)Long.valueOf(strs[1]));
            pulllog.set(PullDataLogField.id_((String)"period"), (Object)Long.valueOf(strs[2]));
            pulllog.set("timestamp", (Object)TimeServiceHelper.getTimeStamp());
            pulllog.set("billstatus", (Object)"C");
            pullLogMap.put(key, pulllog);
        }
    }

    private List<RelRecord> buildRelRecords(AccountBookInfo acctBook, Map<String, List<DynamicObject>> vchGroupMap) {
        ArrayList<RelRecord> relRecords = new ArrayList<RelRecord>(32);
        for (Map.Entry<String, List<DynamicObject>> entry : vchGroupMap.entrySet()) {
            List<DynamicObject> vouchers = entry.getValue();
            relRecords.addAll(this.buildRecords(acctBook, vouchers));
        }
        return relRecords;
    }

    private List<RelRecord> buildRecords(AccountBookInfo acctBook, List<DynamicObject> vouchers) {
        Map<Long, VerifySchemeEntry> itemMap = this.bookInfoToSchemaEntry.get(acctBook);
        if (Objects.isNull(itemMap)) {
            itemMap = this.loadSchemeEntryInfo(acctBook);
            this.bookInfoToSchemaEntry.put(acctBook, itemMap);
        }
        String itemFieldName = this.getVchItemField() + ".masterid";
        String itemAssgrpFieldName = this.getVchItemAssgrpField() + ".id";
        ArrayList<RelRecord> relRecords = new ArrayList<RelRecord>();
        log.info("- pulldata - \u540c\u6b65\u51ed\u8bc1\u6570:" + vouchers.size());
        for (DynamicObject voucher : vouchers) {
            DynamicObjectCollection vchEntries = voucher.getDynamicObjectCollection("entries");
            for (DynamicObject vchEntry : vchEntries) {
                Long itemId = vchEntry.getLong(itemFieldName);
                long assgrpId = vchEntry.getLong(itemAssgrpFieldName);
                VerifySchemeEntry schemeEntry = null;
                if (Objects.nonNull(itemMap.get(itemId))) {
                    schemeEntry = itemMap.get(itemId);
                } else {
                    for (Map.Entry<Long, VerifySchemeEntry> item : itemMap.entrySet()) {
                        if (!item.getValue().getChildItemIds().contains(itemId)) continue;
                        schemeEntry = item.getValue();
                    }
                }
                if (assgrpId == 0L || schemeEntry == null || this.nonZero(vchEntry)) continue;
                RelRecord record = this.buildSingleRelRecord(acctBook, vchEntry);
                record = this.dealWithCommonFields(voucher, vchEntry, schemeEntry, record, acctBook);
                relRecords.add(record);
            }
        }
        new AssgrpHandler().handle(relRecords);
        return relRecords;
    }

    protected boolean nonZero(DynamicObject vchEntry) {
        return true;
    }

    protected RelRecord buildSingleRelRecord(AccountBookInfo acctBook, DynamicObject vchEntry) {
        return null;
    }

    public void saveRelRecords(List<RelRecord> records) {
    }

    protected DynamicObject createDynamicObject(RelRecord record, DynamicObjectType recordType) {
        DynamicObject dynRecord = new DynamicObject(recordType);
        this.buildCommonFields(record, dynRecord);
        return dynRecord;
    }

    protected RelRecord dealWithCommonFields(DynamicObject voucher, DynamicObject vchEntry, VerifySchemeEntry schemeEntry, RelRecord record, AccountBookInfo acctBook) {
        record.setVoucherId(voucher.getLong("id"));
        record.setVoucherEntryId(vchEntry.getLong("id"));
        record.setOrg(acctBook.getOrgId());
        record.setBooktype(acctBook.getBookTypeId());
        record.setPeriod(voucher.getLong("period.id"));
        record.setOri_period(voucher.getLong("period.id"));
        Date createTime = TimeServiceHelper.now();
        record.setCreatetime(createTime);
        record.setLastupdatetime(createTime);
        record.setBookedate(voucher.getDate("bookeddate"));
        record.setBizdate(voucher.getDate("bizdate"));
        record.setRelevanceType(schemeEntry.getTransactionType());
        record.setReconscheme(schemeEntry.getScheme().getMasterId());
        record.setEdescription(vchEntry.getString("edescription"));
        record.setBillno(voucher.getString("billno"));
        record.setSourcetype(voucher.getString("sourcetype"));
        record.setSourcesys("83bfebc8000017ac");
        record.setVouchertype(voucher.getLong("vouchertype.id"));
        record.setVchcreator(voucher.getLong("creator.id"));
        record.setStatus("0");
        String assgrpVal = vchEntry.getString(this.getVchItemAssgrpField() + ".value");
        if (!StringUtils.isEmpty((CharSequence)assgrpVal)) {
            JSONObject assgrpVals = JSONObject.parseObject((String)assgrpVal);
            this.buildAssgrpVals(schemeEntry, record, (Map<String, Object>)assgrpVals);
        }
        record.setRelevanceType(schemeEntry.getTransactionType());
        return record;
    }

    protected void buildAssgrpVals(VerifySchemeEntry schemeEntry, RelRecord record, Map<String, Object> assgrpVals) {
        ArrayList<String> commonAssgrpVals = new ArrayList<String>(32);
        if (Objects.isNull(this.valueSource)) {
            this.valueSource = this.queryFlexFieldAndValSource();
        }
        for (Map.Entry<String, Object> assgrpEntry : assgrpVals.entrySet()) {
            String flexField = assgrpEntry.getKey();
            Object flexId = assgrpEntry.getValue();
            if (flexField.equals(schemeEntry.getInteriorAssgrp())) {
                String valSource = this.valueSource.get(flexField);
                if (StringUtils.isEmpty((CharSequence)valSource)) continue;
                record.setOppValueSource(valSource);
                record.setOppFlexItemId(flexId);
                if (!"bos_org".equals(valSource)) continue;
                record.setOporg(Long.parseLong(flexId.toString()));
                continue;
            }
            if (!schemeEntry.getCommonAssgrps().contains(flexField)) continue;
            commonAssgrpVals.add(assgrpEntry.toString());
        }
        record.setCommonAssgrp(String.join((CharSequence)",", commonAssgrpVals));
    }

    public Map<Long, VerifySchemeEntry> loadSchemeEntryInfo(AccountBookInfo acctBook) {
        if (Objects.isNull(this.asstActTypeMap)) {
            this.asstActTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", null);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(32);
        filters.add(BaseDataServiceHelper.getBaseDataFilter((String)"ict_verifyscheme", (Long)acctBook.getOrgId()));
        filters.add(new QFilter("transactiontype", "in", this.getTransactionType()));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        HashMap<Long, VerifySchemeEntry> schemaEntry = new HashMap<Long, VerifySchemeEntry>(32);
        try (DataSet schemaDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_verifyscheme", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);){
            for (Row row : schemaDs) {
                Long key;
                VerifyScheme verifyScheme = new VerifyScheme();
                verifyScheme.setId(row.getLong("id"));
                verifyScheme.setMasterId(row.getLong("masterid"));
                verifyScheme.setTransactionType(row.getString("transactiontype"));
                VerifySchemeEntry verifySchemeEntry = new VerifySchemeEntry();
                verifySchemeEntry.setScheme(verifyScheme);
                verifySchemeEntry.setAccountId(row.getLong("acctmasterid"));
                verifySchemeEntry.setCashflowitemId(row.getLong("cfmasterid"));
                Long commonBaseDataId = row.getLong("commonbasedata");
                String commonAssgrp = "";
                DynamicObject baseData = this.asstActTypeMap.get(commonBaseDataId);
                if (baseData != null) {
                    commonAssgrp = baseData.getString("flexfield");
                }
                HashSet<String> commonAssgrpMap = new HashSet<String>(1);
                commonAssgrpMap.add(commonAssgrp);
                verifySchemeEntry.setCommonAssgrps(commonAssgrpMap);
                verifySchemeEntry.setInteriorAssgrp(row.getString("interiorassgrp"));
                log.info("-verifySchemeEntry:{}", (Object)verifySchemeEntry);
                Set childrenIds = null;
                if (this.isAccountVerify()) {
                    key = verifySchemeEntry.getAccountId();
                    if (Objects.isNull(schemaEntry.get(key)) && key > 0L) {
                        childrenIds = AccountServiceHelper.getChildrenIdsByAcctNumber((long)acctBook.getOrgId(), (long)verifySchemeEntry.getAccountId(), (boolean)true, (boolean)false);
                    }
                } else {
                    key = verifySchemeEntry.getCashflowitemId();
                    if (Objects.isNull(schemaEntry.get(key)) && key > 0L) {
                        childrenIds = AccountServiceHelper.getChildrenIdsByCfItemNumber((long)acctBook.getOrgId(), (long)verifySchemeEntry.getCashflowitemId(), (boolean)true, (boolean)false);
                    }
                }
                if (!Objects.nonNull(childrenIds)) continue;
                verifySchemeEntry.setChildItemIds(childrenIds);
                schemaEntry.put(key, verifySchemeEntry);
            }
        }
        return schemaEntry;
    }

    private void buildCommonFields(RelRecord record, DynamicObject dynRecord) {
        dynRecord.set("voucherid", (Object)record.getVoucherId());
        dynRecord.set("voucherentry", (Object)record.getVoucherEntryId());
        dynRecord.set("assgrp", (Object)record.getAssgrp());
        dynRecord.set("org", (Object)record.getOrg());
        dynRecord.set("booktype", (Object)record.getBooktype());
        dynRecord.set("oporg", (Object)record.getOporg());
        dynRecord.set("createtime", (Object)record.getCreatetime());
        dynRecord.set("lastupdatetime", (Object)record.getLastupdatetime());
        dynRecord.set("commonassgrp", (Object)record.getCommonAssgrp());
        dynRecord.set("dc", (Object)record.getDc());
        dynRecord.set("period", (Object)record.getPeriod());
        dynRecord.set("status", (Object)record.getStatus());
        dynRecord.set("currency", (Object)record.getCurrency());
        dynRecord.set("isinitrecord", (Object)record.getIsinitrecord());
        dynRecord.set("relevancetype", (Object)record.getRelevanceType());
        dynRecord.set("reconscheme", (Object)record.getReconscheme());
        dynRecord.set("bookeddate", (Object)record.getBookedate());
        dynRecord.set("ori_period", (Object)record.getOri_period());
        dynRecord.set("bizdate", (Object)record.getBizdate());
        dynRecord.set("edescription", (Object)record.getEdescription());
        dynRecord.set("billno", (Object)record.getBillno());
        dynRecord.set("sourcetype", (Object)record.getSourcetype());
        dynRecord.set("sourcesys", (Object)record.getSourcesys());
        dynRecord.set("vouchertype", (Object)record.getVouchertype());
        dynRecord.set("vchcreator", (Object)record.getVchcreator());
        dynRecord.set("billstatus", (Object)"A");
    }

    protected Map<String, Tuple<Long, String>> getEarliestRecord(Long orgId, Long bookTypeId) {
        HashMap<String, Tuple<Long, String>> recordMap = new HashMap<String, Tuple<Long, String>>(32);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("booktype", "=", (Object)bookTypeId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.getFormKey(), (String)StringUtils.join((Object[])pulllogField, (char)','), (QFilter[])new QFilter[]{filter}, (String)"ori_period asc");){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                String key = String.format(orgAndBookTypeKey, next.getLong("org"), next.getLong("booktype"));
                recordMap.put(key, (Tuple<Long, String>)Tuple.create((Object)next.getLong("ori_period"), (Object)next.getString("isinitrecord")));
            }
        }
        return recordMap;
    }

    protected void setOpOrg(RelRecord record, Map<String, Object> row, DynamicObject verifyEntiry) {
        long inteItemId = Long.parseLong(verifyEntiry.get("interiorassgrp.id").toString());
        Tuple<String, String> flexFieldAndValueSource = this.getFlexFieldAndValue(inteItemId);
        Object assgrpValue = row.get(flexFieldAndValueSource.item2);
        if (assgrpValue != null) {
            long flexId = Long.parseLong(assgrpValue.toString());
            if ("bos_org".equals(flexFieldAndValueSource.item1)) {
                record.setOporg(flexId);
                return;
            }
            Long interCompany = AbstractRelRecord.getInterCompany((String)flexFieldAndValueSource.item1, flexId);
            if (0L != interCompany) {
                record.setOporg(interCompany);
                return;
            }
        }
    }

    protected static Long getInterCompany(String baseDataNo, Long baseDataId) {
        DynamicObject company;
        List<String> valueSource = AbstractRelRecord.getValueSource();
        if (valueSource.contains(baseDataNo) && Objects.nonNull(company = BusinessDataServiceHelper.loadSingleFromCache((Object)baseDataId, (String)baseDataNo, (String)"internal_company"))) {
            return company.getLong("internal_company_id");
        }
        return 0L;
    }

    private static List<String> getValueSource() {
        return new ArrayList<String>(Arrays.asList("bd_customer", "bd_supplier", "bd_bizpartner"));
    }

    protected Long getPeriodByDate(AccountBookInfo acctBook) {
        DynamicObject periodByDate = PeriodUtil.getPeriodByDate((Date)this.filterParam.getBeginBookDate(), (long)acctBook.getPeriodTypeId());
        if (Objects.nonNull(periodByDate)) {
            return periodByDate.getLong("id");
        }
        return 0L;
    }

    public Map<String, String> queryFlexFieldAndValSource() {
        HashMap<String, String> map = new HashMap<String, String>(32);
        List valSource = AccountServiceHelper.getValueSource();
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_asstacttype", (String)"valuesource,flexfield", (QFilter[])new QFilter[]{new QFilter("valuesource", "in", (Object)valSource)}, null);){
            for (Row row : dSet) {
                map.put(row.getString("flexfield"), row.getString("valuesource"));
            }
        }
        return map;
    }

    protected Tuple<String, String> getFlexFieldAndValue(Long assgrpId) {
        QFilter fassType = new QFilter("id", "=", (Object)assgrpId);
        DynamicObject assTypeCol = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"flexfield,valuesource", (QFilter[])fassType.toArray());
        String valuesource = assTypeCol.getString("valuesource");
        String flexField = assTypeCol.getString("flexfield");
        return new Tuple((Object)valuesource, (Object)flexField);
    }

    protected Map<String, Long> getAssgrpMap(Long assgrpId) {
        HashMap<String, Long> assgrpValue = new HashMap<String, Long>(32);
        QFilter[] fhg = new QFilter[]{new QFilter("hg", "=", (Object)assgrpId)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_assist_bd", (String)"asstype,assval", (QFilter[])fhg, null);){
            while (ds.hasNext()) {
                Row next = ds.next();
                assgrpValue.put(next.getString("asstype"), next.getLong("assval"));
            }
        }
        return assgrpValue;
    }

    private Map<String, Long> lastPullRecord(AccountBookInfo acctBook) {
        HashMap<String, Long> result = new HashMap<String, Long>(32);
        QFilter fOrg = new QFilter("org", "=", (Object)acctBook.getOrgId());
        QFilter fBooktype = new QFilter("booktype", "=", (Object)acctBook.getBookTypeId());
        QFilter ftype = new QFilter("type", "=", (Object)this.getVerifyType().getVerifyTypeValue());
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_pulldatalog", (String)"org,booktype,period,timestamp", (QFilter[])new QFilter[]{fOrg, fBooktype, ftype}, null).groupBy(new String[]{"org", "booktype", "period"}).max("timestamp").finish();
        while (ds.hasNext()) {
            Row next = ds.next();
            String key = String.format("%s-%s-%s", acctBook.getOrgId(), acctBook.getBookTypeId(), next.getLong("period"));
            result.put(key, next.getLong("timestamp"));
        }
        return result;
    }

    protected QFilter[] buildQfilter(AccountBookInfo bookInfo, DynamicObject[] verifySchemas) {
        QFilter qFilter = new QFilter("org", "=", (Object)bookInfo.getOrgId());
        qFilter.and(new QFilter("booktype", "=", (Object)bookInfo.getBookTypeId()));
        if (this.filterParam.isIntellSchema()) {
            qFilter.and(new QFilter("modifytime", ">=", (Object)this.filterParam.getBeginBookDate()));
            qFilter.and(new QFilter("modifytime", "<", (Object)this.filterParam.getEndBookDate()));
        } else if (Objects.nonNull(this.filterParam.getBeginBookDate())) {
            qFilter.and(new QFilter("period", "in", (Object)PeriodUtil.getPeriodIdSet((Long)bookInfo.getPeriodTypeId(), (Date)this.filterParam.getBeginBookDate(), (Date)this.filterParam.getEndBookDate())));
            qFilter.and(new QFilter("bookeddate", ">=", (Object)this.filterParam.getBeginBookDate()));
            qFilter.and(new QFilter("bookeddate", "<", (Object)this.filterParam.getEndBookDate()));
        }
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("sourcetype", "not in", Arrays.asList("1", "2")));
        Long oriperiodId = this.getInitPeriod(bookInfo.getOrgId(), bookInfo.getBookTypeId());
        if (Objects.nonNull(oriperiodId)) {
            qFilter.and(new QFilter("oriperiod", ">=", (Object)oriperiodId));
        }
        Set<Long> itemLst = this.getChildNode(bookInfo.getOrgId(), verifySchemas);
        qFilter.and(new QFilter("entries." + this.getVchItemField() + ".masterid", "in", itemLst));
        return Collections.singletonList(qFilter).toArray(new QFilter[0]);
    }

    private Long getInitPeriod(Long orgId, Long bookTypeId) {
        Map<String, Tuple<Long, String>> initDoneRecord = this.getEarliestRecord(orgId, bookTypeId);
        String key = String.format(orgAndBookTypeKey, orgId, bookTypeId);
        return initDoneRecord.containsKey(key) && "1".equals(initDoneRecord.get((Object)key).item2) ? (Long)initDoneRecord.get((Object)key).item1 : null;
    }

    protected String getCommonAssgrpValue(Long assgrpId, DynamicObject verifyEntiry) {
        if (Objects.isNull(this.valueSource)) {
            this.valueSource = this.queryFlexFieldAndValSource();
        }
        Map<String, Long> assgrpVals = this.getAssgrpMap(assgrpId);
        ArrayList commonAssgrpVals = new ArrayList();
        for (Map.Entry<String, Long> assgrpEntry : assgrpVals.entrySet()) {
            DynamicObjectCollection commonassgrpDyn = verifyEntiry.getDynamicObjectCollection("commonassgrp");
            commonassgrpDyn.forEach(value -> {
                String flexfield = value.getDynamicObject("FBasedataId").getString("flexfield");
                if (this.valueSource.containsKey(flexfield)) {
                    commonAssgrpVals.add(assgrpEntry.toString());
                }
            });
        }
        return String.join((CharSequence)",", commonAssgrpVals);
    }

    private boolean isAccountVerify() {
        return "ict_relacctrecord".equals(this.getFormKey());
    }

    protected abstract String getFormKey();

    protected abstract VerifyType getVerifyType();

    protected abstract List<String> getTransactionType();

    protected abstract String getSchemaItemField();

    protected abstract String getVchItemField();

    protected abstract String getVchItemAssgrpField();

    protected abstract String getLogFormKey();

    protected abstract Set<Long> getChildNode(Long var1, DynamicObject[] var2);

    protected abstract PermissonType getPermissonType();
}

