/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.intertrans.syndata.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ict.business.bean.RelAcctRecord;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.intertrans.syndata.AbstractRelRecord;
import kd.fi.ict.business.intertrans.syndata.FilterParam;
import kd.fi.ict.business.intertrans.syndata.IRelRecord;
import kd.fi.ict.business.intertrans.utils.PullDataLogUtils;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.enums.VerifyType;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.PuchLogFactory;
import kd.fi.ict.util.AccountServiceHelper;

public abstract class AcctRelRecord
extends AbstractRelRecord
implements IRelRecord {
    public AcctRelRecord(FilterParam param, ProgressContext dataSynCtx) {
        super(param, dataSynCtx);
    }

    @Override
    public void saveRelRecords(List<RelRecord> records) {
        ArrayList<DynamicObject> acctRecords = new ArrayList<DynamicObject>(records.size());
        MainEntityType accRecordType = EntityMetadataCache.getDataEntityType((String)"ict_relacctrecord");
        for (RelRecord record : records) {
            RelAcctRecord acctRecord = (RelAcctRecord)record;
            DynamicObject dynRecord = this.createDynamicObject(record, (DynamicObjectType)accRecordType);
            dynRecord.set("accounttable", (Object)record.getAccounttable());
            dynRecord.set("account", (Object)acctRecord.getAccount());
            dynRecord.set("amt", (Object)acctRecord.getAmt());
            dynRecord.set("amtloc", (Object)acctRecord.getAmtloc());
            dynRecord.set("amtbal", (Object)acctRecord.getAmtbal());
            dynRecord.set("amtballoc", (Object)acctRecord.getAmtballoc());
            dynRecord.set("currencyloc", (Object)acctRecord.getCurrencyloc());
            dynRecord.set("baldc", (Object)acctRecord.getBaldc());
            dynRecord.set("localrate", (Object)acctRecord.getLocalrate());
            acctRecords.add(dynRecord);
        }
        if (!acctRecords.isEmpty()) {
            try (TXHandle handle = TX.requiresNew((String)AcctRelRecord.class.getName());){
                try {
                    SaveServiceHelper.save((IDataEntityType)accRecordType, (Object[])acctRecords.toArray(new DynamicObject[0]));
                    PullDataLogUtils.insertPullAcctLog(this.getLogFormKey(), records);
                    IPuchAmtLog checkBalLog = PuchLogFactory.getPuchLog("ict_relacctrecord");
                    checkBalLog.setAddLog(acctRecords.toArray(new DynamicObject[0]), OperationType.PULLDATA);
                }
                catch (Exception e) {
                    handle.markRollback();
                    this.isException.compareAndSet(false, true);
                    log.error((Throwable)e);
                    throw e;
                }
            }
        }
    }

    @Override
    protected String getFormKey() {
        return "ict_relacctrecord";
    }

    @Override
    protected VerifyType getVerifyType() {
        return VerifyType.ACCT;
    }

    @Override
    protected List<String> getTransactionType() {
        return Arrays.asList("1", "2", "3");
    }

    @Override
    protected String getSchemaItemField() {
        return "account";
    }

    @Override
    protected String getVchItemField() {
        return "account";
    }

    @Override
    protected String getVchItemAssgrpField() {
        return "assgrp";
    }

    @Override
    protected String getLogFormKey() {
        return "ict_pullacctdetaillog";
    }

    @Override
    protected Set<Long> getChildNode(Long orgId, DynamicObject[] verifySchemas) {
        HashSet<Long> itemLst = new HashSet<Long>(32);
        for (DynamicObject verifySchema : verifySchemas) {
            DynamicObjectCollection entrys = verifySchema.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                long masterId = entry.getLong(this.getSchemaItemField() + ".masterid");
                Set acctIds = AccountServiceHelper.getChildrenIdsByAcctNumber((long)orgId, (long)masterId, (boolean)true, (boolean)true);
                itemLst.addAll(acctIds);
            }
        }
        return itemLst;
    }
}

