/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.intertrans.syndata.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ict.business.bean.RelCFRecord;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.intertrans.syndata.AbstractRelRecord;
import kd.fi.ict.business.intertrans.syndata.FilterParam;
import kd.fi.ict.business.intertrans.utils.PullDataLogUtils;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.enums.VerifyType;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.PuchLogFactory;
import kd.fi.ict.util.AccountServiceHelper;

public abstract class CFRelRecord
extends AbstractRelRecord {
    public CFRelRecord(FilterParam param, ProgressContext dataSynCtx) {
        super(param, dataSynCtx);
    }

    @Override
    public void saveRelRecords(List<RelRecord> records) {
        ArrayList<DynamicObject> cfRecords = new ArrayList<DynamicObject>(32);
        MainEntityType cfRecordType = EntityMetadataCache.getDataEntityType((String)"ict_relcfrecord");
        Long zero = Long.valueOf("0");
        for (RelRecord record : records) {
            Long opOrg = record.getOporg();
            if (opOrg == null || opOrg.compareTo(zero) == 0) continue;
            RelCFRecord cfRecord = (RelCFRecord)record;
            DynamicObject dynRecord = this.createDynamicObject(record, (DynamicObjectType)cfRecordType);
            dynRecord.set("amt", (Object)cfRecord.getAmt());
            dynRecord.set("amtbal", (Object)cfRecord.getAmtbal());
            dynRecord.set("cashflowitem", (Object)cfRecord.getCashFlowItem());
            dynRecord.set("baldc", (Object)cfRecord.getBaldc());
            dynRecord.set("bookeddate", (Object)cfRecord.getBookedate());
            dynRecord.set("ori_period", (Object)cfRecord.getOri_period());
            dynRecord.set("concurrency", (Object)cfRecord.getCurrency());
            dynRecord.set("convertamt", (Object)cfRecord.getAmt());
            dynRecord.set("convertamtbal", (Object)cfRecord.getAmtbal());
            dynRecord.set("isconvert", (Object)"0");
            cfRecords.add(dynRecord);
        }
        if (!cfRecords.isEmpty()) {
            try (TXHandle handle = TX.requiresNew((String)CFRelRecord.class.getName());){
                try {
                    SaveServiceHelper.save((IDataEntityType)cfRecordType, (Object[])cfRecords.toArray(new DynamicObject[0]));
                    PullDataLogUtils.insertPullAcctLog(this.getLogFormKey(), records);
                    IPuchAmtLog checkBalLog = PuchLogFactory.getPuchLog("ict_relcfrecord");
                    checkBalLog.setAddLog(cfRecords.toArray(new DynamicObject[0]), OperationType.PULLDATA);
                }
                catch (Exception e) {
                    handle.markRollback();
                    this.isException.compareAndSet(false, true);
                    log.error((Throwable)e);
                    throw e;
                }
            }
        }
    }

    @Override
    protected String getFormKey() {
        return "ict_relcfrecord";
    }

    @Override
    protected VerifyType getVerifyType() {
        return VerifyType.CF;
    }

    @Override
    protected List<String> getTransactionType() {
        return Collections.singletonList("4");
    }

    @Override
    protected String getSchemaItemField() {
        return "cashflowitem";
    }

    @Override
    protected String getVchItemField() {
        return "maincfitem";
    }

    @Override
    protected String getVchItemAssgrpField() {
        return "maincfassgrp";
    }

    @Override
    protected String getLogFormKey() {
        return "ict_pullcfdetaillog";
    }

    @Override
    protected Set<Long> getChildNode(Long orgId, DynamicObject[] verifySchemas) {
        HashSet<Long> itemLst = new HashSet<Long>(32);
        for (DynamicObject verifySchema : verifySchemas) {
            DynamicObjectCollection entrys = verifySchema.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                long masterId = entry.getLong(this.getSchemaItemField() + ".masterid");
                if (masterId > 0L) {
                    Set cfIds = AccountServiceHelper.getChildrenIdsByCfItemNumber((long)orgId, (long)masterId, (boolean)true, (boolean)true);
                    itemLst.addAll(cfIds);
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"%1$s\u65b9\u6848\u4e2d\u7684\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u57fa\u7840\u8d44\u6599\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u5bf9\u8d26\u65b9\u6848\u914d\u7f6e\u3002", (String)"CFRelRecord_0", (String)"fi-ict-business", (Object[])new Object[]{verifySchema.getString("name")}));
            }
        }
        return itemLst;
    }
}

