/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.intertrans.syndata.plugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatTypes;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.business.bean.RelAcctRecord;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.intertrans.syndata.FilterParam;
import kd.fi.ict.business.intertrans.syndata.plugin.AcctRelRecord;
import kd.fi.ict.business.intertrans.utils.PullDataLogUtils;
import kd.fi.ict.constant.GLField;
import kd.fi.ict.util.AccountServiceHelper;
import kd.fi.ict.util.PeriodUtil;
import kd.fi.ict.util.PermissonType;
import kd.fi.ict.util.RelTransInitUtils;

public class InitRelAcctRecord
extends AcctRelRecord {
    public InitRelAcctRecord(FilterParam param, ProgressContext dataSynCtx) {
        super(param, dataSynCtx);
    }

    @Override
    protected String importBalance(AccountBookInfo accountBook, DynamicObject verifyEntiry) {
        long orgId = accountBook.getOrgId();
        long bookstypeId = accountBook.getBookTypeId();
        long currencyId = accountBook.getBaseCurrencyId();
        long curPeriodId = this.getPeriodByDate(accountBook);
        long curAccountTableId = AccountRefUtils.getCurPeriodAccountTableId((long)orgId, (long)bookstypeId, (long)curPeriodId);
        if (curPeriodId == 0L) {
            String beginBookdate = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId())).format(this.filterParam.getBeginBookDate());
            throw new KDBizException(ResManager.loadKDString((String)"%1$s\u8d26\u7c3f\u5728%2$s\u672a\u542f\u7528\u3002", (String)"InitRelAcctRecord_2", (String)"fi-ict-business", (Object[])new Object[]{accountBook.getOrgName(), beginBookdate}));
        }
        DynamicObject item = verifyEntiry.getDynamicObject(this.getSchemaItemField());
        if (Objects.isNull(item)) {
            return "";
        }
        long e_accounttableId = verifyEntiry.getLong(GLField.id((String)"e_accounttable"));
        if (curAccountTableId != e_accounttableId) {
            return "";
        }
        Set<Long> masterids = InitRelAcctRecord.getChildrenIdsByAcctNumber(orgId, curAccountTableId, item.getLong("masterid"));
        if (masterids.size() == 0) {
            return "";
        }
        DynamicObject interiorassgrp = verifyEntiry.getDynamicObject("interiorassgrp");
        List rows = RelTransInitUtils.queryAcctBalance((Long)orgId, (Long)bookstypeId, (long)curAccountTableId, (Long)curPeriodId, masterids, (Long)currencyId, (DynamicObject)interiorassgrp);
        if (rows == null || rows.isEmpty()) {
            String msg = ResManager.loadKDString((String)"[%s]\u79d1\u76ee\u5f53\u524d\u671f\u95f4\u4e0b\uff0c\u8be5\u79d1\u76ee\u4f59\u989d\u4e3a0\u3002", (String)"InitRelAcctRecord_0", (String)"fi-ict-business", (Object[])new Object[]{item.getString("name")});
            PullDataLogUtils.insertPullAcctLog(this.getLogFormKey(), Long.valueOf(RequestContext.get().getUserId()), orgId, msg, "2");
            return msg;
        }
        this.buildAcctRecord(rows, accountBook, curPeriodId, verifyEntiry);
        return null;
    }

    public static Set<Long> getChildrenIdsByAcctNumber(long orgId, long accountTableId, long acctId) {
        HashSet<Long> acctIds = new HashSet<Long>(10);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)acctId, (String)"bd_accountview");
        QFilter filters = new QFilter("longnumber", "like", (Object)(dyn.getString("longnumber") + "%"));
        filters.and(new QFilter("accounttable", "=", (Object)accountTableId));
        filters.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
        DynamicObjectCollection dynColl = QueryServiceHelper.query((String)AccountServiceHelper.class.getName(), (String)"bd_accountview", (String)"longnumber,id,isleaf", (QFilter[])filters.toArray(), null);
        dynColl.forEach(v -> {
            Boolean isleaf = v.getBoolean("isleaf");
            if (isleaf.booleanValue()) {
                acctIds.add(v.getLong("id"));
            }
        });
        return acctIds;
    }

    private void buildAcctRecord(List<Map<String, Object>> acctBalLst, AccountBookInfo bookInfo, Long curPeriodId, DynamicObject verifyEntiry) {
        ArrayList<RelRecord> recordLst = new ArrayList<RelRecord>(32);
        DynamicObject verifySchema = (DynamicObject)verifyEntiry.getParent();
        Date createTime = TimeServiceHelper.now();
        DynamicObject item = verifyEntiry.getDynamicObject("account");
        Set columns = item.getDataEntityType().getProperties().stream().map(IMetadata::getName).collect(Collectors.toSet());
        if (!columns.contains("dc")) {
            log.info("-InitRelAcctRecord- {}", (Object)item);
            return;
        }
        String sdc = item.getString("dc");
        long orgId = bookInfo.getOrgId();
        DynamicObject orgDyn = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        long bookTypeId = bookInfo.getBookTypeId();
        long acctTableId = bookInfo.getAccountTableId();
        long baseCurrencyId = bookInfo.getBaseCurrencyId();
        DynamicObject curPeriodDyn = PeriodUtil.getCurrentPeriod((Object)curPeriodId);
        long[] ids = DB.genLongIds((String)"t_ict_relacctrecord", (int)acctBalLst.size());
        int index = 0;
        for (Map<String, Object> row : acctBalLst) {
            RelAcctRecord record = new RelAcctRecord();
            record.setOrg(orgId);
            long vchId = ids[index];
            record.setVoucherId(vchId);
            record.setVoucherEntryId(vchId);
            ++index;
            if (!this.validator(row, verifyEntiry, record)) continue;
            BigDecimal beginAmtLocal = new BigDecimal(row.get("beginlocal").toString());
            record.setAmtloc(beginAmtLocal);
            record.setAmtballoc(beginAmtLocal);
            BigDecimal reate = record.getAmt().compareTo(BigDecimal.ZERO) != 0 ? record.getAmtloc().divide(record.getAmt(), 10, RoundingMode.HALF_UP) : BigDecimal.ONE;
            record.setLocalrate(reate);
            record.setDc(item.getString("dc"));
            record.setBaldc(sdc);
            record.setBooktype(bookTypeId);
            record.setCreatetime(createTime);
            record.setAccounttable(acctTableId);
            record.setCurrency(Long.parseLong(row.get("currency").toString()));
            record.setCurrencyloc(baseCurrencyId);
            record.setAccount(Long.valueOf(row.get("account").toString()));
            record.setPeriod(curPeriodId);
            record.setOri_period(curPeriodId);
            Date date = curPeriodDyn.getDate("begindate");
            record.setBookedate(date);
            record.setBizdate(date);
            record.setStatus("0");
            record.setIsinitrecord("1");
            record.setRelevanceType(verifySchema.getString("transactiontype"));
            record.setReconscheme(verifySchema.getLong("masterid"));
            String description = ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u671f\u95f4\u5bf9\u8d26\u521d\u59cb\u4f59\u989d", (String)"InitRelAcctRecord_1", (String)"fi-ict-business", (Object[])new Object[]{orgDyn.getString("name"), curPeriodDyn.getString("name")});
            record.setEdescription(description);
            recordLst.add(record);
            if (recordLst.size() % 1000 != 0) continue;
            this.saveRelRecords(recordLst);
            recordLst.clear();
        }
        if (!recordLst.isEmpty()) {
            this.saveRelRecords(recordLst);
            recordLst.clear();
        }
    }

    private boolean validator(Map<String, Object> row, DynamicObject verifyEntiry, RelRecord record) {
        BigDecimal beginAmt = new BigDecimal(row.get("beginfor").toString());
        if (beginAmt.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        record.setAmt(beginAmt);
        record.setAmtbal(beginAmt);
        this.setOpOrg(record, row, verifyEntiry);
        return null != record.getOporg() && record.getOporg() != 0L && !record.getOrg().equals(record.getOporg());
    }

    @Override
    protected PermissonType getPermissonType() {
        return PermissonType.JTNBJYINIT;
    }
}

