/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.intertrans.syndata.plugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatTypes;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.business.bean.RelCFRecord;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.intertrans.syndata.FilterParam;
import kd.fi.ict.business.intertrans.syndata.plugin.CFRelRecord;
import kd.fi.ict.business.intertrans.utils.PullDataLogUtils;
import kd.fi.ict.util.AccountServiceHelper;
import kd.fi.ict.util.PeriodUtil;
import kd.fi.ict.util.PermissonType;
import kd.fi.ict.util.RelTransInitUtils;

public class InitRelCFRecord
extends CFRelRecord {
    public InitRelCFRecord(FilterParam param, ProgressContext dataSynCtx) {
        super(param, dataSynCtx);
    }

    @Override
    protected String importBalance(AccountBookInfo acctBook, DynamicObject verifyEntiry) {
        long orgId = acctBook.getOrgId();
        long bookstypeId = acctBook.getBookTypeId();
        long curPeriodId = this.getPeriodByDate(acctBook);
        if (curPeriodId == 0L) {
            String beginBookdate = FormatFactory.get((FormatTypes)FormatTypes.Date).getFormat(InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId())).format(this.filterParam.getBeginBookDate());
            throw new KDBizException(ResManager.loadKDString((String)"%1$s\u8d26\u7c3f\u5728%2$s\u672a\u542f\u7528\u3002", (String)"InitRelCFRecord_2", (String)"fi-ict-business", (Object[])new Object[]{acctBook.getOrgName(), beginBookdate}));
        }
        DynamicObject item = verifyEntiry.getDynamicObject(this.getSchemaItemField());
        if (Objects.isNull(item)) {
            return "";
        }
        Set<Long> masterIds = InitRelCFRecord.getChildrenIdsByCfItemNumber(orgId, item.getLong("masterid"));
        if (masterIds.isEmpty()) {
            return "";
        }
        DynamicObject interiorassgrp = verifyEntiry.getDynamicObject("interiorassgrp");
        List rows = RelTransInitUtils.queryCFBalance((Long)orgId, (Long)bookstypeId, (Long)curPeriodId, masterIds, (DynamicObject)interiorassgrp);
        if (rows == null || rows.isEmpty()) {
            String msg = ResManager.loadKDString((String)"[%s]\u73b0\u91d1\u6d41\u91cf\u5f53\u524d\u671f\u95f4\u4e0b\uff0c\u8be5\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u4f59\u989d\u4e3a0\u3002", (String)"InitRelCFRecord_0", (String)"fi-ict-business", (Object[])new Object[]{item.getString("name")});
            PullDataLogUtils.insertPullAcctLog(this.getLogFormKey(), Long.valueOf(RequestContext.get().getUserId()), orgId, msg, "2");
            return msg;
        }
        this.buildAcctRecord(rows, acctBook, curPeriodId, verifyEntiry);
        return null;
    }

    public static Set<Long> getChildrenIdsByCfItemNumber(long orgId, long cfItemId) {
        HashSet<Long> cfItemIds = new HashSet<Long>(0);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)cfItemId, (String)"gl_cashflowitem");
        QFilter filters = new QFilter("longnumber", "like", (Object)(dyn.getString("longnumber") + "%"));
        filters.and(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId));
        DynamicObjectCollection dynColl = QueryServiceHelper.query((String)AccountServiceHelper.class.getName(), (String)"gl_cashflowitem", (String)"longnumber,masterid,isleaf", (QFilter[])filters.toArray(), null);
        dynColl.forEach(v -> {
            Boolean isleaf = v.getBoolean("isleaf");
            if (isleaf.booleanValue()) {
                cfItemIds.add(v.getLong("masterid"));
            }
        });
        return cfItemIds;
    }

    private void buildAcctRecord(List<Map<String, Object>> acctBalLst, AccountBookInfo bookInfo, Long curPeriodId, DynamicObject verifyEntiry) {
        ArrayList<RelRecord> recordLst = new ArrayList<RelRecord>(32);
        DynamicObject verifySchema = (DynamicObject)verifyEntiry.getParent();
        Date createTime = TimeServiceHelper.now();
        DynamicObject item = verifyEntiry.getDynamicObject("cashflowitem");
        long orgId = bookInfo.getOrgId();
        DynamicObject orgDyn = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        long bookTypeId = bookInfo.getBookTypeId();
        long acctTableId = bookInfo.getAccountTableId();
        DynamicObject curPeriodDyn = PeriodUtil.getCurrentPeriod((Object)curPeriodId);
        long[] ids = DB.genLongIds((String)"t_ict_relcfrecord", (int)acctBalLst.size());
        int index = 0;
        for (Map<String, Object> row : acctBalLst) {
            RelCFRecord record = new RelCFRecord();
            long vchId = ids[index];
            record.setVoucherId(vchId);
            record.setVoucherEntryId(vchId);
            ++index;
            BigDecimal yearAmount = new BigDecimal(row.get("yearamount").toString());
            BigDecimal amount = new BigDecimal(row.get("amount").toString());
            BigDecimal beginAmt = yearAmount.subtract(amount);
            if (beginAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            record.setDc(item.getString("direction"));
            record.setAmt(beginAmt);
            record.setAmtbal(beginAmt);
            record.setConcurrency(Long.parseLong(row.get("currency").toString()));
            record.setConvert(false);
            record.setConvertamt(beginAmt);
            record.setConvertamtbal(beginAmt);
            record.setOrg(orgId);
            record.setBooktype(bookTypeId);
            record.setCreatetime(createTime);
            record.setAccounttable(acctTableId);
            record.setCurrency(Long.parseLong(row.get("currency").toString()));
            record.setCashFlowItem(Long.valueOf(row.get("cfitem").toString()));
            record.setPeriod(curPeriodId);
            record.setOri_period(curPeriodId);
            Date date = curPeriodDyn.getDate("begindate");
            record.setBookedate(date);
            record.setBizdate(date);
            record.setStatus("0");
            record.setIsinitrecord("1");
            record.setRelevanceType(verifySchema.getString("transactiontype"));
            record.setReconscheme(verifySchema.getLong("masterid"));
            this.setOpOrg(record, row, verifyEntiry);
            if (record.getOrg().equals(record.getOporg())) continue;
            String description = ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u671f\u95f4\u5bf9\u8d26\u521d\u59cb\u4f59\u989d", (String)"InitRelCFRecord_1", (String)"fi-ict-business", (Object[])new Object[]{orgDyn.getString("name"), curPeriodDyn.getString("name")});
            record.setEdescription(description);
            recordLst.add(record);
            if (recordLst.size() % 1000 != 0) continue;
            this.saveRelRecords(recordLst);
            recordLst.clear();
        }
        if (!recordLst.isEmpty()) {
            this.saveRelRecords(recordLst);
            recordLst.clear();
        }
    }

    @Override
    protected PermissonType getPermissonType() {
        return PermissonType.JTNBJYINIT;
    }
}

