/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.intertrans.syndata.plugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.business.bean.RelAcctRecord;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.intertrans.syndata.FilterParam;
import kd.fi.ict.business.intertrans.syndata.plugin.AcctRelRecord;
import kd.fi.ict.util.PermissonType;

public class PullRelAcctRecord
extends AcctRelRecord {
    public PullRelAcctRecord(FilterParam param, ProgressContext dataSynCtx) {
        super(param, dataSynCtx);
    }

    @Override
    protected RelRecord buildSingleRelRecord(AccountBookInfo bookInfo, DynamicObject vchEntry) {
        RelAcctRecord record = new RelAcctRecord();
        record.setCurrencyloc(bookInfo.getBaseCurrencyId());
        record.setCurrency(vchEntry.getLong("currency.id"));
        record.setAccount(vchEntry.getLong("account.id"));
        record.setAssgrp(vchEntry.getLong("assgrp.id"));
        record.setAccounttable(bookInfo.getAccountTableId());
        record.setDc(vchEntry.getString("entrydc"));
        String dc = vchEntry.getString("entrydc");
        if ("-1".equals(dc)) {
            BigDecimal creditAmtLocal = vchEntry.getBigDecimal("creditlocal");
            record.setAmtloc(creditAmtLocal);
            record.setAmtballoc(creditAmtLocal);
            BigDecimal creditAmt = vchEntry.getBigDecimal("creditori");
            record.setAmt(creditAmt);
            record.setAmtbal(creditAmt);
        } else {
            BigDecimal debitAmtLocal = vchEntry.getBigDecimal("debitlocal");
            record.setAmtloc(debitAmtLocal);
            record.setAmtballoc(debitAmtLocal);
            BigDecimal debitAmt = vchEntry.getBigDecimal("debitori");
            record.setAmt(debitAmt);
            record.setAmtbal(debitAmt);
        }
        if (record.getAmtloc().multiply(new BigDecimal(dc)).compareTo(BigDecimal.ZERO) > 0) {
            record.setBaldc("1");
        } else {
            record.setBaldc("-1");
        }
        record.setLocalrate(vchEntry.getBigDecimal("localrate"));
        return record;
    }

    @Override
    protected boolean nonZero(DynamicObject vchEntry) {
        return vchEntry.getBigDecimal("creditlocal").compareTo(BigDecimal.ZERO) == 0 && vchEntry.getBigDecimal("debitlocal").compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    protected PermissonType getPermissonType() {
        return PermissonType.JTNBJYPULL;
    }
}

