/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.intertrans.syndata.plugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.business.bean.RelCFRecord;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.intertrans.syndata.FilterParam;
import kd.fi.ict.business.intertrans.syndata.plugin.CFRelRecord;
import kd.fi.ict.util.PermissonType;

public class PullRelCFRecord
extends CFRelRecord {
    public PullRelCFRecord(FilterParam param, ProgressContext dataSynCtx) {
        super(param, dataSynCtx);
    }

    @Override
    protected RelRecord buildSingleRelRecord(AccountBookInfo bookInfo, DynamicObject vchEntry) {
        RelCFRecord record = new RelCFRecord();
        record.setCurrency(((DynamicObject)vchEntry.getParent()).getLong("localcur.id"));
        record.setCashFlowItem(vchEntry.getLong("maincfitem.id"));
        record.setAssgrp(vchEntry.getLong("maincfassgrp.id"));
        String dc = vchEntry.getString("entrydc");
        BigDecimal creditAmt = vchEntry.getBigDecimal("maincfamount");
        record.setAmt(creditAmt);
        record.setAmtbal(creditAmt);
        if (record.getAmt().multiply(new BigDecimal(dc)).compareTo(BigDecimal.ZERO) > 0) {
            record.setBaldc("1");
        } else {
            record.setBaldc("-1");
        }
        record.setDc(vchEntry.getDynamicObject("maincfitem").getString("direction"));
        return record;
    }

    @Override
    protected boolean nonZero(DynamicObject vchEntry) {
        return vchEntry.getBigDecimal("maincfamount").compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    protected PermissonType getPermissonType() {
        return PermissonType.JTNBJYPULL;
    }
}

