/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.intertrans.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ict.business.bean.RelRecord;

public class AssgrpHandler {
    private static final String BOS_ORG = "bos_org";
    private static final String INTERNAL_COMPANY = "internal_company";
    private static final int INIT_CAPACITY = 32;
    private static final Log log = LogFactory.getLog(AssgrpHandler.class);

    public void handle(List<RelRecord> relRecords) {
        HashMap<String, Map<Object, List<RelRecord>>> valSourceAndDetialIdMap = new HashMap<String, Map<Object, List<RelRecord>>>(32);
        for (RelRecord record : relRecords) {
            this.buildFlexItemAndRecordMap(valSourceAndDetialIdMap, record);
        }
        this.updateOpOrgId(valSourceAndDetialIdMap);
        this.areValidRecord(relRecords);
    }

    private void areValidRecord(List<RelRecord> relRecords) {
        relRecords.removeIf(record -> record.getOporg() == null || record.getOporg() <= 0L || record.getOporg().equals(record.getOrg()));
    }

    private void updateOpOrgId(Map<String, Map<Object, List<RelRecord>>> valSourceAndDetialIdMap) {
        for (Map.Entry<String, Map<Object, List<RelRecord>>> entry : valSourceAndDetialIdMap.entrySet()) {
            String entityName = entry.getKey();
            if (StringUtils.isEmpty((String)entityName)) {
                this.logError(ResManager.loadKDString((String)"\u83b7\u53d6\u5185\u90e8\u4ea4\u6613\u7ec4\u7ec7\u5bf9\u5e94EntityName\u5931\u8d25", (String)"AssgrpHandler_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            }
            Map<Object, List<RelRecord>> idAndRecordMap = entry.getValue();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
            DynamicProperty property = entityType.getProperty(INTERNAL_COMPANY);
            if (property == null) {
                this.logError(String.format(ResManager.loadKDString((String)"\u83b7\u53d6%s\u5185\u90e8\u4ea4\u6613\u7ec4\u7ec7\u5c5e\u6027\u5931\u8d25", (String)"AssgrpHandler_1", (String)"bos-ext-fi", (Object[])new Object[0]), entityName));
            }
            Map entitys = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)entityType, (QFilter[])new QFilter[]{new QFilter(entityType.getPrimaryKey().getName(), "in", idAndRecordMap.keySet())});
            for (Map.Entry entity : entitys.entrySet()) {
                List<RelRecord> records = idAndRecordMap.get(entity.getKey());
                if (records == null) continue;
                Long oppOrgId = ((DynamicObject)entity.getValue()).getLong("internal_company.id");
                for (RelRecord record : records) {
                    record.setOporg(oppOrgId);
                }
            }
        }
    }

    private void logError(String msg) {
        log.error("\u5173\u8054\u4ea4\u6613\u65e5\u5fd7\uff1a" + msg);
        throw new KDBizException(msg);
    }

    private void buildFlexItemAndRecordMap(Map<String, Map<Object, List<RelRecord>>> valSourceAndDetialIdMap, RelRecord record) {
        String oppValSource = record.getOppValueSource();
        if (StringUtils.isEmpty((String)oppValSource) || BOS_ORG.equals(oppValSource)) {
            return;
        }
        Map detailIdAndRecordMap = valSourceAndDetialIdMap.computeIfAbsent(oppValSource, k -> new HashMap(32));
        List tmpRecords = detailIdAndRecordMap.computeIfAbsent(record.getOppFlexItemId(), k -> new ArrayList(32));
        tmpRecords.add(record);
    }
}

