/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.intertrans.utils;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.util.ContextUtil;

public class PullDataLogUtils {
    public static void warnLog(String formKey, List<DynamicObject> dynLst) {
        ArrayList logLst = new ArrayList(32);
        dynLst.forEach(dyn -> {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)formKey);
            obj.set("creator", (Object)ContextUtil.getUserId());
            obj.set("org", (Object)dyn.getLong("org"));
            obj.set("voucherid", (Object)dyn.getLong("voucherid"));
            obj.set("vchnumber", (Object)dyn.getString("billno"));
            obj.set("bookeddate", (Object)dyn.getDate("bookeddate"));
            obj.set("execdetail", (Object)ResManager.loadKDString((String)"\u8be5\u8bb0\u5f55\u5df2\u7ecf\u62bd\u53d6\uff0c\u8bf7\u5220\u9664\u540e\uff0c\u518d\u91cd\u65b0\u62bd\u53d6\u6570\u636e", (String)"PullDataLogUtils_0", (String)"fi-ict-business", (Object[])new Object[0]));
            obj.set("status", (Object)"2");
            obj.set("createtime", (Object)TimeServiceHelper.getTimeStamp());
            logLst.add(obj);
        });
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])logLst.toArray(new DynamicObject[0]));
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void insertPullAcctLog(String formKey, List<RelRecord> records) {
        ArrayList<DynamicObject> logDynLst = new ArrayList<DynamicObject>(records.size());
        for (RelRecord record : records) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)formKey);
            obj.set("creator", (Object)ContextUtil.getUserId());
            obj.set("org", (Object)record.getOrg());
            obj.set("voucherid", (Object)record.getVoucherId());
            obj.set("vchnumber", (Object)record.getBillno());
            obj.set("bookeddate", (Object)record.getBookedate());
            obj.set("execdetail", (Object)ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"PullDataLogUtils_1", (String)"fi-ict-business", (Object[])new Object[0]));
            obj.set("status", (Object)"1");
            obj.set("createtime", (Object)TimeServiceHelper.getTimeStamp());
            logDynLst.add(obj);
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])logDynLst.toArray(new DynamicObject[0]));
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void insertPullAcctLog(String formKey, Long creatorId, Long orgId, String execdetail, String status) {
        PullDataLogUtils.insertPullAcctLog(formKey, creatorId, orgId, "", execdetail, status);
    }

    public static void insertPullAcctLog(String formKey, Long creatorId, Long orgId, String vchnumber, String execdetail, String status) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)formKey);
        obj.set("creator", (Object)creatorId);
        obj.set("org", (Object)orgId);
        obj.set("vchnumber", (Object)vchnumber);
        obj.set("execdetail", (Object)execdetail);
        obj.set("status", (Object)status);
        obj.set("createtime", (Object)TimeServiceHelper.getTimeStamp());
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

