/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.intertrans.utils;

import java.math.BigDecimal;
import java.util.List;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationEntityInfo;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationInfo;

public class ToleranceUtil {
    public static boolean toleranceBentiry(ManualReconciliationInfo manualReconciliationInfo) {
        List bentityInfo = manualReconciliationInfo.getBentityInfo();
        return ToleranceUtil.entityInfoCompare(bentityInfo);
    }

    public static boolean toleranceDentiry(ManualReconciliationInfo manualReconciliationInfo) {
        List dentityInfo = manualReconciliationInfo.getDentityInfo();
        return ToleranceUtil.entityInfoCompare(dentityInfo);
    }

    private static boolean entityInfoCompare(List<ManualReconciliationEntityInfo> entityInfo) {
        for (ManualReconciliationEntityInfo info : entityInfo) {
            if (info.getTaoriamount().abs().subtract(info.getNoriamount().abs()).compareTo(BigDecimal.ZERO) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean totalAcctAmt(ManualReconciliationInfo manualReconciliationInfo) {
        BigDecimal b_totalAmt = BigDecimal.ZERO;
        for (ManualReconciliationEntityInfo b_info : manualReconciliationInfo.getBentityInfo()) {
            BigDecimal dc = new BigDecimal(Integer.parseInt(b_info.getEntrydc()));
            b_totalAmt = b_totalAmt.add(b_info.getTaoriamount().multiply(dc));
        }
        BigDecimal d_totalAmt = BigDecimal.ZERO;
        for (ManualReconciliationEntityInfo d_info : manualReconciliationInfo.getDentityInfo()) {
            BigDecimal dc = new BigDecimal(Integer.parseInt(d_info.getEntrydc()));
            d_totalAmt = d_totalAmt.add(d_info.getTaoriamount().multiply(dc));
        }
        return d_totalAmt.add(b_totalAmt).compareTo(BigDecimal.ZERO) != 0;
    }

    public static boolean totalCashFlowAmt(ManualReconciliationInfo manualReconciliationInfo) {
        BigDecimal b_totalAmt = BigDecimal.ZERO;
        for (ManualReconciliationEntityInfo b_info : manualReconciliationInfo.getBentityInfo()) {
            if ("o".equals(b_info.getEntryCashDc())) {
                b_totalAmt = b_totalAmt.add(b_info.getTaoriamount().multiply(new BigDecimal("-1")));
                continue;
            }
            b_totalAmt = b_totalAmt.add(b_info.getTaoriamount());
        }
        BigDecimal d_totalAmt = BigDecimal.ZERO;
        for (ManualReconciliationEntityInfo d_info : manualReconciliationInfo.getDentityInfo()) {
            if ("o".equals(d_info.getEntryCashDc())) {
                d_totalAmt = d_totalAmt.add(d_info.getTaoriamount().multiply(new BigDecimal("-1")));
                continue;
            }
            d_totalAmt = d_totalAmt.add(d_info.getTaoriamount());
        }
        return b_totalAmt.add(d_totalAmt).compareTo(BigDecimal.ZERO) != 0;
    }
}

