/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.nodiffaudit;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ict.business.bean.NoDiffAuditParam;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.cancelcheck.bean.AuditRecordRow;
import kd.fi.ict.business.handle.ProgressContext;
import kd.fi.ict.business.handle.ProgressResult;
import kd.fi.ict.business.nodiffaudit.INoDiffAuditService;
import kd.fi.ict.business.nodiffaudit.impl.NoDiffAuditAcctService;
import kd.fi.ict.business.nodiffaudit.impl.NoDiffAuditCfService;
import kd.fi.ict.common.GenBillNoHelper;
import kd.fi.ict.enums.CheckStatus;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.enums.RecordBillStatus;
import kd.fi.ict.pullcheck.BookKey;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.PuchLogFactory;
import kd.fi.ict.util.ICTResManagerUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractNoDiffAuditService
implements INoDiffAuditService {
    NoDiffAuditParam auditParam;
    private List<Object> crossRecordEntryIds = new ArrayList<Object>(10);
    private List<Object> checkLogIds = new ArrayList<Object>(10);
    private Set<BookKey> bookSet = Sets.newHashSetWithExpectedSize((int)10);
    private DynamicObject scheme;
    private static final int BATCH_SIZE = 10000;
    private static final Log logger = LogFactory.getLog(AbstractNoDiffAuditService.class);
    protected ProgressContext pgsCtx;

    @Override
    public void setDataSynContext(ProgressContext progressContext) {
        this.pgsCtx = progressContext;
    }

    @Override
    public ProgressResult auditProcess(NoDiffAuditParam auditParam) {
        this.scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)auditParam.getSchemeId(), (String)"ict_verifyscheme");
        this.auditParam = auditParam;
        return this.audit();
    }

    private ProgressResult audit() {
        String ownOrgName = this.getOrgName(this.auditParam.getOrgId());
        String opOrgName = this.getOrgName(this.auditParam.getOpOrgId());
        String tipMsg = String.format(ICTResManagerUtils.getPgsAutoReconFinished(), this.scheme.getString("name"), ownOrgName, opOrgName);
        this.pgsCtx.setAllProgressTip(this.pgsCtx.getTaskId(), tipMsg);
        SqlBuilder orgRelRecordsSql = this.getOrgRelRecordsSql();
        Pair<List<Object>, BigDecimal> relRecordReslut = this.getRelRecordAmt(orgRelRecordsSql);
        SqlBuilder opOrgRelRecordsSql = this.getOpOrgRelRecordsSql();
        Pair<List<Object>, BigDecimal> opRelRecordReslut = this.getRelRecordAmt(opOrgRelRecordsSql);
        List relRecordIds = (List)relRecordReslut.getLeft();
        List opRelRecordIds = (List)opRelRecordReslut.getLeft();
        if (relRecordIds.isEmpty() || opRelRecordIds.isEmpty()) {
            return new ProgressResult(false, String.format(ICTResManagerUtils.getPgsNoDiffAuditNotData(), this.scheme.getString("name"), ownOrgName, opOrgName));
        }
        if (BigDecimal.ZERO.compareTo(((BigDecimal)relRecordReslut.getRight()).add((BigDecimal)opRelRecordReslut.getRight())) != 0) {
            return new ProgressResult(false, String.format(ICTResManagerUtils.getPgsNoDiffAuditAmtNE(), this.scheme.getString("name"), ownOrgName, opOrgName));
        }
        relRecordIds.addAll(opRelRecordIds);
        try {
            if (relRecordIds.size() > 10000) {
                this.batchProcess(relRecordIds);
            } else {
                this.saveCrossRecord(relRecordIds, false);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return new ProgressResult(false, String.format(ICTResManagerUtils.getPgsNoDiffAuditError(), this.scheme.getString("name"), ownOrgName, opOrgName, e.getMessage()));
        }
        return new ProgressResult(true, String.format(ICTResManagerUtils.getPgsNoDiffAuditFinished(), this.scheme.getString("name"), ownOrgName, opOrgName));
    }

    private void batchProcess(List<Object> relRecordIds) {
        try {
            this.batchsaveCREntry(relRecordIds);
            this.batchAddCheckLog();
            this.saveCrossRecord(relRecordIds, true);
        }
        catch (Exception e) {
            this.rollBackDelTempData();
            throw e;
        }
    }

    private void batchsaveCREntry(List<Object> relRecordIds) {
        List partList = Lists.partition(relRecordIds, (int)10000);
        int seq = 0;
        for (List part : partList) {
            TXHandle tx = TX.requiresNew((String)"noDiffAuditService");
            Throwable throwable = null;
            try {
                try {
                    seq = this.saveCrossRecordEntry(part, 0L, seq);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error((Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
    }

    private void batchAddCheckLog() {
        if (this.crossRecordEntryIds.isEmpty()) {
            return;
        }
        String formKey = this instanceof NoDiffAuditAcctService ? "ict_relacctrecord" : "ict_relcfrecord";
        IPuchAmtLog checkBalLog = PuchLogFactory.getPuchLog(formKey);
        List partList = Lists.partition(this.crossRecordEntryIds, (int)999);
        for (List part : partList) {
            SqlBuilder crossRecordEntrySql = this.getCrossRecordEntrySql(part);
            DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)crossRecordEntrySql, rh -> {
                ArrayList<AuditRecordRow> auditInfos = new ArrayList<AuditRecordRow>(10);
                while (rh.next()) {
                    AuditRecordRow auditInfo = this.getAuditInfo(rh, this.auditParam.getPeriodId());
                    auditInfos.add(auditInfo);
                }
                try (TXHandle tx = TX.requiresNew((String)"noDiffAuditService");){
                    try {
                        List<Object> logIds = checkBalLog.setAddDisableCheckLog(auditInfos, OperationType.AUTOCHECK);
                        this.checkLogIds.addAll(logIds);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        logger.error((Throwable)e);
                        throw e;
                    }
                }
                return null;
            });
        }
    }

    private Object saveCrossRecord(List<Object> relRecordIds, boolean isbatch) {
        Object crossRId = null;
        try (TXHandle tx = TX.requiresNew((String)"noDiffAuditService");){
            try {
                Object[] newCRecordParam = this.getNewCRecordParam();
                crossRId = newCRecordParam[0];
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)this.insertCrossRecord(), (Object[])newCRecordParam);
                String formKey = this instanceof NoDiffAuditAcctService ? "ict_relacctrecord" : "ict_relcfrecord";
                IPuchAmtLog checkBalLog = PuchLogFactory.getPuchLog(formKey);
                if (!isbatch) {
                    this.saveCrossRecordEntry(relRecordIds, crossRId, 0);
                    DynamicObject crossRecord = BusinessDataServiceHelper.newDynamicObject((String)this.getCrossRecordEntity());
                    crossRecord.set("id", newCRecordParam[0]);
                    checkBalLog.setAddCheckLog(new DynamicObject[]{crossRecord}, OperationType.AUTOCHECK);
                } else {
                    this.updateCrossREntry(crossRId);
                    this.updateCheckLog();
                    checkBalLog.updateAmt(this.bookSet, OperationType.AUTOCHECK);
                }
                List partList = Lists.partition(relRecordIds, (int)999);
                for (List part : partList) {
                    DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)this.updateRecordSql(part));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return crossRId;
    }

    private int saveCrossRecordEntry(List<Object> relRecordIds, Object crossRId, int seqIdx) {
        SqlBuilder relRecordsSql = this.getRelRecordsSql(relRecordIds);
        return (Integer)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)relRecordsSql, rh -> {
            ArrayList<Object[]> insertCREntryParams = new ArrayList<Object[]>(1000);
            int seq = seqIdx;
            while (rh.next()) {
                RelRecord relRecord = this.getRelRecord(rh);
                this.bookSet.add(new BookKey(relRecord.getOrg(), relRecord.getBooktype()));
                insertCREntryParams.add(this.getNewCRecordEntryParam(relRecord, seq, crossRId));
                if (insertCREntryParams.size() >= 1000) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)this.insertCrossRecordEntry(), insertCREntryParams);
                    insertCREntryParams.clear();
                }
                ++seq;
            }
            if (!insertCREntryParams.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)this.insertCrossRecordEntry(), insertCREntryParams);
            }
            return seq;
        });
    }

    private void updateCrossREntry(Object crossRId) {
        if (!this.crossRecordEntryIds.isEmpty()) {
            List partList = Lists.partition(this.crossRecordEntryIds, (int)1000);
            for (List part : partList) {
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)this.getUpDateCrossREntrySql(crossRId, part));
            }
        }
    }

    private void updateCheckLog() {
        if (!this.checkLogIds.isEmpty()) {
            List partList = Lists.partition(this.checkLogIds, (int)1000);
            for (List part : partList) {
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)this.getUpDateCheckLogSql(part));
            }
        }
    }

    private SqlBuilder getUpDateCrossREntrySql(Object crossRId, List<Object> crossREntryIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("update ", new Object[0]).append(this.getCrossRecordEntryTab(), new Object[0]).append(" set fid = ? ", new Object[]{crossRId}).appendIn(" where fentryid ", crossREntryIds);
        return sql;
    }

    private SqlBuilder getUpDateCheckLogSql(List<Object> checkLogIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("update ", new Object[0]).append(this.getCheckLogTab(), new Object[0]).append(" set FPULLAMTCALED = '0',FCHECKAMTCALED = '0' ", new Object[0]).appendIn(" where fid ", checkLogIds);
        return sql;
    }

    private void rollBackDelTempData() {
        try (TXHandle tx = TX.requiresNew((String)"rollBackDelTempData");){
            try {
                List partList;
                if (!this.crossRecordEntryIds.isEmpty()) {
                    partList = Lists.partition(this.crossRecordEntryIds, (int)999);
                    for (List part : partList) {
                        DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)this.getDelCrossREntrySql(part));
                    }
                }
                if (!this.checkLogIds.isEmpty()) {
                    partList = Lists.partition(this.checkLogIds, (int)999);
                    for (List part : partList) {
                        DB.execute((DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)this.getDelCheckLogSql(part));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    private SqlBuilder getDelCrossREntrySql(List<Object> crossREntryIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("delete from ", new Object[0]).append(this.getCrossRecordEntryTab(), new Object[0]).appendIn(" where fentryid ", crossREntryIds);
        return sql;
    }

    private SqlBuilder getDelCheckLogSql(List<Object> checkLogIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("delete from ", new Object[0]).append(this.getCheckLogTab(), new Object[0]).appendIn(" where fid ", checkLogIds);
        return sql;
    }

    private Pair<List<Object>, BigDecimal> getRelRecordAmt(SqlBuilder sql) {
        return (Pair)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql, rh -> {
            ArrayList<Long> relRecordIds = new ArrayList<Long>(10);
            BigDecimal balamt = BigDecimal.ZERO;
            while (rh.next()) {
                balamt = balamt.add(this.getRelRecordAmt(rh));
                relRecordIds.add(rh.getLong("fid"));
            }
            return Pair.of(relRecordIds, (Object)balamt);
        });
    }

    private Object[] getNewCRecordParam() {
        ArrayList<Object> param = new ArrayList<Object>(10);
        long cId = this.genId(this.getCrossRecordTab());
        param.add(cId);
        param.add(this.genCrossNumber());
        param.add(this.auditParam.getPeriodId());
        param.add("3");
        param.add(this.auditParam.getSchemeId());
        param.add(this.auditParam.getOrgId());
        param.add(this.auditParam.getOpOrgId());
        param.add("2");
        param.add(" ");
        param.add(new Date());
        return param.toArray();
    }

    private Object[] getNewCRecordEntryParam(RelRecord r, int seq, Object crossRId) {
        ArrayList<Object> param = new ArrayList<Object>(22);
        long eId = this.genId(this.getCrossRecordEntryTab());
        this.crossRecordEntryIds.add(eId);
        param.add(crossRId);
        param.add(eId);
        param.add(seq);
        param.add(r.getOrg());
        param.add(r.getOporg());
        param.add(r.getId());
        param.add(r.getVoucherEntryId());
        param.add(r.getVoucherId());
        param.add(r.getBillno());
        param.add(r.getCurrency());
        param.add(r.getAssgrp());
        param.add(r.getBookedate());
        param.add(r.getDc());
        param.add(r.getEdescription());
        param.addAll(this.getNewCRecordEntryParam(r));
        return param.toArray();
    }

    protected SqlBuilder getCrossRecordEntrySql(List<Object> entryId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.appendIn(this.queryCrossRecordEntry(), entryId);
        return sqlBuilder;
    }

    protected abstract String insertCrossRecord();

    protected abstract String insertCrossRecordEntry();

    protected abstract String queryCrossRecordEntry();

    protected abstract List<Object> getNewCRecordEntryParam(RelRecord var1);

    public abstract AuditRecordRow getAuditInfo(ResultSet var1, Long var2) throws SQLException;

    private long genId(String tableName) {
        return DB.genLongId((String)tableName);
    }

    private String genCrossNumber() {
        String dateStr = this.toFormatDate();
        String crossNumber = this.genCrossNumber(this.auditParam.getOrgId(), dateStr, "4", "01");
        return crossNumber;
    }

    protected String genCrossNumber(Long orgId, String dateStr, String crossType, String seq) {
        return GenBillNoHelper.genBillNo((Long)orgId) + dateStr + crossType + seq;
    }

    protected String toFormatDate() {
        return DateUtils.formatString((Date)new Date(), (String)"yyyyMMddhhmmss");
    }

    protected abstract String getCrossRecordEntity();

    protected abstract String getCrossRecordTab();

    protected abstract String getCrossRecordEntryTab();

    protected abstract String getCheckLogTab();

    protected abstract BigDecimal getRelRecordAmt(ResultSet var1) throws SQLException;

    protected abstract RelRecord getRelRecord(ResultSet var1) throws SQLException;

    protected SqlBuilder getOrgRelRecordsSql() {
        return this.getRelRecords(OrgType.Own);
    }

    protected SqlBuilder getOpOrgRelRecordsSql() {
        return this.getRelRecords(OrgType.Opposite);
    }

    protected SqlBuilder getRelRecords(OrgType orgType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(this.getRelRecordAmtSelect(), new Object[0]).append(" where ", new Object[0]);
        sqlBuilder.append(" forgid != foporgid", new Object[0]);
        sqlBuilder.append(" and fperiodid = ?", new Object[]{this.auditParam.getPeriodId()});
        sqlBuilder.append(" and fschemeid  = ?", new Object[]{this.auditParam.getSchemeId()});
        sqlBuilder.append(" and fbillstatus = ? ", new Object[]{RecordBillStatus.NORMAL.getValue()});
        sqlBuilder.appendIn(" and fstatus ", (Object[])new String[]{CheckStatus.NONE.getValue(), CheckStatus.PART_CHECK.getValue()});
        if (OrgType.Own == orgType) {
            sqlBuilder.append(" and forgid = ? ", new Object[]{this.auditParam.getOrgId()});
            sqlBuilder.append(" and foporgid = ?", new Object[]{this.auditParam.getOpOrgId()});
        }
        if (OrgType.Opposite == orgType) {
            sqlBuilder.append(" and forgid = ? ", new Object[]{this.auditParam.getOpOrgId()});
            sqlBuilder.append(" and foporgid = ?", new Object[]{this.auditParam.getOrgId()});
        }
        if (this instanceof NoDiffAuditCfService) {
            sqlBuilder.append(" and fconcurrencyid  = ?", new Object[]{this.auditParam.getCurrencyId()});
        } else {
            sqlBuilder.append(" and fcurrencyid  = ?", new Object[]{this.auditParam.getCurrencyId()});
        }
        return sqlBuilder;
    }

    protected SqlBuilder getRelRecordsSql(List<Object> recordIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(this.getRelRecordSqlSelect(), new Object[0]);
        sqlBuilder.appendIn(" where fid ", recordIds);
        return sqlBuilder;
    }

    private String getOrgName(Long orgId) {
        QFilter[] filters = new QFilter("id", "=", (Object)orgId).toArray();
        DynamicObject ownOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"name", (QFilter[])filters);
        return ownOrg.getString("name");
    }

    protected abstract String getRelRecordAmtSelect();

    protected abstract String getRelRecordSqlSelect();

    protected abstract SqlBuilder updateRecordSql(List<Object> var1);

    static enum OrgType {
        Own,
        Opposite;

    }
}

