/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.nodiffaudit.impl;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.business.autoreconcil.util.BuildCrossRecordUtils;
import kd.fi.ict.business.bean.RelAcctRecord;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.cancelcheck.bean.AuditRecordRow;
import kd.fi.ict.business.nodiffaudit.AbstractNoDiffAuditService;

public class NoDiffAuditAcctService
extends AbstractNoDiffAuditService {
    private static final Log logger = LogFactory.getLog(NoDiffAuditAcctService.class);
    private static final String INSERT_CROSSRECORD_SQL = "INSERT INTO t_ict_cross_record (fid, fbillno, fperiodid, fchecktype, fverifyschemeid, fcurorgid, foporgid, fcheckstatus, fremark, fcreatetime) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String INSERT_CROSSRECORD_ENTRY_SQL = "INSERT INTO t_ict_cross_entry (fid,fentryid, fseq,forgid, fopporgid, frelrecordid,fvoucherentryid,fvoucherid,fvoucherno,fcurrencyid,fassgrpid,fbookeddate,fdc,fdesc, faccountid, famt, famtloc,famtverify, famtverifyloc, famtbal, famtballoc, floccurid) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String QUERY_CROSSRECORD_ENTRY_SQL = "SELECT fentryid,frelrecordid,famtverify,famtverifyloc,fdc FROM t_ict_cross_entry WHERE fentryid ";

    private Long toLongByString(String str) {
        return Long.valueOf(str);
    }

    @Override
    protected String getRelRecordAmtSelect() {
        return "select fid,famtbal,fdc from t_ict_relacctrecord ";
    }

    @Override
    protected String getRelRecordSqlSelect() {
        return "select fid,fvoucherentry,fvoucherid,fnumber,faccountid,faccounttableid,fassgrpid,fcommonassgrp,famt,famtloc,famtbal,famtballoc,fcurrencyid,fcurrencylocid,fperiodid,forgid,foporgid,fdc,fbaldc,fbookeddate,fbizdate,fedescription,fschemeid,fbooktypeid from t_ict_relacctrecord ";
    }

    @Override
    protected SqlBuilder updateRecordSql(List<Object> ids) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_ict_relacctrecord set fstatus = '2', flastupdatetime= ?, famtbal=0, famtballoc=0", new Object[]{new Date()});
        sql.appendIn("where fid ", ids);
        return sql;
    }

    @Override
    protected List<Object> getNewCRecordEntryParam(RelRecord r) {
        RelAcctRecord re = (RelAcctRecord)r;
        ArrayList<Object> param = new ArrayList<Object>(10);
        param.add(re.getAccount());
        param.add(re.getAmt());
        param.add(re.getAmtloc());
        param.add(re.getAmtbal());
        param.add(re.getAmtballoc());
        param.add(BigDecimal.ZERO);
        param.add(BigDecimal.ZERO);
        param.add(re.getCurrencyloc());
        return param;
    }

    @Override
    protected RelRecord getRelRecord(ResultSet rs) throws SQLException {
        RelAcctRecord record = new RelAcctRecord();
        record.setId(this.toLongByString(rs.getString("fid")));
        record.setVoucherEntryId(rs.getLong("fvoucherentry"));
        record.setVoucherId(rs.getLong("fvoucherid"));
        record.setBillno(rs.getString("fnumber"));
        record.setAccount(rs.getLong("faccountid"));
        record.setAccounttable(rs.getLong("faccounttableid"));
        record.setAssgrp(rs.getLong("fassgrpid"));
        record.setCommonAssgrp(rs.getString("fcommonassgrp"));
        record.setAmt(rs.getBigDecimal("famt"));
        record.setAmtloc(rs.getBigDecimal("famtloc"));
        record.setAmtbal(rs.getBigDecimal("famtbal"));
        record.setAmtballoc(rs.getBigDecimal("famtballoc"));
        record.setCurrency(rs.getLong("fcurrencyid"));
        record.setCurrencyloc(rs.getLong("fcurrencylocid"));
        record.setPeriod(rs.getLong("fperiodid"));
        record.setOrg(rs.getLong("forgid"));
        record.setOporg(rs.getLong("foporgid"));
        record.setDc(rs.getString("fdc"));
        record.setBaldc(rs.getString("fbaldc"));
        record.setBookedate(rs.getDate("fbookeddate"));
        record.setEdescription(rs.getString("fedescription"));
        record.setReconscheme(rs.getLong("fschemeid"));
        java.sql.Date date = rs.getDate("fbizdate");
        record.setBizdate(date);
        record.setBizDateInt(BuildCrossRecordUtils.toLongByDate(date));
        record.setBooktype(rs.getLong("fbooktypeid"));
        return record;
    }

    @Override
    protected String insertCrossRecord() {
        return INSERT_CROSSRECORD_SQL;
    }

    @Override
    protected String insertCrossRecordEntry() {
        return INSERT_CROSSRECORD_ENTRY_SQL;
    }

    @Override
    protected String queryCrossRecordEntry() {
        return QUERY_CROSSRECORD_ENTRY_SQL;
    }

    @Override
    protected String getCrossRecordEntity() {
        return "ict_check_record";
    }

    @Override
    protected String getCrossRecordTab() {
        return "t_ict_cross_record";
    }

    @Override
    protected String getCrossRecordEntryTab() {
        return "t_ict_cross_entry";
    }

    @Override
    protected BigDecimal getRelRecordAmt(ResultSet rs) throws SQLException {
        BigDecimal balamt = rs.getBigDecimal("famtbal");
        return balamt.multiply(BuildCrossRecordUtils.toBigDecimalByDc(rs.getString("fdc")));
    }

    @Override
    public AuditRecordRow getAuditInfo(ResultSet rs, Long periodId) throws SQLException {
        long entryId = rs.getLong("fentryid");
        long relrecordid = rs.getLong("frelrecordid");
        BigDecimal amtverify = rs.getBigDecimal("famtverify");
        BigDecimal amtverifyloc = rs.getBigDecimal("famtverifyloc");
        String dc = rs.getString("fdc");
        AuditRecordRow dr = new AuditRecordRow();
        dr.setEntryId(entryId);
        dr.setRecordId(relrecordid);
        dr.setAmt(amtverify);
        dr.setAmtloc(amtverifyloc);
        dr.setDc(dc);
        dr.setPeriodId(periodId);
        return dr;
    }

    @Override
    protected String getCheckLogTab() {
        return "t_ict_acctpuchamt_log";
    }
}

