/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.nodiffaudit.impl;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ict.business.autoreconcil.util.BuildCrossRecordUtils;
import kd.fi.ict.business.bean.RelCFRecord;
import kd.fi.ict.business.bean.RelRecord;
import kd.fi.ict.business.cancelcheck.bean.AuditRecordRow;
import kd.fi.ict.business.nodiffaudit.AbstractNoDiffAuditService;

public class NoDiffAuditCfService
extends AbstractNoDiffAuditService {
    private static final Log logger = LogFactory.getLog(NoDiffAuditCfService.class);
    private static final String INSERT_CF_CROSSRECORD_SQL = "INSERT INTO t_ict_cf_cross_record (fid, fbillno, fperiodid, fchecktype, fverifyschemeid, fcurorgid, foporgid, fcheckstatus, fremark, fcreatetime) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String INSERT_CF_CROSSRECORD_ENTRY_SQL = "INSERT INTO t_ict_cf_cross_entry (fid, fentryid,fseq,forgid,fopporgid,frelrecordid,fvoucherentryid,fvoucherid,fvoucherno,fcurrencyid,fassgrpid,fbookeddate,fdc,fdesc,fcashflowitemid,famt,famtverify,famtbal,fconcurrencyid,fconvertamt,fconvertamtverify,fconvertamtbal) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String QUERY_CF_CROSSRECORD_ENTRY_SQL = "SELECT fentryid,frelrecordid,famtverify,fconvertamtverify,fdc FROM t_ict_cf_cross_entry WHERE fentryid ";

    @Override
    protected String getRelRecordAmtSelect() {
        return "select fid,fconvertamtbal,fdc from t_ict_relcfrecord ";
    }

    @Override
    protected String getRelRecordSqlSelect() {
        return "select fid,fvoucherentry,fvoucherid,fnumber,fcashflowitemid ,faccounttableid,fassgrpid,fcommonassgrp,fconvertamt,fconvertamtbal,fconcurrencyid,famt,famtbal,fcurrencyid,fperiodid,forgid,foporgid,fdc,fbaldc,fbookeddate,fbizdate,fedescription,fschemeid,fbooktypeid from t_ict_relcfrecord ";
    }

    @Override
    protected SqlBuilder updateRecordSql(List<Object> ids) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("update t_ict_relcfrecord set fstatus = '2', flastupdatetime=?, famtbal=0, fconvertamtbal=0 ", new Object[]{new Date()});
        sql.appendIn("where fid ", ids);
        return sql;
    }

    @Override
    protected List<Object> getNewCRecordEntryParam(RelRecord r) {
        RelCFRecord re = (RelCFRecord)r;
        ArrayList<Object> param = new ArrayList<Object>(10);
        param.add(re.getCashFlowItem());
        param.add(re.getAmt());
        param.add(re.getAmtbal());
        param.add(BigDecimal.ZERO);
        param.add(re.getConcurrency());
        param.add(re.getConvertamt());
        param.add(re.getConvertamtbal());
        param.add(BigDecimal.ZERO);
        return param;
    }

    @Override
    protected String getCrossRecordTab() {
        return "t_ict_cf_cross_record";
    }

    @Override
    protected String getCrossRecordEntryTab() {
        return "t_ict_cf_cross_entry";
    }

    @Override
    protected RelRecord getRelRecord(ResultSet rs) throws SQLException {
        RelCFRecord record = new RelCFRecord();
        record.setId(rs.getLong("fid"));
        record.setVoucherEntryId(rs.getLong("fvoucherentry"));
        record.setVoucherId(rs.getLong("fvoucherid"));
        record.setBillno(rs.getString("fnumber"));
        record.setCashFlowItem(rs.getLong("fcashflowitemid"));
        record.setAccounttable(rs.getLong("faccounttableid"));
        record.setAssgrp(rs.getLong("fassgrpid"));
        record.setCommonAssgrp(rs.getString("fcommonassgrp"));
        record.setConvertamt(rs.getBigDecimal("fconvertamt"));
        record.setConvertamtbal(rs.getBigDecimal("fconvertamtbal"));
        record.setConcurrency(rs.getLong("fconcurrencyid"));
        record.setCurrency(rs.getLong("fcurrencyid"));
        record.setAmt(rs.getBigDecimal("famt"));
        record.setAmtbal(rs.getBigDecimal("famtbal"));
        record.setPeriod(rs.getLong("fperiodid"));
        record.setOrg(rs.getLong("forgid"));
        record.setOporg(rs.getLong("foporgid"));
        record.setDc(rs.getString("fdc"));
        record.setBaldc(rs.getString("fbaldc"));
        record.setBookedate(rs.getDate("fbookeddate"));
        record.setEdescription(rs.getString("fedescription"));
        record.setReconscheme(rs.getLong("fschemeid"));
        java.sql.Date date = rs.getDate("fbizdate");
        record.setBizdate(date);
        record.setBizDateInt(BuildCrossRecordUtils.toLongByDate(date));
        record.setBooktype(rs.getLong("fbooktypeid"));
        return record;
    }

    @Override
    protected String insertCrossRecord() {
        return INSERT_CF_CROSSRECORD_SQL;
    }

    @Override
    protected String insertCrossRecordEntry() {
        return INSERT_CF_CROSSRECORD_ENTRY_SQL;
    }

    @Override
    protected String queryCrossRecordEntry() {
        return QUERY_CF_CROSSRECORD_ENTRY_SQL;
    }

    @Override
    protected String getCrossRecordEntity() {
        return "ict_check_cash_record";
    }

    @Override
    protected BigDecimal getRelRecordAmt(ResultSet rs) throws SQLException {
        BigDecimal balamt = rs.getBigDecimal("fconvertamtbal");
        if ("i".equals(rs.getString("fdc"))) {
            return balamt;
        }
        if ("o".equals(rs.getString("fdc"))) {
            return balamt.negate();
        }
        return BigDecimal.ZERO;
    }

    @Override
    public AuditRecordRow getAuditInfo(ResultSet rs, Long periodId) throws SQLException {
        long entryId = rs.getLong("fentryid");
        long relrecordid = rs.getLong("frelrecordid");
        BigDecimal amtverify = rs.getBigDecimal("famtverify");
        BigDecimal convertamtverify = rs.getBigDecimal("fconvertamtverify");
        String dc = rs.getString("fdc");
        AuditRecordRow dr = new AuditRecordRow();
        dr.setEntryId(entryId);
        dr.setRecordId(relrecordid);
        dr.setAmt(amtverify);
        dr.setAmtloc(amtverify);
        dr.setConvertamt(convertamtverify);
        dr.setDc(dc);
        dr.setPeriodId(periodId);
        return dr;
    }

    @Override
    protected String getCheckLogTab() {
        return "t_ict_cfpuchamt_log";
    }
}

