/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.opservice.manualrelverigy;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ict.business.intertrans.utils.ToleranceUtil;
import kd.fi.ict.business.opservice.manualrelverigy.AbstractManualReconciliationLogService;
import kd.fi.ict.business.opservice.manualrelverigy.ToleranceService;
import kd.fi.ict.business.opservice.manualrelverigy.converttomanual.ManualReconciliationConvertToManualReconciliation;
import kd.fi.ict.business.opservice.manualrelverigy.manualconvertto.ManualReconciliationConvertToRecord;
import kd.fi.ict.business.opservice.manualrelverigy.manualconvertto.ManualReconciliationConvertToRecordLog;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationEntityInfo;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationInfo;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.PuchLogFactory;

public class ManualReconciliationAcctService
extends AbstractManualReconciliationLogService {
    private static final String DEBITENTRYDC = "1";
    private static final String CREDITENTRYDC = "-1";
    protected Log LOGGER = LogFactory.getLog(ManualReconciliationAcctService.class);

    @Override
    public Map<String, Object> process(ManualReconciliationInfo manualReconciliationInfo) {
        List<DynamicObject> recordList;
        this.LOGGER.info("- ManualReconciliationInfo :{}", (Object)SerializationUtils.toJsonString((Object)manualReconciliationInfo));
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        resultMap.put("success", Boolean.TRUE);
        ManualReconciliationConvertToRecord convertToRecord = new ManualReconciliationConvertToRecord("ict_relacctrecord");
        try {
            recordList = convertToRecord.convert(manualReconciliationInfo);
        }
        catch (Exception e) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", e.getMessage());
            return resultMap;
        }
        BusinessDataWriter.update((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ict_relacctrecord"), (Object[])recordList.toArray(new DynamicObject[0]));
        ManualReconciliationConvertToRecordLog recordLog = new ManualReconciliationConvertToRecordLog("ict_check_record");
        DynamicObject relverifyObj = recordLog.convert(manualReconciliationInfo);
        OperationServiceHelper.executeOperate((String)"save", (String)"ict_check_record", (DynamicObject[])new DynamicObject[]{relverifyObj}, (OperateOption)OperateOption.create());
        IPuchAmtLog checkBalLog = PuchLogFactory.getPuchLog("ict_relacctrecord");
        checkBalLog.setAddCheckLog(new DynamicObject[]{relverifyObj}, OperationType.MANUALCHECK);
        return resultMap;
    }

    @Override
    public Map<String, Object> validate(ManualReconciliationConvertToManualReconciliation obj) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        resultMap.put("success", Boolean.TRUE);
        boolean singleFlag = true;
        if (null == obj.getBselList() || obj.getBselList().size() == 0) {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u672c\u65b9\u51ed\u8bc1\u3002", (String)"ManualReconciliationAcctService_4", (String)"fi-ict-business", (Object[])new Object[0]));
            return resultMap;
        }
        if (null == obj.getDselList() || obj.getDselList().size() == 0) {
            if (this.checkSingle(obj.getManualReconciliationInfo().getBentityInfo())) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("message", ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u5355\u8fb9\u52fe\u7a3d\u6761\u4ef6\u3002", (String)"ManualReconciliationAcctService_3", (String)"fi-ict-business", (Object[])new Object[0]));
                return resultMap;
            }
            singleFlag = false;
        }
        this.checkEntity(obj.getManualReconciliationInfo().getBentityInfo(), resultMap);
        if (!((Boolean)resultMap.get("success")).booleanValue()) {
            return resultMap;
        }
        this.checkEntity(obj.getManualReconciliationInfo().getDentityInfo(), resultMap);
        if (singleFlag) {
            boolean toleranceCheck;
            ManualReconciliationInfo manualReconciliationInfo = obj.getManualReconciliationInfo();
            boolean bl = toleranceCheck = ToleranceUtil.toleranceBentiry(manualReconciliationInfo) && ToleranceUtil.toleranceDentiry(manualReconciliationInfo);
            if (toleranceCheck) {
                if (this.checkTolerance(obj.getManualReconciliationInfo())) {
                    resultMap.put("success", Boolean.FALSE);
                    resultMap.put("message", ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u4e0d\u6ee1\u8db3\u52fe\u7a3d\u6761\u4ef6\u3002", (String)"ManualReconciliationConvertToManualReconciliation_4", (String)"fi-ict-business", (Object[])new Object[0]));
                    return resultMap;
                }
            } else if (ToleranceUtil.totalAcctAmt(manualReconciliationInfo)) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("message", ResManager.loadKDString((String)"\u52fe\u7a3d\u91d1\u989d\u4e0d\u6ee1\u8db3\u90e8\u5206\u52fe\u7a3d\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u52fe\u7a3d", (String)"ManualReconciliationCashService_1", (String)"fi-ict-business", (Object[])new Object[0]));
                return resultMap;
            }
        }
        return resultMap;
    }

    private void checkEntity(List<ManualReconciliationEntityInfo> entityInfos, Map<String, Object> resultMap) {
        for (ManualReconciliationEntityInfo entityInfo : entityInfos) {
            BigDecimal odc;
            if ("B".equals(entityInfo.getBillstatus())) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("message", ResManager.loadKDString((String)"\u63d0\u4ea4\u8f6c\u4e0b\u671f\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u52fe\u7a3d\u3002", (String)"ManualReconciliationConvertToManualReconciliation_8", (String)"fi-ict-business", (Object[])new Object[0]));
                return;
            }
            BigDecimal oriamount = entityInfo.getOriamount();
            BigDecimal aoriamount = entityInfo.getAoriamount();
            BigDecimal taoriamount = entityInfo.getTaoriamount();
            BigDecimal bigDecimal = odc = BigDecimal.ZERO.compareTo(oriamount) > 0 ? new BigDecimal(-1) : BigDecimal.ONE;
            if (BigDecimal.ZERO.compareTo(taoriamount) == 0) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("message", ResManager.loadKDString((String)"\u672c\u6b21\u52fe\u7a3d\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"ManualReconciliationConvertToManualReconciliation_2", (String)"fi-ict-business", (Object[])new Object[0]));
                return;
            }
            if (BigDecimal.ZERO.compareTo(taoriamount.multiply(odc)) > 0) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("message", ResManager.loadKDString((String)"\u672c\u6b21\u52fe\u7a3d\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ManualReconciliationConvertToManualReconciliation_5", (String)"fi-ict-business", (Object[])new Object[0]));
                return;
            }
            if (oriamount.multiply(odc).compareTo(aoriamount.add(taoriamount.multiply(odc))) >= 0) continue;
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u52fe\u7a3d\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u539f\u59cb\u91d1\u989d\uff0c\u671f\u671b\u6570\u636e\u5df2\u52fe\u7a3d\u3002", (String)"ManualReconciliationConvertToManualReconciliation_3", (String)"fi-ict-business", (Object[])new Object[0]));
            return;
        }
    }

    private boolean checkSingle(List<ManualReconciliationEntityInfo> bentityInfoList) {
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal debitTaoriAmt = BigDecimal.ZERO;
        BigDecimal debitTlocalcur = BigDecimal.ZERO;
        BigDecimal creditTaoriAmt = BigDecimal.ZERO;
        BigDecimal creditTlocalcur = BigDecimal.ZERO;
        for (ManualReconciliationEntityInfo info : bentityInfoList) {
            BigDecimal oriAmt = info.getTaoriamount();
            BigDecimal taoriAmt = info.getTaoriamount();
            BigDecimal tlocalcur = info.getTlocalcur();
            if (CREDITENTRYDC.equals(info.getEntrydc())) {
                oriAmt = oriAmt.multiply(new BigDecimal(CREDITENTRYDC));
                creditTaoriAmt = creditTaoriAmt.add(taoriAmt);
                creditTlocalcur = creditTlocalcur.add(tlocalcur);
            } else {
                debitTaoriAmt = debitTaoriAmt.add(oriAmt);
                debitTlocalcur = debitTlocalcur.add(tlocalcur);
            }
            totalAmt = totalAmt.add(oriAmt);
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        Map<String, List<ManualReconciliationEntityInfo>> dcListMap = bentityInfoList.stream().collect(Collectors.groupingBy(ManualReconciliationEntityInfo::getEntrydc));
        for (Map.Entry<String, List<ManualReconciliationEntityInfo>> entry : dcListMap.entrySet()) {
            boolean absMinAmt;
            boolean absMaxAmt;
            BigDecimal minTlocalcur;
            BigDecimal maxTlocalcuramount;
            BigDecimal minusTaoriamount;
            BigDecimal maxTaoriamount;
            ManualReconciliationEntityInfo minInfo;
            ManualReconciliationEntityInfo info;
            if (DEBITENTRYDC.equals(entry.getKey())) {
                info = entry.getValue().stream().max(Comparator.comparing(ManualReconciliationEntityInfo::getTaoriamount)).get();
                minInfo = entry.getValue().stream().min(Comparator.comparing(ManualReconciliationEntityInfo::getTaoriamount)).get();
                maxTaoriamount = info.getTaoriamount();
                minusTaoriamount = minInfo.getTaoriamount();
                maxTlocalcuramount = info.getTlocalcur();
                minTlocalcur = minInfo.getTlocalcur();
                if (maxTaoriamount.abs().compareTo(minusTaoriamount.abs()) > 0) {
                    boolean bl = absMaxAmt = maxTaoriamount.abs().compareTo(totalAmt.abs()) > 0;
                    if (absMaxAmt && maxTaoriamount.multiply(totalAmt).compareTo(BigDecimal.ZERO) > 0) {
                        info.setTaoriamount(maxTaoriamount.subtract(totalAmt));
                        info.setTlocalcur(maxTlocalcuramount.subtract(debitTlocalcur.subtract(creditTlocalcur)));
                        return false;
                    }
                } else {
                    boolean bl = absMinAmt = minusTaoriamount.abs().compareTo(totalAmt.abs()) > 0;
                    if (absMinAmt && minusTaoriamount.multiply(totalAmt).compareTo(BigDecimal.ZERO) > 0) {
                        minInfo.setTaoriamount(minusTaoriamount.subtract(totalAmt));
                        minInfo.setTlocalcur(minTlocalcur.subtract(debitTlocalcur.subtract(creditTlocalcur)));
                        return false;
                    }
                }
            }
            if (!CREDITENTRYDC.equals(entry.getKey())) continue;
            info = entry.getValue().stream().max(Comparator.comparing(ManualReconciliationEntityInfo::getTaoriamount)).get();
            minInfo = entry.getValue().stream().min(Comparator.comparing(ManualReconciliationEntityInfo::getTaoriamount)).get();
            maxTaoriamount = info.getTaoriamount();
            minusTaoriamount = minInfo.getTaoriamount();
            maxTlocalcuramount = info.getTlocalcur();
            minTlocalcur = minInfo.getTlocalcur();
            if (maxTaoriamount.abs().compareTo(minusTaoriamount.abs()) > 0) {
                absMaxAmt = maxTaoriamount.abs().compareTo(totalAmt.abs()) > 0;
                if (!absMaxAmt || maxTaoriamount.multiply(totalAmt.negate()).compareTo(BigDecimal.ZERO) <= 0) continue;
                info.setTaoriamount(maxTaoriamount.subtract(totalAmt.negate()));
                info.setTlocalcur(maxTlocalcuramount.subtract(creditTlocalcur.subtract(debitTlocalcur)));
                return false;
            }
            absMinAmt = minusTaoriamount.abs().compareTo(totalAmt.abs()) > 0;
            if (!absMinAmt || minusTaoriamount.multiply(totalAmt.negate()).compareTo(BigDecimal.ZERO) <= 0) continue;
            minInfo.setTaoriamount(minusTaoriamount.subtract(totalAmt.negate()));
            minInfo.setTlocalcur(minTlocalcur.subtract(creditTlocalcur.subtract(debitTlocalcur)));
            return false;
        }
        return true;
    }

    private boolean checkTolerance(ManualReconciliationInfo manualReconciliationInfo) {
        return new ToleranceService().calculateProcess(manualReconciliationInfo);
    }
}

