/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.opservice.manualrelverigy;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ict.business.intertrans.utils.ToleranceUtil;
import kd.fi.ict.business.opservice.manualrelverigy.AbstractManualReconciliationLogService;
import kd.fi.ict.business.opservice.manualrelverigy.ToleranceService;
import kd.fi.ict.business.opservice.manualrelverigy.converttomanual.ManualReconciliationConvertToManualReconciliation;
import kd.fi.ict.business.opservice.manualrelverigy.manualconvertto.ManualReconciliationConvertToRecord;
import kd.fi.ict.business.opservice.manualrelverigy.manualconvertto.ManualReconciliationConvertToRecordLog;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationEntityInfo;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationInfo;
import kd.fi.ict.enums.OperationType;
import kd.fi.ict.pullcheck.IPuchAmtLog;
import kd.fi.ict.pullcheck.PuchLogFactory;

public class ManualReconciliationCashService
extends AbstractManualReconciliationLogService {
    @Override
    public Map<String, Object> process(ManualReconciliationInfo manualReconciliationInfo) {
        List<DynamicObject> recordList;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        resultMap.put("success", true);
        ManualReconciliationConvertToRecord convertToRecord = new ManualReconciliationConvertToRecord("ict_relcfrecord");
        try {
            recordList = convertToRecord.convert(manualReconciliationInfo);
        }
        catch (Exception e) {
            resultMap.put("success", false);
            resultMap.put("message", e.getMessage());
            return resultMap;
        }
        BusinessDataWriter.update((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"ict_relcfrecord"), (Object[])recordList.toArray(new DynamicObject[0]));
        ManualReconciliationConvertToRecordLog recordLog = new ManualReconciliationConvertToRecordLog("ict_check_cash_record");
        DynamicObject relverifyObj = recordLog.convert(manualReconciliationInfo);
        OperationServiceHelper.executeOperate((String)"save", (String)"ict_check_cash_record", (DynamicObject[])new DynamicObject[]{relverifyObj}, (OperateOption)OperateOption.create());
        IPuchAmtLog checkBalLog = PuchLogFactory.getPuchLog("ict_relcfrecord");
        checkBalLog.setAddCheckLog(new DynamicObject[]{relverifyObj}, OperationType.MANUALCHECK);
        return resultMap;
    }

    @Override
    public Map<String, Object> validate(ManualReconciliationConvertToManualReconciliation obj) {
        Map<String, Object> resultMap = new HashMap<String, Object>(1);
        resultMap.put("success", true);
        if (null == obj.getBselList() || obj.getBselList().size() == 0) {
            resultMap.put("success", false);
            resultMap.put("message", ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u672c\u65b9\u51ed\u8bc1\u3002", (String)"ManualReconciliationCashService_4", (String)"fi-ict-business", (Object[])new Object[0]));
            return resultMap;
        }
        boolean singleFlag = true;
        if (null == obj.getDselList() || obj.getDselList().size() == 0) {
            if (this.checkSingle(obj.getManualReconciliationInfo().getBentityInfo())) {
                resultMap.put("success", false);
                resultMap.put("message", ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u5355\u8fb9\u52fe\u7a3d\u6761\u4ef6\u3002", (String)"ManualReconciliationCashService_3", (String)"fi-ict-business", (Object[])new Object[0]));
                return resultMap;
            }
            singleFlag = false;
        }
        if (!((Boolean)(resultMap = this.checkEntity(obj.getManualReconciliationInfo().getBentityInfo(), resultMap)).get("success")).booleanValue()) {
            return resultMap;
        }
        resultMap = this.checkEntity(obj.getManualReconciliationInfo().getDentityInfo(), resultMap);
        if (singleFlag) {
            ManualReconciliationInfo manualReconciliationInfo = obj.getManualReconciliationInfo();
            if (ToleranceUtil.toleranceBentiry(manualReconciliationInfo) && ToleranceUtil.toleranceDentiry(manualReconciliationInfo)) {
                if (this.checkTolerance(obj.getManualReconciliationInfo())) {
                    resultMap.put("success", false);
                    resultMap.put("message", ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u4e0d\u6ee1\u8db3\u52fe\u7a3d\u6761\u4ef6\u3002", (String)"ManualReconciliationConvertToManualReconciliation_4", (String)"fi-ict-business", (Object[])new Object[0]));
                    return resultMap;
                }
            } else if (ToleranceUtil.totalCashFlowAmt(manualReconciliationInfo)) {
                resultMap.put("success", false);
                resultMap.put("message", ResManager.loadKDString((String)"\u52fe\u7a3d\u91d1\u989d\u4e0d\u6ee1\u8db3\u90e8\u5206\u52fe\u7a3d\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u52fe\u7a3d", (String)"ManualReconciliationCashService_1", (String)"fi-ict-business", (Object[])new Object[0]));
                return resultMap;
            }
        }
        return resultMap;
    }

    private boolean checkTolerance(ManualReconciliationInfo manualReconciliationInfo) {
        return new ToleranceService().calculateCfProcess(manualReconciliationInfo);
    }

    private boolean checkSingle(List<ManualReconciliationEntityInfo> bentityInfoList) {
        HashSet<Long> accountSet = new HashSet<Long>();
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal locTotalAmt = BigDecimal.ZERO;
        for (ManualReconciliationEntityInfo info : bentityInfoList) {
            accountSet.add(info.getCfitem());
            BigDecimal taoriamount = info.getTaoriamount();
            totalAmt = totalAmt.add(taoriamount);
            BigDecimal tlocalcur = info.getTlocalcur();
            locTotalAmt = locTotalAmt.add(tlocalcur);
        }
        if (accountSet.size() == 1) {
            return this.allowCashSingleOpration(bentityInfoList, totalAmt, locTotalAmt);
        }
        return true;
    }

    private boolean allowCashSingleOpration(List<ManualReconciliationEntityInfo> bentityInfoList, BigDecimal totalAmt, BigDecimal locTotalAmt) {
        ManualReconciliationEntityInfo info = bentityInfoList.stream().max(Comparator.comparing(ManualReconciliationEntityInfo::getTaoriamount)).get();
        ManualReconciliationEntityInfo minInfo = bentityInfoList.stream().min(Comparator.comparing(ManualReconciliationEntityInfo::getTaoriamount)).get();
        BigDecimal taoriamount = info.getTaoriamount();
        BigDecimal minTaoriamount = minInfo.getTaoriamount();
        BigDecimal tlocalcur = info.getTlocalcur();
        BigDecimal minTlocalcur = minInfo.getTlocalcur();
        if (taoriamount.abs().compareTo(totalAmt.abs()) > 0 || minTaoriamount.abs().compareTo(totalAmt.abs()) > 0) {
            if (totalAmt.compareTo(BigDecimal.ZERO) > 0) {
                info.setTaoriamount(taoriamount.subtract(totalAmt));
                info.setTlocalcur(tlocalcur.subtract(locTotalAmt));
                return false;
            }
            minInfo.setTaoriamount(minTaoriamount.subtract(totalAmt));
            minInfo.setTlocalcur(minTlocalcur.subtract(locTotalAmt));
            return false;
        }
        return true;
    }

    private Map<String, Object> checkEntity(List<ManualReconciliationEntityInfo> entityInfos, Map<String, Object> resultMap) {
        for (ManualReconciliationEntityInfo entityInfo : entityInfos) {
            BigDecimal odc;
            if ("B".equals(entityInfo.getBillstatus())) {
                resultMap.put("success", false);
                resultMap.put("message", ResManager.loadKDString((String)"\u63d0\u4ea4\u8f6c\u4e0b\u671f\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u52fe\u7a3d\u3002", (String)"ManualReconciliationCashService_0", (String)"fi-ict-business", (Object[])new Object[0]));
                return resultMap;
            }
            BigDecimal oriamount = entityInfo.getOriamount();
            BigDecimal aoriamount = entityInfo.getAoriamount();
            BigDecimal taoriamount = entityInfo.getTaoriamount();
            BigDecimal bigDecimal = odc = BigDecimal.ZERO.compareTo(oriamount) > 0 ? new BigDecimal(-1) : BigDecimal.ONE;
            if (BigDecimal.ZERO.compareTo(taoriamount) == 0) {
                resultMap.put("success", false);
                resultMap.put("message", ResManager.loadKDString((String)"\u672c\u6b21\u52fe\u7a3d\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"ManualReconciliationConvertToManualReconciliation_2", (String)"fi-ict-business", (Object[])new Object[0]));
                return resultMap;
            }
            if (BigDecimal.ZERO.compareTo(taoriamount.multiply(odc)) > 0) {
                resultMap.put("success", false);
                resultMap.put("message", ResManager.loadKDString((String)"\u672c\u6b21\u52fe\u7a3d\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"ManualReconciliationConvertToManualReconciliation_5", (String)"fi-ict-business", (Object[])new Object[0]));
                return resultMap;
            }
            if (oriamount.multiply(odc).compareTo(aoriamount.add(taoriamount.multiply(odc))) >= 0) continue;
            resultMap.put("success", false);
            resultMap.put("message", ResManager.loadKDString((String)"\u52fe\u7a3d\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u539f\u59cb\u91d1\u989d\uff0c\u671f\u671b\u6570\u636e\u5df2\u52fe\u7a3d\u3002", (String)"ManualReconciliationConvertToManualReconciliation_3", (String)"fi-ict-business", (Object[])new Object[0]));
            return resultMap;
        }
        return resultMap;
    }
}

