/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.opservice.manualrelverigy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationEntityInfo;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationInfo;
import kd.fi.ict.constant.ReconToleranceField;
import kd.fi.ict.util.AccountServiceHelper;

public class ToleranceService {
    List<BigDecimal> valResult = new ArrayList<BigDecimal>();
    List<BigDecimal> percentageResult = new ArrayList<BigDecimal>();
    BigDecimal b_totalAmt = BigDecimal.ZERO;
    BigDecimal d_totalAmt = BigDecimal.ZERO;
    private boolean toleranceTag = false;
    private Long orgId;
    private Long oppOrgId;
    private Long currencyId;
    private static final Log logger = LogFactory.getLog(ToleranceService.class);

    public boolean calculateProcess(ManualReconciliationInfo manualReconciliationInfo) {
        BigDecimal dc;
        this.orgId = manualReconciliationInfo.getOrg();
        this.oppOrgId = manualReconciliationInfo.getOppoorg();
        this.currencyId = ((ManualReconciliationEntityInfo)manualReconciliationInfo.getBentityInfo().get(0)).getCurrency();
        for (ManualReconciliationEntityInfo b_info : manualReconciliationInfo.getBentityInfo()) {
            dc = new BigDecimal(b_info.getEntrydc());
            this.b_totalAmt = this.b_totalAmt.add(b_info.getTaoriamount().multiply(dc));
        }
        for (ManualReconciliationEntityInfo d_info : manualReconciliationInfo.getDentityInfo()) {
            dc = new BigDecimal(Integer.parseInt(d_info.getEntrydc()));
            this.d_totalAmt = this.d_totalAmt.add(d_info.getTaoriamount().multiply(dc));
        }
        QFilter currFilter = new QFilter("currency", "=", (Object)this.currencyId);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ict_recontolerance", (Long)this.orgId);
        QFilter oppOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ict_recontolerance", (Long)this.oppOrgId);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        Collection thisRuleList = BusinessDataServiceHelper.loadFromCache((String)"ict_recontolerance", (String)"name,accounttable.id,account,currency.id,tolerancetype,tolerancevalue", (QFilter[])new QFilter[]{currFilter, orgFilter, enable}).values();
        for (ManualReconciliationEntityInfo b_info : manualReconciliationInfo.getBentityInfo()) {
            boolean tag = false;
            for (DynamicObject dy : thisRuleList) {
                if (!this.matchTolerance(this.orgId, b_info, dy)) continue;
                tag = true;
            }
            if (tag) continue;
            this.toleranceTag = true;
        }
        Collection oppRuleList = BusinessDataServiceHelper.loadFromCache((String)"ict_recontolerance", (String)"name,accounttable.id,account,currency.id,tolerancetype,tolerancevalue", (QFilter[])new QFilter[]{currFilter, oppOrgFilter, enable}).values();
        for (ManualReconciliationEntityInfo d_info : manualReconciliationInfo.getDentityInfo()) {
            boolean tag = false;
            for (DynamicObject dy : oppRuleList) {
                if (!this.matchTolerance(this.oppOrgId, d_info, dy)) continue;
                tag = true;
            }
            if (tag) continue;
            this.toleranceTag = true;
        }
        logger.info("-ToleranceService toleranceTag\uff1a{} b_totalAmt:{} d_totalAmt:{}", new Object[]{this.toleranceTag, this.b_totalAmt, this.d_totalAmt});
        return this.calMinValue();
    }

    private boolean matchTolerance(Long org, ManualReconciliationEntityInfo info, DynamicObject dy) {
        DynamicObjectCollection account = dy.getDynamicObjectCollection("account");
        ArrayList<Long> accountMasterId = new ArrayList<Long>();
        for (DynamicObject dynamicObject : account) {
            accountMasterId.add(dynamicObject.getDynamicObject("fbasedataid").getLong("masterid"));
        }
        Long accountTabId = dy.getLong(ReconToleranceField.id_((String)"accounttable"));
        List detailMasterList = AccountServiceHelper.getAllLeafAccountMasterIds((long)org, (long)accountTabId, accountMasterId);
        logger.info("\u65b9\u6848:{}\u4e0a\u6240\u6709\u660e\u7ec6\u79d1\u76ee\u7684masterId:{}", (Object)dy.getString("name"), (Object)SerializationUtils.toJsonString((Object)detailMasterList));
        String type = dy.getString("tolerancetype");
        BigDecimal value = dy.getBigDecimal("tolerancevalue");
        if (detailMasterList.contains(info.getAccountMasterId())) {
            if ("1".equals(type)) {
                this.valResult.add(value);
            } else if ("2".equals(type)) {
                this.percentageResult.add(value);
            }
            return true;
        }
        return false;
    }

    public boolean calMinValue() {
        BigDecimal diff = this.b_totalAmt.add(this.d_totalAmt).abs();
        if (this.toleranceTag) {
            return diff.compareTo(BigDecimal.ZERO) != 0;
        }
        BigDecimal minPercent = this.percentageResult.size() == 0 ? BigDecimal.ZERO : Collections.min(this.percentageResult);
        BigDecimal minVal = this.valResult.size() == 0 ? BigDecimal.ZERO : Collections.min(this.valResult);
        BigDecimal minValAmt = this.b_totalAmt.abs().min(this.d_totalAmt.abs());
        BigDecimal minDiff = minPercent.compareTo(BigDecimal.ZERO) != 0 && minVal.compareTo(BigDecimal.ZERO) != 0 ? minValAmt.multiply(minPercent).min(minVal) : (minPercent.compareTo(BigDecimal.ZERO) > 0 ? minValAmt.multiply(minPercent) : minVal);
        logger.info("\u672c\u6b21\u53d6\u5f97\u5bb9\u5dee\u6700\u5c0f\u503c:{}", (Object)minDiff);
        return diff.compareTo(minDiff.abs()) > 0;
    }

    public boolean calculateCfProcess(ManualReconciliationInfo manualReconciliationInfo) {
        this.orgId = manualReconciliationInfo.getOrg();
        this.oppOrgId = manualReconciliationInfo.getOppoorg();
        this.currencyId = ((ManualReconciliationEntityInfo)manualReconciliationInfo.getBentityInfo().get(0)).getCurrency();
        for (ManualReconciliationEntityInfo b_info : manualReconciliationInfo.getBentityInfo()) {
            if ("o".equals(b_info.getEntryCashDc())) {
                this.b_totalAmt = this.b_totalAmt.add(b_info.getTaoriamount().multiply(new BigDecimal("-1")));
                continue;
            }
            this.b_totalAmt = this.b_totalAmt.add(b_info.getTaoriamount());
        }
        for (ManualReconciliationEntityInfo d_info : manualReconciliationInfo.getDentityInfo()) {
            if ("o".equals(d_info.getEntryCashDc())) {
                this.d_totalAmt = this.d_totalAmt.add(d_info.getTaoriamount().multiply(new BigDecimal("-1")));
                continue;
            }
            this.d_totalAmt = this.d_totalAmt.add(d_info.getTaoriamount());
        }
        QFilter currFilter = new QFilter("currency", "=", (Object)this.currencyId);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ict_cashflowtolerance", (Long)this.orgId);
        QFilter oppOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ict_cashflowtolerance", (Long)this.oppOrgId);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        Collection thisRuleList = BusinessDataServiceHelper.loadFromCache((String)"ict_cashflowtolerance", (String)"name,currency.id,cashflowitem,tolerancetype,tolerancevalue", (QFilter[])new QFilter[]{currFilter, orgFilter, enable}).values();
        for (ManualReconciliationEntityInfo b_info : manualReconciliationInfo.getBentityInfo()) {
            boolean tag = false;
            for (DynamicObject dy : thisRuleList) {
                if (!this.matchCfTolerance(b_info, dy)) continue;
                tag = true;
            }
            if (tag) continue;
            this.toleranceTag = true;
        }
        Collection oppRuleList = BusinessDataServiceHelper.loadFromCache((String)"ict_cashflowtolerance", (String)"name,currency.id,cashflowitem,tolerancetype,tolerancevalue", (QFilter[])new QFilter[]{currFilter, oppOrgFilter, enable}).values();
        for (ManualReconciliationEntityInfo d_info : manualReconciliationInfo.getDentityInfo()) {
            boolean tag = false;
            for (DynamicObject dy : oppRuleList) {
                if (!this.matchCfTolerance(d_info, dy)) continue;
                tag = true;
            }
            if (tag) continue;
            this.toleranceTag = true;
        }
        logger.info("-ToleranceService Cashflow toleranceTag\uff1a{} b_totalAmt:{} d_totalAmt:{}", new Object[]{this.toleranceTag, this.b_totalAmt, this.d_totalAmt});
        return this.calMinValue();
    }

    private boolean matchCfTolerance(ManualReconciliationEntityInfo info, DynamicObject dy) {
        DynamicObjectCollection cashFlowitem = dy.getDynamicObjectCollection("cashflowitem");
        HashSet<Long> cftMasterIds = new HashSet<Long>(cashFlowitem.size());
        for (DynamicObject dynamicObject : cashFlowitem) {
            cftMasterIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("masterid"));
        }
        Set<Long> detailMasterSet = ToleranceService.getDateIdByMasterId(cftMasterIds, "gl_cashflowitem");
        logger.info("\u65b9\u6848:{}\u4e0a\u6240\u6709\u660e\u7ec6\u73b0\u91d1\u6d41\u91cf\u7684masterId:{}", (Object)dy.getString("name"), (Object)SerializationUtils.toJsonString(detailMasterSet));
        String type = dy.getString("tolerancetype");
        BigDecimal value = dy.getBigDecimal("tolerancevalue");
        if (detailMasterSet.contains(info.getCfitemMasterId())) {
            if ("1".equals(type)) {
                this.valResult.add(value);
            } else if ("2".equals(type)) {
                this.percentageResult.add(value);
            }
            return true;
        }
        return false;
    }

    public static Set<Long> getDateIdByMasterId(Set<Long> cftMasterIds, String formKey) {
        QFilter filter = new QFilter("masterid", "in", cftMasterIds);
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet("getDateIdByMasterId", formKey, "id,parent", filter.toArray());
        HashSet<Long> ids = new HashSet<Long>(cftMasterIds.size());
        while (ds.hasNext()) {
            Row next = ds.next();
            ids.add(next.getLong("id"));
        }
        return ids;
    }
}

