/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.opservice.manualrelverigy.manualconvertto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationEntityInfo;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationInfo;

public class ManualReconciliationConvertToRecord {
    protected Log LOGGER = LogFactory.getLog(ManualReconciliationConvertToRecord.class);
    private String entityName;

    public ManualReconciliationConvertToRecord(String entityName) {
        this.entityName = entityName;
    }

    public List<DynamicObject> convert(ManualReconciliationInfo manualReconciliationInfo) throws Exception {
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(10);
        recordList.addAll(this.buildRecordEntry(manualReconciliationInfo, manualReconciliationInfo.getBentityInfo()));
        recordList.addAll(this.buildRecordEntry(manualReconciliationInfo, manualReconciliationInfo.getDentityInfo()));
        return recordList;
    }

    private ArrayList<DynamicObject> buildRecordEntry(ManualReconciliationInfo manualInfo, List<ManualReconciliationEntityInfo> entityInfos) throws Exception {
        ArrayList<DynamicObject> relacctrecordObjs = new ArrayList<DynamicObject>(entityInfos.size());
        for (ManualReconciliationEntityInfo entryObj : entityInfos) {
            DynamicObject relacctrecordObj = BusinessDataServiceHelper.loadSingle((Object)entryObj.getRelacctrecordid(), (String)this.entityName);
            relacctrecordObj.set("status", (Object)this.checkStatus(entryObj, relacctrecordObj.getString("status")));
            relacctrecordObj.set("lastupdatetime", (Object)new Date());
            if (this.entityName.equals("ict_relacctrecord")) {
                relacctrecordObj.set("amtbal", (Object)relacctrecordObj.getBigDecimal("amtbal").subtract(entryObj.getTaoriamount()));
                relacctrecordObj.set("amtballoc", (Object)relacctrecordObj.getBigDecimal("amtballoc").subtract(entryObj.getTlocalcur()));
                if (relacctrecordObj.getBigDecimal("amtbal").abs().compareTo(relacctrecordObj.getBigDecimal("amt").abs()) > 0) {
                    this.LOGGER.info("ict_relacctrecord\u5185\u7801\uff1a{},\u672a\u52fe\u7a3d\u91d1\u989d\uff1a{},\u539f\u5e01\u91d1\u989d\uff1a{},\u672c\u6b21\u52fe\u7a3d\u91d1\u989d\uff1a{}", new Object[]{relacctrecordObj.get("id"), relacctrecordObj.getBigDecimal("amtbal"), relacctrecordObj.getBigDecimal("amt"), entryObj.getTlocalcur()});
                    throw new KDBizException(ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672a\u52fe\u7a3d\u91d1\u989d\u3002", (String)"CancelCheckOpService_3", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                }
                if (relacctrecordObj.getBigDecimal("amtbal").multiply(relacctrecordObj.getBigDecimal("amt")).compareTo(BigDecimal.ZERO) < 0) {
                    this.LOGGER.info("ict_relacctrecord\u5185\u7801\uff1a{},\u672a\u52fe\u7a3d\u91d1\u989d\uff1a{},\u539f\u5e01\u91d1\u989d\uff1a{},\u672c\u6b21\u52fe\u7a3d\u91d1\u989d\uff1a{}", new Object[]{relacctrecordObj.get("id"), relacctrecordObj.getBigDecimal("amtbal"), relacctrecordObj.getBigDecimal("amt"), entryObj.getTlocalcur()});
                    throw new KDBizException(ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d\u4e0e\u672a\u52fe\u7a3d\u91d1\u989d\u5fc5\u987b\u6b63\u8d1f\u76f8\u540c\u3002", (String)"CancelCheckOpService_4", (String)"fi-ict-opplugin", (Object[])new Object[0]));
                }
            }
            if (this.entityName.equals("ict_relcfrecord")) {
                relacctrecordObj.set("amtbal", (Object)relacctrecordObj.getBigDecimal("amtbal").subtract(entryObj.getTlocalcur()));
                relacctrecordObj.set("convertamt", (Object)relacctrecordObj.getBigDecimal("convertamt"));
                relacctrecordObj.set("convertamtbal", (Object)relacctrecordObj.getBigDecimal("convertamtbal").subtract(entryObj.getTaoriamount()));
            }
            relacctrecordObjs.add(relacctrecordObj);
        }
        return relacctrecordObjs;
    }

    private boolean checkRecordIsUpdate(DynamicObject recordObj, ManualReconciliationInfo manualInfo) {
        Long manualTime;
        Long recordTime = recordObj.getDate("lastupdatetime").getTime();
        return recordTime.compareTo(manualTime = Long.valueOf(Long.parseLong(manualInfo.getCurrentTime()))) > 0;
    }

    private String checkStatus(ManualReconciliationEntityInfo entryObj, String oldStatus) {
        BigDecimal taoriamount;
        BigDecimal bigDecimal = taoriamount = this.entityName.equals("ict_relacctrecord") ? entryObj.getTaoriamount() : entryObj.getTlocalcur();
        if (BigDecimal.ZERO.compareTo(taoriamount) == 0) {
            return oldStatus;
        }
        String status = "2";
        BigDecimal oriamount = this.entityName.equals("ict_relacctrecord") ? entryObj.getOriamount() : entryObj.getLocalcur();
        BigDecimal aoriamount = this.entityName.equals("ict_relacctrecord") ? entryObj.getAoriamount() : entryObj.getAlocalcur();
        int compare = oriamount.compareTo(taoriamount.add(aoriamount));
        this.LOGGER.info("-\u66f4\u65b0\u52fe\u7a3d\u72b6\u6001 \u672c\u6b21\u52fe\u7a3d\u91d1\u989d\uff1a{} \u51ed\u8bc1\u539f\u59cb\u91d1\u989d\uff1a{} \u5df2\u52fe\u7a3d\u91d1\u989d:{} compare:{}", new Object[]{taoriamount, oriamount, aoriamount, compare});
        if (compare != 0) {
            status = "1";
        }
        if (compare == 0) {
            status = "2";
        }
        return status;
    }
}

