/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.opservice.manualrelverigy.manualconvertto;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ict.common.GenBillNoHelper;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationEntityInfo;
import kd.fi.ict.common.manualrelverigy.ManualReconciliationInfo;

public class ManualReconciliationConvertToRecordLog {
    private String entityName;

    public ManualReconciliationConvertToRecordLog(String entityName) {
        this.entityName = entityName;
    }

    public DynamicObject convert(ManualReconciliationInfo manualReconciliationInfo) {
        DynamicObject relverifyObj = BusinessDataServiceHelper.newDynamicObject((String)this.entityName);
        relverifyObj.set("billno", (Object)GenBillNoHelper.genCrossNumber((Long)manualReconciliationInfo.getOrg(), (String)GenBillNoHelper.toFormatDate(), (String)"0", (String)"1"));
        relverifyObj.set("period", (Object)manualReconciliationInfo.getPeriod());
        relverifyObj.set("checktype", (Object)"2");
        relverifyObj.set("verifyscheme", (Object)manualReconciliationInfo.getVerifyscheme());
        relverifyObj.set("curorg", (Object)manualReconciliationInfo.getOrg());
        relverifyObj.set("oporg", (Object)manualReconciliationInfo.getOppoorg());
        relverifyObj.set("remark", (Object)manualReconciliationInfo.getRemark());
        relverifyObj.set("createtime", (Object)new Date());
        this.buildLogEntry(relverifyObj, manualReconciliationInfo.getBentityInfo(), manualReconciliationInfo.getOrg(), manualReconciliationInfo.getOppoorg());
        this.buildLogEntry(relverifyObj, manualReconciliationInfo.getDentityInfo(), manualReconciliationInfo.getOppoorg(), manualReconciliationInfo.getOrg());
        String relerifyType = "2";
        if (StringUtils.isNotEmpty((String)manualReconciliationInfo.getRemark())) {
            relerifyType = "3";
        } else {
            DynamicObjectCollection entries = relverifyObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                if (entry.getBigDecimal("amt").compareTo(entry.getBigDecimal("amtverify")) == 0) continue;
                relerifyType = "4";
                break;
            }
        }
        relverifyObj.set("checkstatus", (Object)relerifyType);
        return relverifyObj;
    }

    public void buildLogEntry(DynamicObject relverifyObj, List<ManualReconciliationEntityInfo> entityInfos, Long org, Long oppoorg) {
        DynamicObjectCollection entries = relverifyObj.getDynamicObjectCollection("entryentity");
        DynamicObjectType entriesDynamicObjectType = entries.getDynamicObjectType();
        for (ManualReconciliationEntityInfo entryObj : entityInfos) {
            DynamicObject entry = new DynamicObject(entriesDynamicObjectType);
            entry.set("relrecordid", (Object)entryObj.getRelacctrecordid());
            entry.set("voucherentry", (Object)entryObj.getVoucherentry());
            entry.set("voucherid", (Object)entryObj.getVoucherid());
            if (this.entityName.equals("ict_check_record")) {
                entry.set("currency", (Object)entryObj.getCurrency());
                entry.set("dc", (Object)entryObj.getEntrydc());
                entry.set("loccur", (Object)entryObj.getCurrencyloc());
                entry.set("account", (Object)entryObj.getAccount());
                entry.set("amtloc", (Object)entryObj.getLocalcur());
                entry.set("amtverifyloc", (Object)entryObj.getTlocalcur());
                entry.set("amtballoc", (Object)entryObj.getLocalcur().subtract(entryObj.getTlocalcur()).subtract(entryObj.getAlocalcur()));
                entry.set("amt", (Object)entryObj.getOriamount());
                entry.set("amtverify", (Object)entryObj.getTaoriamount());
                entry.set("amtbal", (Object)entryObj.getOriamount().subtract(entryObj.getTaoriamount()).subtract(entryObj.getAoriamount()));
            } else {
                entry.set("dc", (Object)entryObj.getEntryCashDc());
                entry.set("cashflowitem", (Object)entryObj.getCfitem());
                entry.set("currency", (Object)entryObj.getCurrencyloc());
                entry.set("concurrency", (Object)entryObj.getCurrency());
                entry.set("convertamt", (Object)entryObj.getOriamount());
                entry.set("convertamtverify", (Object)entryObj.getTaoriamount());
                entry.set("convertamtbal", (Object)entryObj.getOriamount().subtract(entryObj.getTaoriamount()).subtract(entryObj.getAoriamount()));
                entry.set("amt", (Object)entryObj.getLocalcur());
                entry.set("amtverify", (Object)entryObj.getTlocalcur());
                entry.set("amtbal", (Object)entryObj.getLocalcur().subtract(entryObj.getTlocalcur()).subtract(entryObj.getAlocalcur()));
            }
            entry.set("assgrp", (Object)entryObj.getAssGrp());
            entry.set("desc", (Object)entryObj.getVchdesc());
            entry.set("voucherno", (Object)entryObj.getBillno());
            entry.set("bookeddate", (Object)entryObj.getVchdate());
            entry.set("org", (Object)org);
            entry.set("opporg", (Object)oppoorg);
            entries.add((Object)entry);
        }
    }
}

