/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.opservice.manualrelverigy.querydata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.business.opservice.manualrelverigy.querydata.AbstractQueryVch;
import kd.fi.ict.entity.RecordManualVo;

public class AccountQueryVch
extends AbstractQueryVch {
    private static final Log logger = LogFactory.getLog(AccountQueryVch.class);

    private String getRelAcctrecordSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id").append(",");
        sb.append("edescription").append(",");
        sb.append("vouchertype").append(",");
        sb.append("bizdate").append(",");
        sb.append("bookeddate").append(",");
        sb.append("billno").append(",");
        sb.append("voucherid").append(",");
        sb.append("voucherentry").append(",");
        sb.append("vchcreator").append(",");
        sb.append("assgrp").append(",");
        sb.append("period").append(",");
        sb.append("org").append(",");
        sb.append("booktype").append(",");
        sb.append("accounttable").append(",");
        sb.append("oporg").append(",");
        sb.append("status").append(",");
        sb.append("createtime").append(",");
        sb.append("lastupdatetime").append(",");
        sb.append("dc").append(",");
        sb.append("baldc").append(",");
        sb.append("commonassgrp").append(",");
        sb.append("currency").append(",");
        sb.append("account").append(",");
        sb.append("account.masterid").append(",");
        sb.append("amtbal").append(",");
        sb.append("amtballoc").append(",");
        sb.append("amt").append(",");
        sb.append("amtloc").append(",");
        sb.append("currencyloc").append(",");
        sb.append("isnextperiod").append(",");
        sb.append("billstatus").append(",");
        sb.append("sourcesys").append(",");
        sb.append("localrate").append(",");
        sb.append("remark");
        return sb.toString();
    }

    @Override
    public List<Long> getRelRecordIds() {
        ArrayList<Long> vchIds = new ArrayList<Long>(16);
        List<QFilter> qFilters = this.getQFilters();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_relacctrecord", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"voucherid desc");){
            while (ds.hasNext()) {
                Row next = ds.next();
                vchIds.add(next.getLong("id"));
            }
        }
        return vchIds;
    }

    @Override
    public List<Map<String, Object>> compile(List<Long> relRecordIds) {
        List<Map<String, Object>> tableValueList;
        QFilter qfIds = new QFilter("id", "in", relRecordIds);
        logger.info("\u5f00\u59cb\u67e5\u8be2ICT_RELACCTRECORD\u8054\u67e5GL_VOUCHER, orgId:{}", (Object)this.autoParam.getOwnorgId());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_relacctrecord", (String)this.getRelAcctrecordSelectProperties(), (QFilter[])qfIds.toArray(), (String)"voucherid desc");){
            tableValueList = this.convertToTableValueList(ds);
        }
        logger.info("\u67e5\u8be2ICT_RELACCTRECORD\u8054\u67e5GL_VOUCHER\u5b8c\u6bd5 , orgId:{}", (Object)this.autoParam.getOwnorgId());
        return tableValueList;
    }

    @Override
    public List<Map<String, Object>> compileSelectRows(List<RecordManualVo> recordList) {
        List<Map<String, Object>> tableValueList;
        logger.info("\u5f00\u59cb\u67e5\u8be2ICT_RELACCTRECORD\u8868, recordList:{}", (Object)SerializationUtils.toJsonString(recordList));
        List relRecordIds = recordList.stream().map(RecordManualVo::getRecordId).collect(Collectors.toList());
        QFilter qfIds = new QFilter("id", "in", relRecordIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_relacctrecord", (String)this.getRelAcctrecordSelectProperties(), (QFilter[])qfIds.toArray(), (String)"voucherid desc");){
            tableValueList = this.manualSaveToTableValueList(ds, recordList);
        }
        logger.info("\u5b8c\u6210\u67e5\u8be2ICT_RELACCTRECORD\u8868, recordList:{}", (Object)SerializationUtils.toJsonString(recordList));
        return tableValueList;
    }

    private List<Map<String, Object>> manualSaveToTableValueList(DataSet ds, List<RecordManualVo> recordList) {
        ArrayList<Map<String, Object>> tableValueList = new ArrayList<Map<String, Object>>(10);
        for (Row row : ds) {
            Map<String, Object> tableValueMap = this.tableValueMethod(row);
            for (RecordManualVo recordManualVo : recordList) {
                if (!recordManualVo.getRecordId().equals(row.getLong("id"))) continue;
                tableValueMap.put("taoriamount", recordManualVo.getTaoriamount());
                tableValueMap.put("tlocalcur", recordManualVo.getTlocalcur());
            }
            tableValueList.add(tableValueMap);
        }
        return tableValueList;
    }

    private Map<String, Object> tableValueMethod(Row row) {
        HashMap<String, Object> tableValueMap = new HashMap<String, Object>(18);
        tableValueMap.put("sourcesys", row.getString("sourcesys"));
        tableValueMap.put("billno", row.getString("billno"));
        tableValueMap.put("bizdate", row.getDate("bizdate"));
        tableValueMap.put("vchdate", row.getDate("bookeddate"));
        tableValueMap.put("vchtype", row.getLong("vouchertype"));
        tableValueMap.put("vchdesc", row.getString("edescription"));
        tableValueMap.put("vchcreator", row.getString("vchcreator"));
        tableValueMap.put("relacctrecordid", row.getLong("id"));
        tableValueMap.put("voucherid", row.getLong("voucherid"));
        tableValueMap.put("voucherentry", row.getLong("voucherentry"));
        tableValueMap.put("vchperiod", row.getLong("period"));
        tableValueMap.put("assgrp", row.getLong("assgrp"));
        tableValueMap.put("account", row.getLong("account"));
        tableValueMap.put("entrydc", row.getString("dc"));
        tableValueMap.put("baldc", row.getString("baldc"));
        tableValueMap.put("currency", row.getLong("currency"));
        tableValueMap.put("currencyloc", row.getLong("currencyloc"));
        tableValueMap.put("isnextperiod", row.getBoolean("isnextperiod"));
        tableValueMap.put("localrate", row.getBigDecimal("localrate"));
        tableValueMap.put("billstatus", row.getString("billstatus"));
        tableValueMap.put("masterid", row.getLong("account.masterid"));
        BigDecimal amt = row.getBigDecimal("amt");
        BigDecimal amtloc = row.getBigDecimal("amtloc");
        BigDecimal amtbal = row.getBigDecimal("amtbal");
        BigDecimal amtballoc = row.getBigDecimal("amtballoc");
        tableValueMap.put("oriamount", amt);
        tableValueMap.put("localcur", amtloc);
        tableValueMap.put("aoriamount", amt.subtract(amtbal));
        tableValueMap.put("alocalcur", amtloc.subtract(amtballoc));
        tableValueMap.put("noriamount", amtbal);
        tableValueMap.put("nlocalcur", amtballoc);
        tableValueMap.put("remark", row.getString("remark"));
        return tableValueMap;
    }

    private List<QFilter> getQFilters() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(new QFilter("org", "=", (Object)this.autoParam.getOwnorgId()));
        qFilters.add(new QFilter("oporg", "=", (Object)this.autoParam.getOppoorgId()));
        qFilters.add(new QFilter("booktype", "=", (Object)this.autoParam.getBooktypeId()));
        qFilters.add(new QFilter("currency", "=", (Object)this.autoParam.getCurrencyId()));
        qFilters.add(new QFilter("period", "=", (Object)this.autoParam.getPeriodId()));
        qFilters.add(new QFilter("reconscheme", "=", (Object)this.autoParam.getSchemeId()));
        qFilters.add(new QFilter("status", "in", (Object)new String[]{"0", "1"}));
        qFilters.add(new QFilter("billstatus", "in", (Object)new String[]{"A", "B"}));
        return qFilters;
    }

    private List<Map<String, Object>> convertToTableValueList(DataSet dataSet) {
        ArrayList<Map<String, Object>> tableValueList = new ArrayList<Map<String, Object>>(10);
        for (Row row : dataSet) {
            Map<String, Object> tableValueMap = this.tableValueMethod(row);
            tableValueMap.put("taoriamount", BigDecimal.ZERO);
            tableValueMap.put("tlocalcur", BigDecimal.ZERO);
            tableValueList.add(tableValueMap);
        }
        return tableValueList;
    }
}

