/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.statistics;

import java.util.Date;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ict.business.statistics.StatisticsCacheData;
import kd.fi.ict.business.statistics.StatisticsCalculator;
import kd.fi.ict.business.statistics.VerifyStatisticsParam;
import kd.fi.ict.cache.CacheHelper;
import kd.fi.ict.cache.CacheModule;
import kd.fi.ict.cache.DistributeCache;

public class StatisticsCache {
    private static final long TIME_OUT = 86400000L;
    private static final StatisticsCalculator CALCULATOR = new StatisticsCalculator();
    private static final DistributeCache CACHE = CacheHelper.getDistributeCache((CacheModule)CacheModule.VERIFY_STATISTICS);

    public static StatisticsCacheData getStatisticsCacheData(VerifyStatisticsParam param) {
        String cacheKey = StatisticsCache.getCacheKey(param);
        String cacheData = CACHE.get(cacheKey);
        if (StringUtils.isBlank((CharSequence)cacheData)) {
            return StatisticsCache.updateStatisticsCacheData(param);
        }
        StatisticsCacheData statisticsCacheData = (StatisticsCacheData)SerializationUtils.fromJsonString((String)cacheData, StatisticsCacheData.class);
        Date cacheDate = statisticsCacheData.getCacheDate();
        if (System.currentTimeMillis() - cacheDate.getTime() > 86400000L) {
            return StatisticsCache.updateStatisticsCacheData(param);
        }
        return (StatisticsCacheData)SerializationUtils.fromJsonString((String)cacheData, StatisticsCacheData.class);
    }

    public static StatisticsCacheData updateStatisticsCacheData(VerifyStatisticsParam param) {
        StatisticsCacheData newStatisticsCacheData = new StatisticsCacheData();
        newStatisticsCacheData.setCacheDate(new Date());
        newStatisticsCacheData.setVerifyStatistics(CALCULATOR.calculate(param));
        CACHE.put(StatisticsCache.getCacheKey(param), SerializationUtils.toJsonString((Object)newStatisticsCacheData));
        return newStatisticsCacheData;
    }

    public static void remove(VerifyStatisticsParam param) {
        CACHE.remove(StatisticsCache.getCacheKey(param));
    }

    private static String getCacheKey(VerifyStatisticsParam param) {
        return CacheModule.VERIFY_STATISTICS + "_" + param.toString();
    }
}

