/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.statistics;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ict.business.statistics.StatisticsType;
import kd.fi.ict.business.statistics.VerifyStatistics;
import kd.fi.ict.business.statistics.VerifyStatisticsParam;
import kd.fi.ict.business.statistics.VerifyStatisticsRow;
import kd.fi.ict.enums.VerifyType;
import kd.fi.ict.util.QFBuilder;

public class StatisticsCalculator {
    private static final String[] ACCOUNT_RECORD_INFO = new String[]{"ict_relacctrecord", "amtloc", "amtballoc"};
    private static final String[] CF_RECORD_INFO = new String[]{"ict_relcfrecord", "amt", "amtbal"};

    public VerifyStatistics calculate(VerifyStatisticsParam param) {
        VerifyStatistics verifyStatistics = new VerifyStatistics();
        verifyStatistics.setVerifyStatisticsParam(param);
        Map<Long, VerifyStatisticsRow> verifyStatisticsRows = this.calculateData(param);
        VerifyStatisticsRow total = new VerifyStatisticsRow();
        for (VerifyStatisticsRow verifyStatisticsRow : verifyStatisticsRows.values()) {
            total.add(verifyStatisticsRow);
        }
        verifyStatistics.setVerifyStatisticsRows(verifyStatisticsRows);
        verifyStatistics.setTotal(total);
        return verifyStatistics;
    }

    private Map<Long, VerifyStatisticsRow> calculateData(VerifyStatisticsParam param) {
        HashMap<Long, VerifyStatisticsRow> verifyStatisticsRows = new HashMap<Long, VerifyStatisticsRow>(16);
        String[] recordInfo = this.getRecordInfo(param.getVerifyType());
        QFBuilder filters = this.toFilter(param);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)recordInfo[0], (String)String.join((CharSequence)",", "oporg", "dc", "status", recordInfo[1], recordInfo[2]), (QFilter[])filters.toArray(), null);){
            long opOrgId;
            try (DataSet sumDataSet = dataSet.copy().groupBy(new String[]{"oporg", "dc"}).sum(recordInfo[1]).sum(recordInfo[2]).finish();){
                for (Row row : sumDataSet) {
                    opOrgId = row.getLong("oporg");
                    BigDecimal amtballoc = row.getBigDecimal(recordInfo[2]);
                    BigDecimal amtloc = row.getBigDecimal(recordInfo[1]);
                    verifyStatisticsRows.compute(opOrgId, (k, v) -> {
                        String dc;
                        if (v == null) {
                            v = new VerifyStatisticsRow();
                        }
                        if ("1".equals(dc = row.getString("dc"))) {
                            v.getDifferentData().put(StatisticsType.AMOUNT, v.getDifferentData().get((Object)StatisticsType.AMOUNT).add(amtballoc));
                            v.getTotalData().put(StatisticsType.AMOUNT, v.getTotalData().get((Object)StatisticsType.AMOUNT).add(amtloc));
                        } else {
                            v.getDifferentData().put(StatisticsType.AMOUNT, v.getDifferentData().get((Object)StatisticsType.AMOUNT).subtract(amtballoc));
                            v.getTotalData().put(StatisticsType.AMOUNT, v.getTotalData().get((Object)StatisticsType.AMOUNT).subtract(amtloc));
                        }
                        v.getCheckedData().put(StatisticsType.AMOUNT, v.getTotalData().get((Object)StatisticsType.AMOUNT).subtract(v.getDifferentData().get((Object)StatisticsType.AMOUNT)));
                        return v;
                    });
                }
            }
            var8_10 = null;
            try (DataSet countSet = dataSet.groupBy(new String[]{"oporg", "status"}).count().finish();){
                for (Row row : countSet) {
                    opOrgId = row.getLong("oporg");
                    String status = row.getString("status");
                    BigDecimal count = row.getBigDecimal("count");
                    verifyStatisticsRows.compute(opOrgId, (k, v) -> {
                        if (v == null) {
                            v = new VerifyStatisticsRow();
                        }
                        if ("2".equals(status)) {
                            v.getCheckedData().put(StatisticsType.COUNT, v.getCheckedData().get((Object)StatisticsType.COUNT).add(count));
                        } else {
                            v.getDifferentData().put(StatisticsType.COUNT, v.getDifferentData().get((Object)StatisticsType.COUNT).add(count));
                        }
                        v.getTotalData().put(StatisticsType.COUNT, v.getTotalData().get((Object)StatisticsType.COUNT).add(count));
                        return v;
                    });
                }
            }
            catch (Throwable throwable) {
                var8_10 = throwable;
                throw throwable;
            }
        }
        return verifyStatisticsRows;
    }

    private QFBuilder toFilter(VerifyStatisticsParam param) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("org", "=", (Object)param.getOrgId());
        qfBuilder.add("period", "=", (Object)param.getPeriodId());
        if (VerifyType.ACCT == param.getVerifyType()) {
            qfBuilder.add("accounttable", "=", (Object)param.getAccountTableId());
        }
        return qfBuilder;
    }

    private String[] getRecordInfo(VerifyType type) {
        if (VerifyType.ACCT == type) {
            return ACCOUNT_RECORD_INFO;
        }
        return CF_RECORD_INFO;
    }
}

