/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.statistics;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.fi.ict.business.statistics.StatisticsType;

public class VerifyStatisticsRow {
    private static int size = StatisticsType.values().length;
    private Map<StatisticsType, BigDecimal> totalData;
    private Map<StatisticsType, BigDecimal> differentData;
    private Map<StatisticsType, BigDecimal> checkedData;

    public VerifyStatisticsRow() {
        this.initValue();
    }

    public final void initValue() {
        if (null == this.totalData) {
            this.totalData = new HashMap<StatisticsType, BigDecimal>(size);
        }
        if (null == this.differentData) {
            this.differentData = new HashMap<StatisticsType, BigDecimal>(size);
        }
        if (null == this.checkedData) {
            this.checkedData = new HashMap<StatisticsType, BigDecimal>(size);
        }
        for (StatisticsType type : StatisticsType.values()) {
            this.totalData.putIfAbsent(type, BigDecimal.ZERO);
            this.differentData.putIfAbsent(type, BigDecimal.ZERO);
            this.checkedData.putIfAbsent(type, BigDecimal.ZERO);
        }
    }

    public Map<StatisticsType, BigDecimal> getTotalData() {
        return this.totalData;
    }

    public void setTotalData(Map<StatisticsType, BigDecimal> totalData) {
        this.totalData = totalData;
    }

    public Map<StatisticsType, BigDecimal> getDifferentData() {
        return this.differentData;
    }

    public void setDifferentData(Map<StatisticsType, BigDecimal> differentData) {
        this.differentData = differentData;
    }

    public Map<StatisticsType, BigDecimal> getCheckedData() {
        return this.checkedData;
    }

    public void setCheckedData(Map<StatisticsType, BigDecimal> checkedData) {
        this.checkedData = checkedData;
    }

    public void add(VerifyStatisticsRow verifyStatisticsRow) {
        for (StatisticsType type : StatisticsType.values()) {
            this.getTotalData().put(type, this.getTotalData().get((Object)type).add(verifyStatisticsRow.getTotalData().get((Object)type)));
            this.getDifferentData().put(type, this.getDifferentData().get((Object)type).add(verifyStatisticsRow.getDifferentData().get((Object)type)));
            this.getCheckedData().put(type, this.getCheckedData().get((Object)type).add(verifyStatisticsRow.getCheckedData().get((Object)type)));
        }
    }
}

