/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.business.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ict.enums.CheckStatus;
import kd.fi.ict.enums.VerifyType;
import kd.fi.ict.util.ContextUtil;

public class IctRecordUtil {
    private static final Log LOGGER = LogFactory.getLog(IctRecordUtil.class);

    public static void RelRecordHandle(Set<Long> vchIds, VerifyType verifyType) {
        DynamicObjectCollection successRelRecord;
        QFilter fvoucherid = new QFilter("voucherid", "in", vchIds);
        boolean isAcctType = VerifyType.ACCT == verifyType;
        String formKey = isAcctType ? "ict_relacctrecord" : "ict_relcfrecord";
        String formLogKey = isAcctType ? "ict_pullacctdetaillog" : "ict_pullcfdetaillog";
        String formCheckKey = isAcctType ? "ict_check_record" : "ict_check_cash_record";
        QFilter fstatus = new QFilter("status", "!=", (Object)"0");
        DynamicObjectCollection failRelRecord = QueryServiceHelper.query((String)formKey, (String)"id,voucherid,bookeddate,billno,org", (QFilter[])new QFilter[]{fvoucherid, fstatus});
        Object[] recordIds = failRelRecord.stream().map(dyn -> dyn.getLong("id")).toArray();
        QFilter qfRecordId = new QFilter("entryentity.relrecordid", "in", (Object)recordIds);
        DynamicObjectCollection checkRecordColl = QueryServiceHelper.query((String)formCheckKey, (String)"id", (QFilter[])qfRecordId.toArray(), (String)"id desc");
        Object[] ids = checkRecordColl.stream().map(dyn -> dyn.getLong("id")).toArray();
        LinkedHashMap<Long, DynamicObject> relRecordLogMap = new LinkedHashMap<Long, DynamicObject>(failRelRecord.size());
        OperateOption operate = OperateOption.create();
        operate.setVariableValue("ishasright", "true");
        if (ids.length > 0) {
            operate.setVariableValue("voucherids", SerializationUtils.toJsonString(vchIds));
            OperationResult result = OperationServiceHelper.executeOperate((String)"cancelcheck", (String)formCheckKey, (Object[])ids, (OperateOption)operate);
            if (result.isSuccess()) {
                for (DynamicObject relRecord : failRelRecord) {
                    relRecordLogMap.put(relRecord.getLong("voucherid"), relRecord);
                }
                IctRecordUtil.save(relRecordLogMap, formLogKey, CheckStatus.ALL_CHECK);
            } else {
                LOGGER.info(result.getMessage());
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u6570\u636e\u5b58\u5728\u5185\u90e8\u4ea4\u6613\u6570\u636e\u6b63\u5728\u8fdb\u884c\u5176\u4ed6\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"IctRecordUtil_0", (String)"fi-ict-business", (Object[])new Object[0]));
            }
        }
        if ((successRelRecord = QueryServiceHelper.query((String)formKey, (String)"id,voucherid,bookeddate,billno,org", (QFilter[])new QFilter[]{fvoucherid, fstatus = new QFilter("status", "=", (Object)"0")})).size() > 0) {
            Object[] recIds = successRelRecord.stream().map(dyn -> dyn.getLong("id")).toArray();
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)formKey, (Object[])recIds, (OperateOption)operate);
            if (result.isSuccess()) {
                for (DynamicObject relRecord : successRelRecord) {
                    relRecordLogMap.put(relRecord.getLong("voucherid"), relRecord);
                }
                IctRecordUtil.save(relRecordLogMap, formLogKey, CheckStatus.NONE);
            } else {
                LOGGER.info(result.getMessage());
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u6570\u636e\u5b58\u5728\u5185\u90e8\u4ea4\u6613\u6570\u636e\u6b63\u5728\u8fdb\u884c\u5176\u4ed6\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"IctRecordUtil_0", (String)"fi-ict-business", (Object[])new Object[0]));
            }
        }
    }

    private static void save(Map<Long, DynamicObject> relRecordLogMap, String formLogKey, CheckStatus status) {
        ArrayList<DynamicObject> failDynlst = new ArrayList<DynamicObject>(10);
        for (Map.Entry<Long, DynamicObject> entry : relRecordLogMap.entrySet()) {
            DynamicObject dyn = entry.getValue();
            DynamicObject failDyn = BusinessDataServiceHelper.newDynamicObject((String)formLogKey);
            failDyn.set("creator", (Object)ContextUtil.getUserId());
            failDyn.set("org", (Object)dyn.getLong("org"));
            String billno = dyn.getString("billno");
            failDyn.set("vchnumber", (Object)billno);
            failDyn.set("bookeddate", (Object)dyn.getDate("bookeddate"));
            if (CheckStatus.NONE == status) {
                failDyn.set("execdetail", (Object)ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u51ed\u8bc1\uff0c\u5220\u9664\u51ed\u8bc1\u3010%s\u3011\u7684\u62bd\u53d6\u6570\u636e", (String)"CheckRelrecordConsumer_0", (String)"fi-ict-business", (Object[])new Object[]{billno}));
            } else {
                failDyn.set("execdetail", (Object)ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u51ed\u8bc1\uff0c\u5df2\u5220\u9664\u51ed\u8bc1\u3010%s\u3011\u7684\u52fe\u7a3d\u8bb0\u5f55", (String)"CheckRelrecordConsumer_1", (String)"fi-ict-business", (Object[])new Object[]{billno}));
            }
            failDyn.set("status", (Object)"1");
            failDyn.set("createtime", (Object)TimeServiceHelper.getTimeStamp());
            failDynlst.add(failDyn);
            if (failDynlst.size() <= 1000) continue;
            SaveServiceHelper.save((DynamicObject[])failDynlst.toArray(new DynamicObject[0]));
        }
        if (failDynlst.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])failDynlst.toArray(new DynamicObject[0]));
        }
    }
}

