/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.puchamt.acct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.ict.puchamt.acct.AcctPuchAmtQueryParam;

public class AccountTreeModel {
    private RowMeta rowMeta = new RowMeta(new String[]{"id", "masterid", "parent", "org"}, new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.LongType});
    private String[] acctFileds = new String[]{"id", "masterid", "number"};
    private List<Object[]> accountTreeData;
    private Set<Long> filterAccountIds = new HashSet<Long>(16);
    private Set<Object> displayAccountIds = new HashSet<Object>(16);

    public AccountTreeModel(Long[] orgIds, long accountTableId, long periodId, AcctPuchAmtQueryParam param) {
        if (param == null) {
            return;
        }
        if (param.getAcctParam().getAccountFilter() == null || !this.existAccIdFilter(param.getAcctParam().getAccountFilter())) {
            this.accountTreeData = this.getData(orgIds, accountTableId, periodId, null);
        } else {
            QFilter qfilter = new QFilter("accounttable", "=", (Object)accountTableId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid,number", (QFilter[])new QFilter[]{qfilter, param.getAcctParam().getAccountFilter()});
            HashSet<String> accountNumbers = new HashSet<String>();
            for (DynamicObject obj : coll) {
                accountNumbers.add(obj.getString("number"));
            }
            qfilter.and(new QFilter("number", "in", accountNumbers));
            coll = QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid,parent", (QFilter[])qfilter.toArray());
            if (param.getAcctParam().isSpecialAccount()) {
                for (DynamicObject obj : coll) {
                    this.displayAccountIds.add(obj.getLong("id"));
                }
            }
            Set<Long> masterIdSet = this.filterAccountIds = this.getAllLeafAccount(coll);
            if (!param.getAcctParam().isOnlyLeafAcctAmt()) {
                masterIdSet = this.getMasterIds(this.getParentIds(coll));
                masterIdSet.addAll(this.filterAccountIds);
            }
            this.accountTreeData = this.getData(orgIds, accountTableId, periodId, new QFilter("masterid", "in", masterIdSet));
        }
        if (!param.getAcctParam().isSpecialAccount()) {
            for (Object[] row : this.accountTreeData) {
                this.displayAccountIds.add(row[0]);
            }
        }
    }

    public DataSet getTreeDataSet() {
        return Algo.create((String)this.getClass().getName()).createDataSet(this.accountTreeData.iterator(), this.rowMeta);
    }

    private boolean existAccIdFilter(QFilter accFilter) {
        String property = accFilter.getProperty();
        if (property.equalsIgnoreCase("id") || property.equalsIgnoreCase("number") || property.equalsIgnoreCase("masterid")) {
            return true;
        }
        List nests = accFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            String prop = nest.getFilter().getProperty();
            if (!prop.equalsIgnoreCase("id") && !prop.equalsIgnoreCase("number") && !property.equalsIgnoreCase("masterid")) continue;
            return true;
        }
        return false;
    }

    private Set<Long> getAllLeafAccount(DynamicObjectCollection parents) {
        HashSet<Long> accountIdSet = new HashSet<Long>(64);
        HashSet<Long> pSet = new HashSet<Long>();
        for (DynamicObject p : parents) {
            long masterId = p.getLong("masterid");
            accountIdSet.add(masterId);
            pSet.add(masterId);
            pSet.add(p.getLong("id"));
        }
        QFilter qFilter = new QFilter("parent", "in", pSet);
        DynamicObjectCollection accColl = QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid", (QFilter[])qFilter.toArray());
        if (!accColl.isEmpty()) {
            accountIdSet.addAll(this.getAllLeafAccount(accColl));
        }
        return accountIdSet;
    }

    private Set<Long> getMasterIds(Set<Long> accountIdSet) {
        if (accountIdSet.isEmpty()) {
            return new HashSet<Long>(0);
        }
        DynamicObjectCollection accColl = QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter("id", "in", accountIdSet).toArray());
        HashSet<Long> masterIdSet = new HashSet<Long>(accColl.size());
        for (DynamicObject account : accColl) {
            masterIdSet.add(account.getLong("masterid"));
        }
        return masterIdSet;
    }

    private Set<Long> getParentIds(DynamicObjectCollection accounts) {
        HashSet<Long> parentIdSet = new HashSet<Long>(64);
        for (DynamicObject account : accounts) {
            long parentId = account.getLong("parent");
            if (parentId == 0L) continue;
            parentIdSet.add(parentId);
        }
        if (!parentIdSet.isEmpty()) {
            DynamicObjectCollection accColl = QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid,parent", (QFilter[])new QFilter("id", "in", parentIdSet).toArray());
            parentIdSet.addAll(this.getParentIds(accColl));
        }
        return parentIdSet;
    }

    private List<Object[]> getData(Long[] orgIds, long accountTableId, long periodId, QFilter accountFilter) {
        AccountTreeNode node;
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"enddate", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
        ArrayList<Object[]> accountData = new ArrayList<Object[]>(64);
        if (period == null) {
            return accountData;
        }
        String accFilterStr = null;
        if (accountFilter != null) {
            accFilterStr = this.parseAccFilter(accountFilter.copy());
        }
        Map<String, AccountTreeNode> accountNodeMap = accountFilter != null && accFilterStr == null || orgIds.length == 1 ? this.queryAccount(orgIds, accountFilter, period, accountTableId) : this.queryAccount(orgIds, period, accountTableId, accFilterStr);
        for (Map.Entry<String, AccountTreeNode> entry : accountNodeMap.entrySet()) {
            node = entry.getValue();
            Map<Long, String> orgToPnumberMap = node.getOrgToPnumberMap();
            if (orgToPnumberMap == null) continue;
            for (Map.Entry<Long, String> entryPnumber : orgToPnumberMap.entrySet()) {
                AccountTreeNode pnode;
                Long orgId = entryPnumber.getKey();
                String pNumber = entryPnumber.getValue();
                if (pNumber == null || (pnode = accountNodeMap.get(pNumber)) == null) continue;
                node.setOrgToPidMap(orgId, pnode.orgToObjsMap.get(orgId) == null ? null : (Long)((Object[])pnode.orgToObjsMap.get(orgId))[0]);
            }
        }
        for (Map.Entry<String, AccountTreeNode> entry : accountNodeMap.entrySet()) {
            node = entry.getValue();
            for (Map.Entry<Long, Object[]> entryObj : node.getOrgToObjsMap().entrySet()) {
                long orgId = entryObj.getKey();
                Object[] objs = entryObj.getValue();
                accountData.add(new Object[]{objs[0], objs[1], node.getOrgToPidMap() == null ? null : node.getOrgToPidMap().get(orgId), orgId});
            }
        }
        return accountData;
    }

    private String parseAccFilter(QFilter accFilter) {
        String property;
        List<String> accList = Arrays.asList(this.acctFileds);
        if (!accList.contains(property = accFilter.getProperty()) || this.isEmptyCollection(accFilter)) {
            return null;
        }
        property = this.addF_Id(property);
        accFilter.__setProperty(property);
        List nests = accFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestFilter = nest.getFilter();
            String prop = nestFilter.getProperty();
            if (!accList.contains(prop)) {
                return null;
            }
            prop = this.addF_Id(prop);
            nestFilter.__setProperty(prop);
        }
        return accFilter.toString();
    }

    private boolean isEmptyCollection(QFilter accFilter) {
        Collection setId;
        String prop = accFilter.getProperty();
        Object valObj = accFilter.getValue();
        if ("number".equalsIgnoreCase(prop)) {
            return valObj instanceof String;
        }
        return valObj instanceof Collection && ((setId = (Collection)accFilter.getValue()) == null || setId.isEmpty());
    }

    private String addF_Id(String property) {
        property = "c.f" + property;
        return property;
    }

    private Map<String, AccountTreeNode> queryAccount(Long[] orgIds, DynamicObject period, long accountTableId, String accFilterStr) {
        HashMap<String, AccountTreeNode> numberToNodeMap = new HashMap<String, AccountTreeNode>(64);
        StringBuilder baseFilter = new StringBuilder();
        baseFilter.append(" c.f").append("accounttable").append("id").append("=").append("?");
        baseFilter.append(" AND c.f").append("startdate").append("<=").append("?");
        baseFilter.append(" AND c.f").append("enddate").append(">=").append("?");
        if (accFilterStr != null) {
            baseFilter.append(" AND ");
            baseFilter.append(accFilterStr);
        }
        ArrayList<Comparable<Long>> baseParamObjs = new ArrayList<Comparable<Long>>(16);
        baseParamObjs.add(Long.valueOf(accountTableId));
        baseParamObjs.add(period.getDate("enddate"));
        baseParamObjs.add(period.getDate("enddate"));
        StringBuilder baseFields = new StringBuilder();
        baseFields.append(" c.fid id, c.fmasterid masterid, c.fnumber number, c.flongnumber longnumber, c.fparentid parentid ");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT u.fuseorgid orgid, ");
        sql.append((CharSequence)baseFields);
        sql.append(" FROM T_BD_ACCOUNT_U AS u INNER JOIN T_BD_ACCOUNT AS c ON u.fdataid = c.fid WHERE ");
        sql.append((CharSequence)baseFilter);
        sql.append(" AND u.fuseorgid IN (");
        for (int j = 0; j < orgIds.length; ++j) {
            sql.append(j > 0 ? ",?" : "?");
        }
        sql.append(")");
        ArrayList<Comparable<Long>> _uParams = new ArrayList<Comparable<Long>>();
        _uParams.addAll(baseParamObjs);
        _uParams.addAll(Arrays.asList(orgIds));
        try (DataSet dataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (String)sql.toString(), (Object[])_uParams.toArray(new Object[0]));){
            for (Row row : dataSet) {
                this.buildAccountTreeMap(row.getLong("orgid"), row, numberToNodeMap);
            }
        }
        sql.setLength(0);
        sql.append("SELECT ");
        sql.append((CharSequence)baseFields);
        sql.append(" FROM T_BD_ACCOUNT AS c WHERE c.fctrlstrategy = '5' AND c.fstatus = 'C' AND");
        sql.append((CharSequence)baseFilter);
        dataSet = DB.queryDataSet((String)AccountVersionUtil.class.getName(), (DBRoute)DBRoute.of((String)"gl"), (String)sql.toString(), (Object[])baseParamObjs.toArray(new Object[0]));
        var13_13 = null;
        try {
            for (Row row : dataSet) {
                for (Long orgId : orgIds) {
                    this.buildAccountTreeMap(orgId, row, numberToNodeMap);
                }
            }
        }
        catch (Throwable throwable) {
            var13_13 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var13_13 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var13_13.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return numberToNodeMap;
    }

    private Map<String, AccountTreeNode> queryAccount(Long[] orgIds, QFilter accountFilter, DynamicObject period, long accountTableId) {
        HashMap<String, AccountTreeNode> numberToNodeMap = new HashMap<String, AccountTreeNode>(64);
        for (Long orgId : orgIds) {
            QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
            baseFilter.and(accountFilter);
            baseFilter.and(new QFilter("accounttable", "=", (Object)accountTableId));
            baseFilter.and(new QFilter("startdate", "<=", (Object)period.getDate("enddate")));
            baseFilter.and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id,masterid,number,longnumber", (QFilter[])baseFilter.toArray(), null);
            for (Row row : dataSet) {
                this.buildAccountTreeMap(orgId, row, numberToNodeMap);
            }
        }
        return numberToNodeMap;
    }

    private void buildAccountTreeMap(long orgId, Row row, Map<String, AccountTreeNode> numberToNodeMap) {
        String number = row.getString("number");
        AccountTreeNode treeNode = numberToNodeMap.computeIfAbsent(number, x -> new AccountTreeNode());
        treeNode.buildAccountTreeNode(orgId, row);
        numberToNodeMap.put(number, treeNode);
    }

    public List<Object[]> getAccountTreeData() {
        return this.accountTreeData;
    }

    public Set<Object> getDisplayAccountIds() {
        return this.displayAccountIds;
    }

    public Set<Long> getFilterAccountIds() {
        return this.filterAccountIds;
    }

    static class AccountTreeNode {
        private String number;
        private Map<Long, String> orgToPnumberMap = new HashMap<Long, String>(16);
        private Map<Long, Object[]> orgToObjsMap = new HashMap<Long, Object[]>(16);
        private Map<Long, Long> orgToPidMap = new HashMap<Long, Long>(16);

        private AccountTreeNode() {
        }

        private void buildAccountTreeNode(long orgId, Row row) {
            this.number = row.getString("number");
            String longNumber = row.getString("longnumber");
            String[] numbers = longNumber.split("_");
            String parentNumber = this.number;
            if (numbers.length > 1) {
                int parentLen = numbers.length;
                parentNumber = numbers[parentLen - 2];
                this.orgToPnumberMap.put(orgId, parentNumber);
            }
            Object[] objs = new Object[]{row.getLong("id"), row.getLong("masterid"), parentNumber};
            this.orgToObjsMap.put(orgId, objs);
        }

        public String getNumber() {
            return this.number;
        }

        public Map<Long, String> getOrgToPnumberMap() {
            return this.orgToPnumberMap;
        }

        public Map<Long, Object[]> getOrgToObjsMap() {
            return this.orgToObjsMap;
        }

        public Map<Long, Long> getOrgToPidMap() {
            return this.orgToPidMap;
        }

        public void setOrgToPidMap(Long orgId, Long pid) {
            this.orgToPidMap.put(orgId, pid);
        }
    }
}

