/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.puchamt.acct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BDUtil;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.ict.puchamt.AcctPuchAmtQueryExecutor;
import kd.fi.ict.puchamt.acct.AccountTreeModel;
import kd.fi.ict.puchamt.acct.AcctPuchAmtQueryParam;

public class AcctPuchAmtQueryExecutorImpl
implements AcctPuchAmtQueryExecutor {
    private static final String BEGIN_PROP = "pbeginfor,pbeginlocal,cbeginfor,cbeginlocal";
    private static final String END_PROP = "pendfor,pendlocal,cendfor,cendlocal";
    private static final String YEAR_PROP = "pyeardebitfor,pyeardebitlocal,pyearcreditfor,pyearcreditlocal,cyeardebitfor,cyeardebitlocal,cyearcreditfor,cyearcreditlocal";
    private static final String DCP_PROP = "pdebitfor,pdebitlocal,pcreditfor,pcreditlocal,cdebitfor,cdebitlocal,ccreditfor,ccreditlocal,curcdebitfor,curcdebitlocal,curccreditfor,curccreditlocal,curndebitfor,curndebitlocal,curncreditfor,curncreditlocal";
    private static final String THEN = " then ";
    private static final String ELSE0END = " else 0 end ";
    private static final String ELSE0_0END = " else 0.0 end";
    private static final String TAG_LEAF = "_tag_leaf";
    private PuchQueryParamWarp param;
    private AccountTreeModel accountModel;

    @Override
    public DataSet getPuchAmt(AcctPuchAmtQueryParam queryParam) {
        queryParam = Optional.ofNullable(queryParam).orElseGet(() -> new AcctPuchAmtQueryParam());
        this.param = new PuchQueryParamWarp(queryParam);
        this.init(this.param);
        DataSet balance = this.getPuchAmtData();
        DataSet result = this.getGroupAmt(balance);
        Field[] fields = result.getRowMeta().getFields();
        HashSet<String> leftSelectSet = new HashSet<String>(16);
        boolean existAccountSelect = false;
        for (Field field : fields) {
            String name = field.getName().toLowerCase();
            if (!this.param.getAcctParam().isSumAssgrp() && "assgrp".equals(name)) continue;
            if ("account".equalsIgnoreCase(name)) {
                existAccountSelect = true;
                continue;
            }
            leftSelectSet.add(name);
        }
        if (existAccountSelect) {
            result = result.join(this.accountModel.getTreeDataSet(), JoinType.INNER).on("org", "org").on("account", "masterid").select(leftSelectSet.toArray(new String[0]), new String[]{"id account"}).finish().filter("account !=0");
        }
        if (!this.param.getAcctParam().isOnlyLeafAcctAmt()) {
            result = this.levelSumAccountAmt(result);
            List resultCols = BDUtil.getDataSetCols((DataSet)result);
            resultCols.removeIf(str -> str.equalsIgnoreCase("period"));
            String[] accountCols = null;
            if (this.param.acctSelector.trim().length() > 0) {
                accountCols = this.param.acctSelector.replace(", id", "").split(",");
                for (int i = 0; i < accountCols.length; ++i) {
                    String[] sel = accountCols[i].trim().split(" ");
                    if (sel.length <= 1) continue;
                    accountCols[i] = sel[1].trim();
                }
            }
            DataSet acctDataSet = this.getAccountSet(this.param.acctSelector, new QFilter("id", "in", this.accountModel.getDisplayAccountIds()));
            result = result.join(acctDataSet, JoinType.INNER).on("account", "id").select(resultCols.toArray(new String[0]), accountCols).finish();
            this.param.oriSelector = this.param.oriSelector.replace("account.isleaf", TAG_LEAF).replace("account.", "");
        }
        if (this.param.getAcctParam().isAddAmountFilter()) {
            // empty if block
        }
        result = this.addEntityRefField(result);
        return result.select(this.param.oriSelector);
    }

    private DataSet levelSumAccountAmt(DataSet puchAmt) {
        boolean notSumAssgrp = false;
        Field[] fields = puchAmt.getRowMeta().getFields();
        HashSet<String> sumFieldSet = new HashSet<String>();
        HashSet<String> groupFieldSet = new HashSet<String>();
        ArrayList<String> selectSet = new ArrayList<String>();
        HashSet<String> leftSelectSet = new HashSet<String>();
        for (Field field : fields) {
            String name = field.getName().toLowerCase();
            if (!this.param.getAcctParam().isSumAssgrp() && "assgrp".equals(name)) {
                notSumAssgrp = true;
                continue;
            }
            selectSet.add(name);
            if (!"account".equalsIgnoreCase(name)) {
                leftSelectSet.add(name);
            }
            if (field.getDataType() instanceof BigDecimalType) {
                sumFieldSet.add(name);
                continue;
            }
            groupFieldSet.add(name);
        }
        String[] groupFields = groupFieldSet.toArray(new String[0]);
        String[] sumFields = sumFieldSet.toArray(new String[0]);
        String[] selector = selectSet.toArray(new String[0]);
        String[] leftSelector = leftSelectSet.toArray(new String[0]);
        return this.accountSum(puchAmt, notSumAssgrp, groupFields, sumFields, selector, leftSelector);
    }

    private DataSet addEntityRefField(DataSet result) {
        for (Map.Entry entry : this.param.entityRefMap.entrySet()) {
            String field;
            StringBuilder sb;
            String rfield = (String)entry.getKey();
            Set fileldList = (Set)entry.getValue();
            DataSet dataSet = null;
            ArrayList<QFilter> reFilters = new ArrayList<QFilter>();
            if (rfield.startsWith("account") && this.param.getAcctParam().isOnlyLeafAcctAmt()) {
                sb = new StringBuilder("id account");
                for (String reField : fileldList) {
                    field = reField.substring(8) + " " + reField;
                    sb.append(",").append(field);
                }
                if (this.param.getAcctParam().getAccountFilter() != null) {
                    if (!this.accountModel.getFilterAccountIds().isEmpty()) {
                        reFilters.add(new QFilter("masterid", "in", this.accountModel.getFilterAccountIds()));
                    } else {
                        reFilters.add(this.getBalanceAcctFilter(this.param.getAcctParam().getAccountFilter(), "id"));
                    }
                }
                dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)sb.toString(), (QFilter[])reFilters.toArray(new QFilter[0]), null);
            } else if (rfield.startsWith("period")) {
                sb = new StringBuilder("id period");
                for (String reField : fileldList) {
                    field = reField.substring(7) + " " + reField;
                    sb.append(",").append(field);
                }
                reFilters.add(new QFilter("id", ">=", (Object)(this.param.getEndPeriodID() / PeriodUtil.TYPE_PERIOD_L * PeriodUtil.TYPE_PERIOD_L)));
                reFilters.add(new QFilter("id", "<=", (Object)this.param.getEndPeriodID()));
                dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_period", (String)sb.toString(), (QFilter[])reFilters.toArray(new QFilter[0]), null);
            } else if (rfield.startsWith("currency")) {
                sb = new StringBuilder("id currency");
                for (String reField : fileldList) {
                    field = reField.substring(9) + " " + reField;
                    sb.append(",").append(field);
                }
                Long[] currencyIds = this.param.getAcctParam().getCurrencyIds();
                if (currencyIds != null && currencyIds.length > 0) {
                    reFilters.add(new QFilter("id", "in", (Object)currencyIds));
                }
                dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_currency", (String)sb.toString(), (QFilter[])reFilters.toArray(new QFilter[0]), null);
            }
            if (dataSet == null) continue;
            List<String> leftList = this.getDSFileds(result);
            List<String> rightList = this.getDSFileds(dataSet);
            rightList.removeAll(leftList);
            result = result.join(dataSet).on(rfield, rfield).select(leftList.toArray(new String[0]), rightList.toArray(new String[0])).finish();
        }
        return result;
    }

    public List<String> getDSFileds(DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> result = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            String alias = field.getAlias();
            result.add(alias);
        }
        return result;
    }

    private QFilter getBalanceAcctFilter(QFilter accountFilter, String prefix) {
        HashSet<Long> set = new HashSet<Long>(0);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".acct"), (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{accountFilter}, null);){
            for (Row row : dataSet) {
                set.add(row.getLong("id"));
                set.add(row.getLong("masterid"));
            }
        }
        return new QFilter(prefix, "in", set);
    }

    private DataSet accountSum(DataSet puchAmt, boolean notSumAssgrp, String[] groupFields, String[] sumFields, String[] selector, String[] leftSelector) {
        DataSet ds;
        DataSet pacctDataSet = puchAmt;
        DataSet sumDataSet = null;
        boolean existParent = false;
        for (Object[] acc : this.accountModel.getAccountTreeData()) {
            if (acc[2] == null) continue;
            existParent = true;
            break;
        }
        while (existParent && (ds = pacctDataSet.copy().join(this.accountModel.getTreeDataSet(), JoinType.INNER).on("org", "org").on("account", "id").select(leftSelector, new String[]{" parent account"}).finish().filter(" account != 0")).hasNext()) {
            GroupbyDataSet group = ds.groupBy(groupFields);
            GroupbyDataSet groupbyDataSet = sumFields;
            int n = ((GroupbyDataSet)groupbyDataSet).length;
            for (int i = 0; i < n; ++i) {
                GroupbyDataSet sumField = groupbyDataSet[i];
                group.sum((String)sumField);
            }
            pacctDataSet = group.finish().select(selector);
            sumDataSet = sumDataSet == null ? pacctDataSet : sumDataSet.union(pacctDataSet);
        }
        if (sumDataSet != null) {
            GroupbyDataSet group = sumDataSet.groupBy(groupFields);
            for (String sumField : sumFields) {
                group.sum(sumField);
            }
            sumDataSet = group.finish().select(selector);
            if (notSumAssgrp) {
                sumDataSet = sumDataSet.addField("0L", "assgrp");
                List cols = BDUtil.getDataSetCols((DataSet)puchAmt);
                sumDataSet = sumDataSet.select(cols.toArray(new String[0]));
            }
            return puchAmt.addField("true", TAG_LEAF).union(sumDataSet.addField("false", TAG_LEAF));
        }
        return puchAmt.addField("true", TAG_LEAF);
    }

    private DataSet getAccountSet(String selector, QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".account"), (String)"bd_accountview", (String)selector, (QFilter[])filter.toArray(), null);
    }

    private DataSet getPuchAmtData() {
        DataSet balanceData;
        QFilter[] filters = this.getFilters();
        if (this.param.getPuchEntityType() != null) {
            MainEntityType puchEntityType = this.param.getPuchEntityType();
            ORM orm = ORM.create();
            orm.setDataEntityType("ict_acctpuchamt", (IDataEntityType)puchEntityType);
            balanceData = orm.queryDataSet(this.getClass().getName(), "ict_acctpuchamt", this.param.querySelector, filters, this.param.getQueryOrder());
        } else {
            balanceData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"ict_acctpuchamt", (String)this.param.querySelector, (QFilter[])filters, (String)this.param.getQueryOrder());
        }
        return balanceData;
    }

    private DataSet getGroupAmt(DataSet ds) {
        Field[] fields;
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> sums = new ArrayList<String>();
        for (Field field : fields = ds.getRowMeta().getFields()) {
            String name = field.getName().toLowerCase();
            if (field.getDataType() instanceof BigDecimalType) {
                sums.add(name);
                continue;
            }
            if (name.contains("period")) continue;
            groups.add(name);
        }
        if (this.param.showPeriod) {
            groups.add("period");
        }
        GroupbyDataSet groupSet = ds.groupBy(groups.toArray(new String[0]));
        if (this.param.showPeriod) {
            for (String sum : sums) {
                groupSet.sum(sum);
            }
        } else {
            this.groupSum(sums, groupSet);
        }
        DataSet result = groupSet.finish();
        return result;
    }

    private void groupSum(List<String> sums, GroupbyDataSet groupSet) {
        for (String field : sums) {
            if (BEGIN_PROP.contains(field)) {
                groupSet.sum("case when period =" + this.param.getBeginPeriodId() + THEN + field + " when period < " + this.param.getBeginPeriodId() + " and endperiod > " + this.param.getBeginPeriodId() + THEN + field.replace("begin", "end") + ELSE0_0END, field);
                groupSet.sum("case when period =" + this.param.getBeginPeriodId() + THEN + field + " when period < " + this.param.getBeginPeriodId() + " and endperiod > " + this.param.getBeginPeriodId() + THEN + field.replace("begin", "end") + ELSE0_0END, field);
                continue;
            }
            if (DCP_PROP.contains(field)) {
                groupSet.sum("case when period >=" + this.param.getBeginPeriodId() + THEN + field + ELSE0_0END, field);
                continue;
            }
            if (YEAR_PROP.contains(field)) {
                groupSet.sum("case when endperiod >" + this.param.getEndPeriodID() + " and period <=" + this.param.getEndPeriodID() + " and (period >" + this.param.getEndPeriodID() / PeriodUtil.YEAR_PERIOD_L * PeriodUtil.YEAR_PERIOD_L + ")" + THEN + field + ELSE0_0END, field);
                continue;
            }
            if (!END_PROP.contains(field)) continue;
            groupSet.sum("case when period<=" + this.param.getEndPeriodID() + " and endperiod >" + this.param.getEndPeriodID() + THEN + field + ELSE0_0END, field);
        }
    }

    private void init(PuchQueryParamWarp param) {
        this.accountModel = new AccountTreeModel(param.getOrgIds(), param.getAccountTableId(), param.getEndPeriodID(), param);
    }

    private QFilter[] getFilters() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        if (Objects.nonNull(this.param.getReconschemeId())) {
            filters.add(new QFilter("reconscheme", "=", (Object)this.param.getReconschemeId()));
        }
        filters.add(new QFilter("org", "in", (Object)this.param.getOrgIds()));
        filters.add(new QFilter("booktype", "=", (Object)this.param.getBookTypeId()));
        if (Objects.nonNull(this.param.getOpOrgIds()) && this.param.getOpOrgIds().length > 0) {
            filters.add(new QFilter("oporg", "in", (Object)this.param.getOpOrgIds()));
        }
        filters.add(new QFilter("period", ">=", (Object)(this.param.getEndPeriodID() / PeriodUtil.TYPE_PERIOD_L * PeriodUtil.TYPE_PERIOD_L)));
        filters.add(new QFilter("period", "<=", (Object)this.param.getEndPeriodID()));
        if (Objects.nonNull(this.param.getAcctParam().getCurrencyIds()) && this.param.getAcctParam().getCurrencyIds().length > 0) {
            filters.add(new QFilter("currency", "in", (Object)this.param.getAcctParam().getCurrencyIds()));
        }
        if (Objects.nonNull(this.param.getAcctParam().getAssGrpIds()) && this.param.getAcctParam().getAssGrpIds().size() > 0) {
            filters.add(new QFilter("assgrp", "in", this.param.getAcctParam().getAssGrpIds()));
        }
        if (this.param.getAcctParam().getAccountFilter() != null) {
            if (this.accountModel.getFilterAccountIds().isEmpty()) {
                filters.add(this.getPuchAcctFilter(this.param.getAcctParam().getAccountFilter(), "account"));
            } else {
                filters.add(new QFilter("account", "in", this.accountModel.getFilterAccountIds()));
            }
        }
        if (this.param.getAcctParam().getCustomFilter() != null) {
            filters.addAll(this.param.getAcctParam().getCustomFilter());
        }
        return filters.toArray(new QFilter[0]);
    }

    public QFilter getPuchAcctFilter(QFilter accountFilter, String prefix) {
        HashSet<Long> set = new HashSet<Long>(0);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + ".acct"), (String)"bd_accountview", (String)"id,masterid", (QFilter[])new QFilter[]{accountFilter}, null);){
            for (Row row : dataSet) {
                set.add(row.getLong("id"));
                set.add(row.getLong("masterid"));
            }
        }
        return new QFilter(prefix, "in", set);
    }

    static class PuchQueryParamWarp
    extends AcctPuchAmtQueryParam {
        private String oriSelector;
        private String acctSelector;
        private String querySelector;
        private Map<String, Set<String>> entityRefMap = new HashMap<String, Set<String>>(8);
        private boolean showPeriod;

        public PuchQueryParamWarp(AcctPuchAmtQueryParam queryParam) {
            super(queryParam);
            this.oriSelector = queryParam.getSelector().replace(".id", "");
            this.setQuerySelector(queryParam);
        }

        private void setQuerySelector(AcctPuchAmtQueryParam queryParam) {
            String[] fields = this.oriSelector.split(",");
            List<String> oriSel = this.getOriSel(fields);
            LinkedHashSet<String> querySet = new LinkedHashSet<String>();
            LinkedHashSet<String> acctSet = new LinkedHashSet<String>();
            for (String sel : oriSel) {
                if (AcctPuchAmtQueryExecutorImpl.BEGIN_PROP.contains(sel)) {
                    querySet.add(sel);
                    querySet.add(sel.replace("begin", "end"));
                    continue;
                }
                if (sel.startsWith("account.")) {
                    if (!queryParam.getAcctParam().isOnlyLeafAcctAmt()) {
                        acctSet.add(sel.substring(8));
                        continue;
                    }
                    this.entityRefMap.computeIfAbsent("account", x -> new HashSet()).add(sel.trim());
                    querySet.add("account");
                    continue;
                }
                if (sel.startsWith("currency.")) {
                    this.entityRefMap.computeIfAbsent("currency", x -> new HashSet()).add(sel.trim());
                    querySet.add("currency");
                    continue;
                }
                if (sel.startsWith("period.")) {
                    this.entityRefMap.computeIfAbsent("period", x -> new HashSet()).add(sel.trim());
                    querySet.add("period");
                    continue;
                }
                querySet.add(sel);
            }
            if (queryParam.getAcctParam().isZeroAmtNoDisplay()) {
                querySet.add("pendfor");
                querySet.add("pendlocal");
                querySet.add("cendfor");
                querySet.add("cendlocal");
            }
            if (querySet.contains("period")) {
                this.showPeriod = true;
            }
            querySet.add("org");
            querySet.add("booktype");
            querySet.add("period");
            querySet.add("endperiod");
            if (!queryParam.getAcctParam().isOnlyLeafAcctAmt()) {
                querySet.add("account");
            }
            String str = ((Object)querySet).toString();
            this.querySelector = str.substring(1, str.length() - 1);
            acctSet.add("id");
            str = ((Object)acctSet).toString();
            this.acctSelector = str.substring(1, str.length() - 1);
        }

        private List<String> getOriSel(String[] fields) {
            ArrayList<String> oriSel = new ArrayList<String>(fields.length);
            for (String field : fields) {
                int blank = (field = field.trim().toLowerCase()).indexOf(" ");
                if (blank == -1) {
                    oriSel.add(field);
                    continue;
                }
                oriSel.add(field.substring(0, blank));
            }
            return oriSel;
        }
    }
}

