/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.puchamt.cf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.multi.PropertyField;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ict.puchamt.CfPuchAmtQueryExecutor;
import kd.fi.ict.puchamt.cf.CfPuchAmtQueryParam;

public class CfPuchAmtQueryExecutorImpl
implements CfPuchAmtQueryExecutor {
    public static final Long YEAR_PERIOD_L = 10000L;
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("pamount", "camount", "curamount", "curnamount", "nocheckamount");
    private static final List<String> YEAR_AMOUNT_FIELDS = Arrays.asList("pyearamount", "cyearamount");
    private static final String CFITEM_SELECTOR = "id,number, masterid, parent.masterid pmasterid, isleaf, direction";
    private Set<Long> CFITEMIDS = new HashSet<Long>();
    private Set<Long> LEAFCFITEMIDS = new HashSet<Long>();
    private DataSet ALLCFITEMSET;
    private static final String TAG_LEAF = "_tag_leaf";

    @Override
    public DataSet getCfPuchAmt(CfPuchAmtQueryParam param) {
        this.checkPeriod(param.getBeginPeriodId(), param.getEndPeriodId());
        List<QFilter> filterList = this.buildFilter(param);
        return this.getCashFlow(filterList.toArray(new QFilter[filterList.size()]), param, null);
    }

    @Override
    public DataSet getCfPuchAmtEntity(CfPuchAmtQueryParam param, MainEntityType cashflowEntity) {
        this.checkPeriod(param.getBeginPeriodId(), param.getEndPeriodId());
        List<QFilter> filterList = this.buildFilter(param);
        return this.getCashFlow(filterList.toArray(new QFilter[filterList.size()]), param, cashflowEntity);
    }

    private DataSet getCashFlow(QFilter[] filters, CfPuchAmtQueryParam param, MainEntityType cashflowEntity) {
        StringBuilder aliasField = new StringBuilder();
        HashMap<String, String> sumSelectMap = new HashMap<String, String>();
        HashMap<String, String> groupSelectMap = new HashMap<String, String>();
        StringBuffer groupByField = new StringBuffer();
        if (!param.getSelector().contains("cfitem.direction")) {
            param.setSelector(param.getSelector() + ",cfitem.direction direction");
        }
        String[] strField = param.getSelector().split(",");
        LinkedHashSet<String> selectSet = new LinkedHashSet<String>(strField.length);
        for (int i = 0; i < strField.length; ++i) {
            String field = strField[i].trim();
            selectSet.add(field);
            PropertyField pField = new PropertyField(field);
            String name = pField.getName();
            String alias = pField.getAlias();
            aliasField.append(alias).append(",");
            if (AMOUNT_FIELDS.contains(name) || YEAR_AMOUNT_FIELDS.contains(name)) {
                sumSelectMap.put(name, alias);
                continue;
            }
            groupByField.append(alias).append(",");
            groupSelectMap.put(name, alias);
        }
        String selector = param.getSelector();
        if (StringUtils.isNotBlank((CharSequence)selector)) {
            if (!selectSet.contains("period")) {
                selector = selector + ",period";
            }
            if (!selectSet.contains("endperiod")) {
                selector = selector + ",endperiod";
            }
            selector = selector + ",period.periodyear endyear";
        }
        DataSet cashFlowData = this.getCashflowData(this.getClass().getName(), filters, cashflowEntity, selector);
        if (StringUtils.isNotBlank((CharSequence)groupByField)) {
            GroupbyDataSet group = cashFlowData.groupBy(groupByField.toString().split(","));
            for (Map.Entry entry : sumSelectMap.entrySet()) {
                String expr;
                String name = (String)entry.getKey();
                String alias = (String)entry.getValue();
                if (AMOUNT_FIELDS.contains(name)) {
                    expr = "case when period >=" + param.getBeginPeriodId() + " then " + alias + " else 0.0 end";
                    group.sum(expr, alias);
                    continue;
                }
                if (YEAR_AMOUNT_FIELDS.contains(name)) {
                    expr = "case when endperiod >" + param.getEndPeriodId() + " and period <=" + param.getEndPeriodId() + " and (period >" + param.getEndPeriodId() / YEAR_PERIOD_L * YEAR_PERIOD_L + ") then " + alias + " else 0.0 end";
                    group.sum(expr, alias);
                    continue;
                }
                if ("count".equals(name)) {
                    expr = "case when period =" + param.getBeginPeriodId() + " then " + alias + " else 0 end";
                    group.sum(expr, alias);
                    continue;
                }
                group.sum(alias);
            }
            cashFlowData = group.finish();
        }
        List<String> selList = this.getFieldsByDs(cashFlowData);
        if (groupSelectMap.get("cfitem") != null) {
            String cfitemAlias = (String)groupSelectMap.get("cfitem");
            cashFlowData = this.sumCfitemData(cashFlowData, groupSelectMap);
            DataSet acctDataSet = this.getCashFlowItem(CFITEM_SELECTOR, new QFilter[]{new QFilter("id", "in", this.CFITEMIDS)});
            selList.remove(cfitemAlias);
            cashFlowData = cashFlowData.join(acctDataSet, JoinType.INNER).on(cfitemAlias, "masterid").select(selList.toArray(new String[0]), new String[]{"id " + cfitemAlias}).finish();
        }
        cashFlowData = cashFlowData.select(aliasField.toString().split(","));
        return cashFlowData;
    }

    private DataSet sumCfitemData(DataSet cashFlowData, Map<String, String> groupSelectMap) {
        Field[] fields = cashFlowData.getRowMeta().getFields();
        HashSet<String> sumFieldSet = new HashSet<String>();
        HashSet<String> groupFieldSet = new HashSet<String>();
        ArrayList<String> selectSet = new ArrayList<String>(fields.length);
        HashSet<String> leftSelectSet = new HashSet<String>();
        for (Field field : fields) {
            String name = field.getName().toLowerCase();
            selectSet.add(name);
            if (!"cfitem".equalsIgnoreCase(name)) {
                leftSelectSet.add(name);
            }
            if (field.getDataType() instanceof BigDecimalType) {
                sumFieldSet.add(name);
                continue;
            }
            groupFieldSet.add(name);
        }
        String[] groupFields = groupFieldSet.toArray(new String[0]);
        String[] sumFields = sumFieldSet.toArray(new String[0]);
        String[] selector = selectSet.toArray(new String[0]);
        return this.accountSum(cashFlowData, groupFields, sumFields, selector, leftSelectSet, groupSelectMap);
    }

    private DataSet accountSum(DataSet cashFlowData, String[] groupFields, String[] sumFields, String[] selector, Set<String> leftSelector, Map<String, String> groupSelectMap) {
        DataSet ds;
        DataSet pacctDataSet = cashFlowData;
        DataSet sumDataSet = null;
        String cfitemAlias = groupSelectMap.get("cfitem");
        ArrayList<String> leftDc1 = new ArrayList<String>();
        leftDc1.addAll(leftSelector);
        leftDc1.removeIf(x -> x.equals("direction"));
        leftDc1.add("direction direction1");
        leftDc1.add(cfitemAlias);
        while ((ds = pacctDataSet.copy().join(this.ALLCFITEMSET.copy(), JoinType.INNER).on(cfitemAlias, "masterid").select(leftSelector.toArray(new String[0]), new String[]{"pmasterid " + cfitemAlias}).finish().filter(cfitemAlias + "!=0")).hasNext()) {
            ds = ds.join(this.ALLCFITEMSET.copy(), JoinType.INNER).on(cfitemAlias, "masterid").select(leftDc1.toArray(new String[0]), new String[]{"direction"}).finish().filter(cfitemAlias + "!=0");
            GroupbyDataSet group = ds.groupBy(groupFields);
            GroupbyDataSet groupbyDataSet = sumFields;
            int n = ((GroupbyDataSet)groupbyDataSet).length;
            for (int i = 0; i < n; ++i) {
                GroupbyDataSet sumField = groupbyDataSet[i];
                String sumStr = "case when (direction='b' and direction1='o') then " + (String)sumField + "*(-1) else " + (String)sumField + " end";
                group.sum(sumStr, (String)sumField);
            }
            pacctDataSet = group.finish().select(selector);
            sumDataSet = sumDataSet == null ? pacctDataSet : sumDataSet.union(pacctDataSet);
        }
        if (sumDataSet != null) {
            GroupbyDataSet group = sumDataSet.groupBy(groupFields);
            for (String sumField : sumFields) {
                group.sum(sumField);
            }
            sumDataSet = group.finish().select(selector);
            List<String> cols = this.getFieldsByDs(cashFlowData);
            sumDataSet = sumDataSet.select(cols.toArray(new String[0]));
            return cashFlowData.addField("true", TAG_LEAF).union(sumDataSet.addField("false", TAG_LEAF));
        }
        return cashFlowData.addField("true", TAG_LEAF);
    }

    private List<QFilter> buildFilter(CfPuchAmtQueryParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "in", (Object)param.getOrgIds()));
        if (param.getOpOrgIds() != null && param.getOpOrgIds().length > 0) {
            filters.add(new QFilter("oporg", "in", (Object)param.getOpOrgIds()));
        }
        filters.add(new QFilter("booktype", "=", (Object)param.getBookTypeId()));
        filters.add(new QFilter("period", "<=", (Object)param.getEndPeriodId()));
        if (param.getFilters() != null && param.getFilters().length > 0) {
            List<QFilter> parseFilters = this.parseFilter(param.getFilters(), param.getOrgIds()[0]);
            filters.addAll(parseFilters);
        }
        return filters;
    }

    private List<QFilter> parseFilter(QFilter[] filters, long orgId) {
        ArrayList<QFilter> qflist = new ArrayList<QFilter>();
        ArrayList<QFilter> qfCflist = new ArrayList<QFilter>();
        for (QFilter filter : filters) {
            String cfitemProperty = filter.getProperty();
            if (cfitemProperty.startsWith("cfitem")) {
                String refFiled = "";
                refFiled = "cfitem".equalsIgnoreCase(cfitemProperty) ? "id" : cfitemProperty.substring(7);
                qfCflist.add(new QFilter(refFiled, filter.getCP(), filter.getValue()));
                continue;
            }
            qflist.add(filter);
        }
        if (!qfCflist.isEmpty()) {
            DataSet cfitemIdSet = this.getCashFlowItem(CFITEM_SELECTOR, qfCflist.toArray(new QFilter[0]));
            HashSet<String> cfitemNumbers = new HashSet<String>(32);
            for (Row row : cfitemIdSet) {
                this.CFITEMIDS.add(row.getLong("id"));
                cfitemNumbers.add(row.getString("number"));
            }
            DataSet cfitemSet = this.getCashFlowItem(CFITEM_SELECTOR, new QFilter[]{new QFilter("number", "in", cfitemNumbers)});
            DataSet allLeafSet = this.getAllLeafCfItem(cfitemSet.copy(), cfitemSet);
            if (null != allLeafSet) {
                QFilter baseFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
                HashSet<Long> idSet = new HashSet<Long>();
                for (Row row : allLeafSet) {
                    idSet.add(row.getLong("id"));
                }
                DataSet allCFSet = this.getCashFlowItem(CFITEM_SELECTOR, new QFilter[]{baseFilter, new QFilter("id", "in", idSet)});
                List<String> allLeafList = this.getFieldsByDs(allCFSet);
                this.ALLCFITEMSET = allCFSet.groupBy(allLeafList.toArray(new String[0])).finish();
                if (!this.LEAFCFITEMIDS.isEmpty()) {
                    QFilter filter = new QFilter("cfitem", "in", this.LEAFCFITEMIDS);
                    qflist.add(filter);
                }
            }
        }
        return qflist;
    }

    private List<String> getFieldsByDs(DataSet dataSet) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (dataSet != null) {
            Field[] fields;
            for (Field field : fields = dataSet.getRowMeta().getFields()) {
                fieldNames.add(field.getAlias());
            }
        }
        return fieldNames;
    }

    private DataSet getAllLeafCfItem(DataSet levelCfitemSet, DataSet dataSet) {
        HashSet<Long> pSet = new HashSet<Long>();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long masterid = row.getLong("masterid");
            if (!row.getBoolean("isleaf").booleanValue()) {
                pSet.add(row.getLong("id"));
                pSet.add(masterid);
                continue;
            }
            this.LEAFCFITEMIDS.add(masterid);
        }
        QFilter qFilter = new QFilter("parent", "in", pSet);
        DataSet ds = this.getCashFlowItem(CFITEM_SELECTOR, qFilter.toArray());
        if (levelCfitemSet != null) {
            levelCfitemSet = levelCfitemSet.union(ds.copy());
        }
        if (ds.hasNext()) {
            return this.getAllLeafCfItem(levelCfitemSet, ds);
        }
        return levelCfitemSet;
    }

    private DataSet getCashFlowItem(String sel, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_cashflowitem", (String)sel, (QFilter[])filters, null);
    }

    private void checkPeriod(long beginPeriodId, long endPeriodId) {
        if (beginPeriodId > endPeriodId) {
            throw new IllegalArgumentException();
        }
    }

    private DataSet getCashflowData(String algoKey, QFilter[] filters, MainEntityType cashflowEntity, String querySelector) {
        DataSet cashflow;
        if (cashflowEntity != null) {
            ORM orm = ORM.create();
            orm.setDataEntityType("ict_cfpuchamt", (IDataEntityType)cashflowEntity);
            cashflow = orm.queryDataSet(algoKey, "ict_cfpuchamt", querySelector, filters);
        } else {
            cashflow = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ict_cfpuchamt", (String)querySelector, (QFilter[])filters, null);
        }
        return cashflow;
    }
}

